/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.WeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

abstract class SimpleWeaponRenderer
extends WeaponRenderer<WeaponItem> {
    private final float recoilAngle;
    private final float recoilDistance;
    private final int recoilAnimationTime;

    SimpleWeaponRenderer(float recoilAngle, float recoilDistance, int recoilAnimationTime) {
        this.recoilAngle = recoilAngle;
        this.recoilDistance = recoilDistance;
        this.recoilAnimationTime = recoilAnimationTime;
    }

    protected abstract TranslucentFillModel getMagazineFillModel();

    protected abstract float applyAnimationCurve(float var1);

    protected void renderModelLayers(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        this.rootBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.rootEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, light);
    }

    @Override
    public void onWeaponFired(ItemStack stack, WeaponItem weaponItem, ClientWeaponControls controls) {
        controls.getAnimationTimerA().startTimer(this.recoilAnimationTime);
    }

    @Override
    protected void loadWeaponModelParts(WeaponItem item, ItemLayerBakedModel model) {
    }

    @Override
    protected final void renderStaticWeapon(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        this.renderModelLayers(poseStack, bufferSource, light, overlay);
        this.renderStaticMagazineFill(item, stack, poseStack, bufferSource, this.getMagazineFillModel(), LTXIConstants.LIME_GREEN);
    }

    @Override
    protected final void renderWeaponFirstPerson(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTick, ClientWeaponControls controls) {
        float mul = this.applyAnimationCurve(controls.getAnimationTimerA().lerpProgressNotPaused(partialTick));
        poseStack.translate(0.0f, 0.0f, this.recoilDistance * mul);
        if (this.recoilAngle > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(this.recoilAngle * mul));
        }
        this.renderModelLayers(poseStack, bufferSource, light, overlay);
        this.renderAnimatedMagazineFill(item, stack, poseStack, bufferSource, this.getMagazineFillModel(), LTXIConstants.LIME_GREEN, partialTick, controls);
    }
}

