/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.ItemGuiRenderOverride;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.gui.UpgradeIconRenderers;
import liedge.ltxindustries.item.UpgradeModuleItem;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import liedge.ltxindustries.util.config.LTXIClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public final class UpgradeModuleItemExtensions
implements ItemGuiRenderOverride {
    private static final UpgradeModuleItemExtensions INSTANCE = new UpgradeModuleItemExtensions();

    private static boolean shouldShowIcon() {
        return Minecraft.getInstance().screen != null && (Screen.hasShiftDown() || LTXIClientConfig.ALWAYS_SHOW_UPGRADE_ICONS.getAsBoolean());
    }

    public static UpgradeModuleItemExtensions getInstance() {
        return INSTANCE;
    }

    private UpgradeModuleItemExtensions() {
    }

    public boolean renderIconWithRankBar(GuiGraphics graphics, UpgradeBaseEntry<?> entry, int x, int y) {
        UpgradeIcon icon = ((UpgradeBase)entry.upgrade().value()).display().icon();
        if (!UpgradeIconRenderers.renderIcon(graphics, icon, x, y)) {
            return false;
        }
        int rank = entry.upgradeRank();
        int maxRank = ((UpgradeBase)entry.upgrade().value()).maxRank();
        if (maxRank > 1 && rank < maxRank) {
            graphics.pose().pushPose();
            this.renderGradientBar(graphics, x + 1, y + 1, x + 3, y + 15, -11908534, -16777216);
            float yo = 14.0f - 14.0f * LimaCoreMath.divideFloat((float)rank, (float)maxRank);
            this.renderGradientBar(graphics, x + 1, (float)(y + 1) + yo, x + 3, y + 15, LTXIConstants.UPGRADE_RANK_MAGENTA.argb32(), -3063824);
            graphics.pose().popPose();
        }
        return true;
    }

    public boolean renderCustomGuiItem(GuiGraphics graphics, ItemStack stack, int x, int y) {
        UpgradeModuleItem moduleItem;
        UpgradeBaseEntry entry;
        Item item = stack.getItem();
        if (item instanceof UpgradeModuleItem && (entry = (UpgradeBaseEntry)stack.get((moduleItem = (UpgradeModuleItem)item).entryComponentType())) != null && UpgradeModuleItemExtensions.shouldShowIcon()) {
            return this.renderIconWithRankBar(graphics, entry, x, y);
        }
        return false;
    }

    private void renderGradientBar(GuiGraphics graphics, float x1, float y1, float x2, float y2, int topColor, int bottomColor) {
        Matrix4f mx4 = graphics.pose().last().pose();
        VertexConsumer buffer = graphics.bufferSource().getBuffer(RenderType.gui());
        buffer.addVertex(mx4, x1, y1, 300.0f).setColor(topColor);
        buffer.addVertex(mx4, x1, y2, 300.0f).setColor(bottomColor);
        buffer.addVertex(mx4, x2, y2, 300.0f).setColor(bottomColor);
        buffer.addVertex(mx4, x2, y1, 300.0f).setColor(topColor);
        graphics.flush();
    }
}

