/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.LimaCoreClientUtil;
import liedge.limacore.client.LimaSpecialItemRenderer;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.client.model.baked.BakedItemLayer;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaCoreUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.LTXIArmPoses;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class WeaponRenderer<T extends WeaponItem>
extends LimaSpecialItemRenderer<T>
implements IClientItemExtensions {
    static final ResourceLocation HOLLOW_DOT = LTXIndustries.RESOURCES.location("crosshair/hollow_dot");
    static final ResourceLocation CIRCLE_BRACKET = LTXIndustries.RESOURCES.location("crosshair/circle_bracket");
    static final ResourceLocation ANGLE_BRACKET = LTXIndustries.RESOURCES.location("crosshair/angle_bracket");
    static final ResourceLocation AOE_HORIZONTAL = LTXIndustries.RESOURCES.location("crosshair/aoe_h");
    static final ResourceLocation AOE_VERTICAL = LTXIndustries.RESOURCES.location("crosshair/aoe_v");
    static final ResourceLocation HEAVY_PISTOL_CROSSHAIR = LTXIndustries.RESOURCES.location("crosshair/heavy_pistol");
    protected BakedItemLayer rootBaseLayer;
    protected BakedItemLayer rootEmissiveLayer;
    private GuiSpriteManager sprites;

    public static WeaponRenderer<?> fromItem(WeaponItem weaponItem) {
        return (WeaponRenderer)((Object)LimaCoreUtil.castOrThrow(WeaponRenderer.class, (Object)IClientItemExtensions.of((Item)weaponItem)));
    }

    protected void onResourceManagerReload(ResourceManager manager, T item) {
        ItemLayerBakedModel model = (ItemLayerBakedModel)LimaCoreClientUtil.getCustomBakedModel((ModelResourceLocation)LimaCoreClientUtil.inventoryModelPath(item), ItemLayerBakedModel.class);
        this.rootBaseLayer = model.getLayer("root");
        this.rootEmissiveLayer = model.getLayer("root emissive");
        this.sprites = Minecraft.getInstance().getGuiSprites();
        this.loadWeaponModelParts(item, model);
    }

    protected void renderCustomItem(ItemStack stack, T item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
        if (this.isFirstPersonMainHand(displayContext) && Minecraft.getInstance().player != null) {
            ClientWeaponControls controls = ClientWeaponControls.of((Player)Minecraft.getInstance().player);
            this.renderWeaponFirstPerson(stack, item, displayContext, poseStack, bufferSource, light, overlay, partialTick, controls);
        } else {
            this.renderStaticWeapon(stack, item, displayContext, poseStack, bufferSource, light, overlay);
        }
    }

    public final BlockEntityWithoutLevelRenderer getCustomRenderer() {
        return this;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack heldItem) {
        Item item;
        if (hand == InteractionHand.MAIN_HAND && (item = heldItem.getItem()) instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            ItemStack offHandStack = entity.getOffhandItem();
            if (offHandStack.isEmpty()) {
                return (HumanoidModel.ArmPose)LTXIArmPoses.TWO_HANDED_WEAPON.getValue();
            }
            if (entity.isUsingItem() && entity.getUsedItemHand() == InteractionHand.OFF_HAND && offHandStack.canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
                return (HumanoidModel.ArmPose)LTXIArmPoses.WEAPON_SHIELD_POSE.getValue();
            }
            if (weaponItem.isOneHanded(heldItem)) {
                return (HumanoidModel.ArmPose)LTXIArmPoses.ONE_HANDED_WEAPON.getValue();
            }
        }
        return HumanoidModel.ArmPose.EMPTY;
    }

    public abstract void renderCrosshair(LocalPlayer var1, WeaponItem var2, ClientWeaponControls var3, GuiGraphics var4, float var5, int var6, int var7, LimaColor var8);

    public abstract void onWeaponFired(ItemStack var1, WeaponItem var2, ClientWeaponControls var3);

    protected abstract void loadWeaponModelParts(T var1, ItemLayerBakedModel var2);

    protected abstract void renderStaticWeapon(ItemStack var1, T var2, ItemDisplayContext var3, PoseStack var4, MultiBufferSource var5, int var6, int var7);

    protected abstract void renderWeaponFirstPerson(ItemStack var1, T var2, ItemDisplayContext var3, PoseStack var4, MultiBufferSource var5, int var6, int var7, float var8, ClientWeaponControls var9);

    protected void renderStaticMagazineFill(T item, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, TranslucentFillModel fillModel, LimaColor color) {
        float fill = Math.min(LimaCoreMath.divideFloat((float)((WeaponItem)item).getAmmoLoaded(stack), (float)((WeaponItem)item).getAmmoCapacity(stack)), 1.0f);
        if (fill > 0.0f) {
            VertexConsumer buffer = bufferSource.getBuffer(LTXIRenderTypes.POSITION_COLOR_QUADS);
            fillModel.renderRotated(buffer, poseStack, color, fill);
        }
    }

    protected void renderAnimatedMagazineFill(T item, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, TranslucentFillModel fillModel, LimaColor color, float partialTick, ClientWeaponControls controls) {
        if (!controls.getReloadTimer().isRunningClient()) {
            this.renderStaticMagazineFill(item, stack, poseStack, bufferSource, fillModel, color);
        } else {
            float mul = controls.getReloadTimer().lerpProgressNotPaused(partialTick);
            VertexConsumer buffer = bufferSource.getBuffer(LTXIRenderTypes.POSITION_COLOR_QUADS);
            fillModel.renderRotated(buffer, poseStack, color, mul);
        }
    }

    protected void blitSprite(GuiGraphics graphics, float x, float y, int width, int height, LimaColor crosshairColor, ResourceLocation spriteLocation) {
        LimaGuiUtil.directColorBlit((GuiGraphics)graphics, (float)x, (float)y, (int)width, (int)height, (float)crosshairColor.red(), (float)crosshairColor.green(), (float)crosshairColor.blue(), (float)1.0f, (TextureAtlasSprite)this.sprites.getSprite(spriteLocation));
    }

    protected void blitMirroredUSprite(GuiGraphics graphics, float x, float y, int width, int height, LimaColor crosshairColor, ResourceLocation spriteLocation) {
        TextureAtlasSprite sprite = this.sprites.getSprite(spriteLocation);
        LimaGuiUtil.directColorBlit((GuiGraphics)graphics, (ResourceLocation)sprite.atlasLocation(), (float)x, (float)y, (float)(x + (float)width), (float)(y + (float)height), (int)0, (float)sprite.getU1(), (float)sprite.getU0(), (float)sprite.getV0(), (float)sprite.getV1(), (float)crosshairColor.red(), (float)crosshairColor.green(), (float)crosshairColor.blue(), (float)1.0f);
    }

    protected void blitMirroredVSprite(GuiGraphics graphics, float x, float y, int width, int height, LimaColor crosshairColor, ResourceLocation spriteLocation) {
        TextureAtlasSprite sprite = this.sprites.getSprite(spriteLocation);
        LimaGuiUtil.directColorBlit((GuiGraphics)graphics, (ResourceLocation)sprite.atlasLocation(), (float)x, (float)y, (float)(x + (float)width), (float)(y + (float)height), (int)0, (float)sprite.getU0(), (float)sprite.getU1(), (float)sprite.getV1(), (float)sprite.getV0(), (float)crosshairColor.red(), (float)crosshairColor.green(), (float)crosshairColor.blue(), (float)1.0f);
    }
}

