/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import com.mojang.datafixers.util.Function3;
import java.util.function.Function;
import liedge.limacore.data.generation.LimaBlockStateProvider;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.LTXIBlockProperties;
import liedge.ltxindustries.block.MachineState;
import liedge.ltxindustries.block.NeonLightColor;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

class BlockStatesGen
extends LimaBlockStateProvider {
    private final ModelFile machineParticlesOnly = this.existingModel(this.blockFolderLocation("machine_particles"));
    private final ModelFile turretBase = this.existingModel(this.blockFolderLocation("turret_base"));
    private final ModelFile basicMachineSEW = this.existingModel(this.blockFolderLocation("basic_machine_sew"));
    private final ModelFile basicMachineNSEW = this.existingModel(this.blockFolderLocation("basic_machine_nsew"));

    BlockStatesGen(PackOutput output, ExistingFileHelper helper) {
        super(output, LTXIndustries.RESOURCES, helper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder glowingOre = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("glowing_ore")).parent(this.mcBlockBlock)).renderType("cutout")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((side, face) -> face.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0").cullface(side)).end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((side, face) -> face.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1").cullface(side)).emissivity(9, 9).shade(false).ao(false).end();
        this.cubeAll((Holder)LTXIBlocks.TITANIUM_ORE);
        this.cubeAll((Holder)LTXIBlocks.DEEPSLATE_TITANIUM_ORE);
        this.simpleBlockWithItem((Holder)LTXIBlocks.NIOBIUM_ORE, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBlockBuilder((Holder)LTXIBlocks.NIOBIUM_ORE).parent((ModelFile)glowingOre)).texture("particle", this.blockFolderLocation(Blocks.END_STONE))).texture("0", this.blockFolderLocation("niobium_ore_0"))).texture("1", this.blockFolderLocation("niobium_ore_1")));
        this.cubeAll((Holder)LTXIBlocks.RAW_TITANIUM_BLOCK);
        this.cubeAll((Holder)LTXIBlocks.RAW_NIOBIUM_BLOCK);
        this.oreCluster((Holder<Block>)LTXIBlocks.RAW_TITANIUM_CLUSTER, this.blockFolderLocation(ModResources.MC, "basalt_top"), (Holder<Block>)LTXIBlocks.RAW_TITANIUM_BLOCK);
        this.oreCluster((Holder<Block>)LTXIBlocks.RAW_NIOBIUM_CLUSTER, this.blockFolderLocation(Blocks.END_STONE), (Holder<Block>)LTXIBlocks.RAW_NIOBIUM_BLOCK);
        this.cubeAll((Holder)LTXIBlocks.TITANIUM_BLOCK);
        this.cubeAll((Holder)LTXIBlocks.NIOBIUM_BLOCK);
        this.cubeAll((Holder)LTXIBlocks.SLATESTEEL_BLOCK);
        ModelBuilder neonLightModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("neon_light_base", "block/block")).texture("particle", "#all")).ao(false)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((side, face) -> face.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").cullface(side)).emissivity(15, 15).shade(false).end();
        LTXIBlocks.NEON_LIGHTS.forEach((arg_0, arg_1) -> this.lambda$registerStatesAndModels$3((ModelFile)neonLightModel, arg_0, arg_1));
        this.cubeAll((Holder)LTXIBlocks.TITANIUM_PANEL);
        this.cubeAll((Holder)LTXIBlocks.SMOOTH_TITANIUM_PANEL);
        this.cubeAll((Holder)LTXIBlocks.TITANIUM_GLASS).renderType("cutout");
        this.cubeAll((Holder)LTXIBlocks.SLATESTEEL_PANEL);
        this.cubeAll((Holder)LTXIBlocks.SMOOTH_SLATESTEEL_PANEL);
        this.sparkFruit((Holder<Block>)LTXIBlocks.SPARK_FRUIT);
        this.berryVines((Holder<Block>)LTXIBlocks.BILEVINE, (Property<?>[])new Property[]{BlockStateProperties.AGE_25});
        this.berryVines((Holder<Block>)LTXIBlocks.BILEVINE_PLANT, (Property<?>[])new Property[0]);
        this.simpleBlock((Holder)LTXIBlocks.GLOOM_SHROOM, this.existingModel(this.blockFolderLocation((Holder)LTXIBlocks.GLOOM_SHROOM)));
        this.horizontalBlock((Block)LTXIBlocks.ENERGY_CELL_ARRAY.get(), this.existingModel(this.blockFolderLocation((Holder)LTXIBlocks.ENERGY_CELL_ARRAY)));
        this.horizontalBlock((Block)LTXIBlocks.INFINITE_ENERGY_CELL_ARRAY.get(), this.existingModel(this.blockFolderLocation((Holder)LTXIBlocks.INFINITE_ENERGY_CELL_ARRAY)));
        this.cookingMachine((Holder<Block>)LTXIBlocks.DIGITAL_FURNACE);
        this.cookingMachine((Holder<Block>)LTXIBlocks.DIGITAL_SMOKER);
        this.cookingMachine((Holder<Block>)LTXIBlocks.DIGITAL_BLAST_FURNACE);
        this.basicFrameStateMachine((Holder<Block>)LTXIBlocks.GRINDER, (Function3<MachineState, ResourceLocation, BlockModelBuilder, BlockModelBuilder>)((Function3)(state, $, builder) -> (BlockModelBuilder)builder.parent(this.basicMachineSEW)));
        this.emissiveFrontMachine((Holder<Block>)LTXIBlocks.MATERIAL_FUSING_CHAMBER);
        this.stateMachineBase((Holder<Block>)LTXIBlocks.ELECTROCENTRIFUGE);
        this.stateMachineBase((Holder<Block>)LTXIBlocks.MIXER);
        this.stateMachineBase((Holder<Block>)LTXIBlocks.VOLTAIC_INJECTOR);
        this.stateMachineBase((Holder<Block>)LTXIBlocks.CHEM_LAB);
        this.stateMachineBase((Holder<Block>)LTXIBlocks.ASSEMBLER);
        this.primaryMeshBlock((Holder<Block>)LTXIBlocks.FABRICATOR);
        this.simpleBlockItem((Holder)LTXIBlocks.FABRICATOR);
        this.horizontalBlock((Holder<Block>)LTXIBlocks.AUTO_FABRICATOR);
        this.simpleBlockWithItem((Holder)LTXIBlocks.EQUIPMENT_UPGRADE_STATION);
        this.primaryMeshBlock((Holder<Block>)LTXIBlocks.MOLECULAR_RECONSTRUCTOR);
        this.simpleBlockItem((Holder)LTXIBlocks.MOLECULAR_RECONSTRUCTOR);
        this.primaryMeshBlock((Holder<Block>)LTXIBlocks.DIGITAL_GARDEN);
        this.primaryMeshBlock((Holder<Block>)LTXIBlocks.ROCKET_TURRET, this.turretBase);
        this.primaryMeshBlock((Holder<Block>)LTXIBlocks.RAILGUN_TURRET, this.turretBase);
        this.liquidBlock((Holder)LTXIBlocks.VIRIDIC_ACID_BLOCK);
        this.surfaceStickingBlock((Holder<Block>)LTXIBlocks.GLOWSTICK, state -> this.existingModel(this.blockFolderLocation(state.getBlock())));
        this.getVariantBuilder((Holder)LTXIBlocks.MESH_BLOCK).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.machineParticlesOnly).build(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED});
    }

    private void surfaceStickingBlock(Holder<Block> holder, Function<BlockState, ModelFile> modelFunction) {
        this.getVariantBuilder(holder).forAllStatesExcept(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply((BlockState)state));
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            if (facing == Direction.DOWN) {
                builder.rotationX(180);
            } else if (facing != Direction.UP) {
                builder.rotationX(90);
                builder.rotationY(this.getRotationY(facing));
            }
            return builder.build();
        }, new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void oreCluster(Holder<Block> clusterBlock, ResourceLocation baseTexture, Holder<Block> rawOreBlock) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.getBlockBuilder(clusterBlock).parent(this.existingModel(this.blockFolderLocation("raw_ore_cluster")))).texture("base", baseTexture)).texture("ore", this.blockFolderLocation(rawOreBlock));
        this.surfaceStickingBlock(clusterBlock, arg_0 -> BlockStatesGen.lambda$oreCluster$8((ModelFile)model, arg_0));
        this.simpleBlockItem(clusterBlock, (ModelFile)model);
    }

    private void sparkFruit(Holder<Block> holder) {
        this.getVariantBuilder(holder).forAllStates(state -> {
            String name = LimaRegistryUtil.getBlockName((Holder)holder);
            int age = (Integer)state.getValue((Property)BlockStateProperties.AGE_2);
            ModelFile model = this.existingModel(this.blockFolderLocation(name + "_" + age));
            return ConfiguredModel.builder().modelFile(model).build();
        });
    }

    private void berryVines(Holder<Block> holder, Property<?> ... ignoredProperties) {
        this.getVariantBuilder(holder).forAllStatesExcept(state -> {
            Object name = LimaRegistryUtil.getBlockName((Holder)holder);
            if (((Boolean)state.getValue((Property)BlockStateProperties.BERRIES)).booleanValue()) {
                name = (String)name + "_lit";
            }
            ModelBuilder model = ((BlockModelBuilder)this.models().cross((String)name, this.blockFolderLocation((String)name))).renderType("cutout");
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, ignoredProperties);
    }

    private void horizontalBlock(Holder<Block> holder) {
        ModelFile model = this.existingModel(this.blockFolderLocation(holder));
        this.horizontalBlock((Block)holder.value(), model, 180);
    }

    private void stateMachine(Holder<Block> holder, Function<MachineState, ModelFile> modelMapper) {
        this.getVariantBuilder(holder).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelMapper.apply((MachineState)((Object)((Object)state.getValue(LTXIBlockProperties.BINARY_MACHINE_STATE))))).rotationY(this.getRotationY((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).build(), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void stateMachineBase(Holder<Block> holder) {
        ResourceLocation pathBase = this.blockFolderLocation(holder);
        this.stateMachine(holder, state -> this.models().getExistingFile(pathBase.withSuffix("_" + state.getSerializedName())));
    }

    private void primaryMeshBlock(Holder<Block> holder, ModelFile model) {
        this.getVariantBuilder(holder).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(model).rotationY(this.getRotationY((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).build(), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private void primaryMeshBlock(Holder<Block> holder) {
        this.primaryMeshBlock(holder, this.existingModel(this.blockFolderLocation(holder)));
    }

    private void basicFrameStateMachine(Holder<Block> holder, Function3<MachineState, ResourceLocation, BlockModelBuilder, BlockModelBuilder> operator) {
        Function<MachineState, String> nameFunction = state -> LimaRegistryUtil.getBlockName((Holder)holder) + "_" + state.getSerializedName();
        ResourceLocation pathBase = this.blockFolderLocation(holder);
        this.stateMachine(holder, state -> (ModelFile)operator.apply((Object)state, (Object)pathBase, (Object)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder((String)nameFunction.apply((MachineState)((Object)state)))).texture("front", pathBase.withSuffix("_" + state.getSerializedName())))));
        this.simpleBlockItem(holder, (ModelFile)this.models().getBuilder(nameFunction.apply(MachineState.IDLE)));
    }

    private void emissiveFrontMachine(Holder<Block> holder) {
        this.basicFrameStateMachine(holder, (Function3<MachineState, ResourceLocation, BlockModelBuilder, BlockModelBuilder>)((Function3)(state, pathBase, builder) -> {
            if (state == MachineState.IDLE) {
                return (BlockModelBuilder)builder.parent(this.basicMachineSEW);
            }
            return (BlockModelBuilder)((BlockModelBuilder)builder.parent(this.basicMachineNSEW)).texture("front_emissive", pathBase.withSuffix("_" + state.getSerializedName() + "_emissive"));
        }));
    }

    private void cookingMachine(Holder<Block> holder) {
        ResourceLocation basicMachineMesh = this.blockFolderLocation("basic_machine_mesh");
        this.basicFrameStateMachine(holder, (Function3<MachineState, ResourceLocation, BlockModelBuilder, BlockModelBuilder>)((Function3)(state, pathBase, builder) -> {
            if (state == MachineState.IDLE) {
                return (BlockModelBuilder)((BlockModelBuilder)builder.parent(this.basicMachineSEW)).texture("top", basicMachineMesh);
            }
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)builder.parent(this.basicMachineNSEW)).texture("front_emissive", pathBase.withSuffix("_" + state.getSerializedName() + "_emissive"))).texture("top", basicMachineMesh);
        }));
    }

    private static /* synthetic */ ModelFile lambda$oreCluster$8(ModelFile model, BlockState ignored) {
        return model;
    }

    private /* synthetic */ void lambda$registerStatesAndModels$3(ModelFile neonLightModel, NeonLightColor color, DeferredBlock holder) {
        this.simpleBlockWithItem((Holder)holder, (ModelFile)((BlockModelBuilder)this.getBlockBuilder((Holder)holder).parent(neonLightModel)).texture("all", this.blockFolderLocation("neon_light/" + color.toString())));
    }
}

