/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import java.util.Arrays;
import java.util.stream.Stream;
import liedge.limacore.data.generation.LimaItemModelProvider;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXIItemOverrides;
import liedge.ltxindustries.client.model.baked.EmissiveBiLayerGeometry;
import liedge.ltxindustries.registry.game.LTXIFluids;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

class ItemModelGen
extends LimaItemModelProvider {
    ItemModelGen(PackOutput output, ExistingFileHelper helper) {
        super(output, LTXIndustries.RESOURCES, helper);
    }

    protected void registerModels() {
        this.generated(new ItemLike[]{LTXIItems.RAW_TITANIUM, LTXIItems.TITANIUM_INGOT, LTXIItems.TITANIUM_NUGGET, LTXIItems.RAW_NIOBIUM, LTXIItems.NIOBIUM_INGOT, LTXIItems.NIOBIUM_NUGGET, LTXIItems.SPARK_FRUIT, LTXIItems.VITRIOL_BERRIES, LTXIItems.GLOOM_SHROOM, LTXIItems.CIRCUIT_BOARD, LTXIItems.T1_CIRCUIT, LTXIItems.T2_CIRCUIT, LTXIItems.T3_CIRCUIT, LTXIItems.T4_CIRCUIT, LTXIItems.T5_CIRCUIT, LTXIItems.CARBON_DUST, LTXIItems.RESINOUS_BIOMASS, LTXIItems.ACIDIC_BIOMASS, LTXIItems.DEEPSLATE_DUST, LTXIItems.ELECTRIC_CHEMICAL, LTXIItems.MONOMER_CHEMICAL, LTXIItems.VIRIDIC_WEAPON_CHEMICAL, LTXIItems.CHORUS_CHEMICAL, LTXIItems.SCULK_CHEMICAL, LTXIItems.NEURO_CHEMICAL, LTXIItems.SLATESTEEL_INGOT, LTXIItems.POLYMER_INGOT, LTXIItems.SLATESTEEL_NUGGET, LTXIItems.EMPTY_UPGRADE_MODULE, LTXIItems.EQUIPMENT_UPGRADE_MODULE, LTXIItems.MACHINE_UPGRADE_MODULE, LTXIItems.EMPTY_FABRICATION_BLUEPRINT, LTXIItems.FABRICATION_BLUEPRINT, LTXIItems.ITEMS_IO_CONFIG_CARD, LTXIItems.ENERGY_IO_CONFIG_CARD, LTXIItems.FLUIDS_IO_CONFIG_CARD, LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, LTXIItems.SPECIALIST_WEAPON_ENERGY, LTXIItems.EXPLOSIVES_WEAPON_ENERGY, LTXIItems.HEAVY_WEAPON_ENERGY});
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.getBuilder((ItemLike)LTXIItems.VIRIDIC_ACID_BUCKET).parent(this.existingModel(this.itemFolderLocation(ModResources.NEOFORGE, "bucket")))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid((Fluid)LTXIFluids.VIRIDIC_ACID.get()).end();
        this.pigments(new ItemLike[]{LTXIItems.LTX_LIME_PIGMENT, LTXIItems.ENERGY_BLUE_PIGMENT, LTXIItems.ELECTRIC_CHARTREUSE_PIGMENT, LTXIItems.VIRIDIC_GREEN_PIGMENT, LTXIItems.NEURO_BLUE_PIGMENT});
        this.orePebbles(new ItemLike[]{LTXIItems.COAL_ORE_PEBBLES, LTXIItems.COPPER_ORE_PEBBLES, LTXIItems.IRON_ORE_PEBBLES, LTXIItems.LAPIS_ORE_PEBBLES, LTXIItems.REDSTONE_ORE_PEBBLES, LTXIItems.GOLD_ORE_PEBBLES, LTXIItems.DIAMOND_ORE_PEBBLES, LTXIItems.EMERALD_ORE_PEBBLES, LTXIItems.QUARTZ_ORE_PEBBLES, LTXIItems.NETHERITE_ORE_PEBBLES, LTXIItems.TITANIUM_ORE_PEBBLES, LTXIItems.NIOBIUM_ORE_PEBBLES, LTXIItems.TIN_ORE_PEBBLES, LTXIItems.OSMIUM_ORE_PEBBLES, LTXIItems.NICKEL_ORE_PEBBLES, LTXIItems.LEAD_ORE_PEBBLES, LTXIItems.SILVER_ORE_PEBBLES, LTXIItems.URANIUM_ORE_PEBBLES});
        this.generated(this.itemFolderLocation("tech_salvage"), new ItemLike[]{LTXIItems.EXPLOSIVES_WEAPON_TECH_SALVAGE, LTXIItems.TARGETING_TECH_SALVAGE});
        this.emissiveBiLayerModels(this.generatedModel, new ItemLike[]{LTXIItems.LTX_SHEARS, LTXIItems.LTX_LIGHTER});
        this.emissiveBiLayerModels(this.handheldModel, new ItemLike[]{LTXIItems.LTX_DRILL, LTXIItems.LTX_SWORD, LTXIItems.LTX_SHOVEL, LTXIItems.LTX_AXE, LTXIItems.LTX_HOE, LTXIItems.LTX_WRENCH});
        ModelFile.UncheckedModelFile rodModel = new ModelFile.UncheckedModelFile("item/handheld_rod");
        ItemModelBuilder ltxCastFishingRod = this.emissiveBiLayer("ltx_fishing_rod_cast", (ModelFile)rodModel, this.itemFolderLocation("ltx_fishing_rod_cast_base"), this.itemFolderLocation("ltx_fishing_rod_emissive"));
        this.emissiveBiLayer("ltx_fishing_rod", (ModelFile)rodModel, this.itemFolderLocation("ltx_fishing_rod_base"), this.itemFolderLocation("ltx_fishing_rod_emissive")).override().model((ModelFile)ltxCastFishingRod).predicate(LTXIItemOverrides.FISHING_ROD_CAST, 1.0f).end();
        ResourceLocation brushBaseTex = this.itemFolderLocation("ltx_brush_base");
        ResourceLocation brushEmissiveTex = this.itemFolderLocation("ltx_brush_emissive");
        ItemModelBuilder brushing0 = this.emissiveBiLayer("ltx_brush_brushing_0", this.existingModel(this.itemFolderLocation(ModResources.MC, "brush_brushing_0")), brushBaseTex, brushEmissiveTex);
        ItemModelBuilder brushing1 = this.emissiveBiLayer("ltx_brush_brushing_1", this.existingModel(this.itemFolderLocation(ModResources.MC, "brush_brushing_1")), brushBaseTex, brushEmissiveTex);
        ItemModelBuilder brushing2 = this.emissiveBiLayer("ltx_brush_brushing_2", this.existingModel(this.itemFolderLocation(ModResources.MC, "brush_brushing_2")), brushBaseTex, brushEmissiveTex);
        this.emissiveBiLayer("ltx_brush", this.existingModel(this.itemFolderLocation(ModResources.MC, "brush")), brushBaseTex, brushEmissiveTex).override().model((ModelFile)brushing0).predicate(LTXIItemOverrides.BRUSH_BRUSHING, 0.25f).end().override().model((ModelFile)brushing1).predicate(LTXIItemOverrides.BRUSH_BRUSHING, 0.5f).end().override().model((ModelFile)brushing2).predicate(LTXIItemOverrides.BRUSH_BRUSHING, 0.75f).end();
    }

    private ItemModelBuilder emissiveBiLayer(String path, ModelFile parent, ResourceLocation baseTexture, ResourceLocation emissiveTexture) {
        return (ItemModelBuilder)((BiLayerBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent(parent)).texture("layer0", baseTexture)).texture("layer1", emissiveTexture)).customLoader(BiLayerBuilder::new)).end();
    }

    private void emissiveBiLayerModels(ModelFile parent, ItemLike ... items) {
        Arrays.stream(items).forEach(i -> this.emissiveBiLayerModel((ItemLike)i, parent));
    }

    private void emissiveBiLayerModel(ItemLike itemLike, ModelFile parent) {
        String name = LimaRegistryUtil.getItemName((Item)itemLike.asItem());
        this.emissiveBiLayer(name, parent, this.itemFolderLocation(name + "_base"), this.itemFolderLocation(name + "_emissive"));
    }

    private void pigments(ItemLike ... pigments) {
        for (ItemLike item : pigments) {
            String name = LimaRegistryUtil.getItemName((Item)item.asItem()).split("_pigment")[0];
            this.generated(item, this.itemFolderLocation("pigment/" + name));
        }
    }

    private void orePebbles(ItemLike ... pebbles) {
        for (ItemLike item : pebbles) {
            String name = LimaRegistryUtil.getItemName((Item)item.asItem()).split("_")[0];
            this.generated(item, this.itemFolderLocation("ore_pebble/" + name));
        }
    }

    private void generated(ResourceLocation texture, ItemLike ... items) {
        Stream.of(items).forEach(i -> this.generated((ItemLike)i, texture));
    }

    private static class BiLayerBuilder<T extends ModelBuilder<T>>
    extends CustomLoaderBuilder<T> {
        private BiLayerBuilder(T parent, ExistingFileHelper existingFileHelper) {
            super(EmissiveBiLayerGeometry.LOADER_ID, parent, existingFileHelper, false);
        }
    }
}

