/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import liedge.ltxindustries.lib.upgrades.effect.value.DoubleLevelBasedValue;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltip;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueArgument;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueFormat;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueSentiment;
import net.minecraft.world.level.ItemLike;

public final class LTXIBootstrapUtil {
    private LTXIBootstrapUtil() {
    }

    public static UpgradeIcon bottomRightComposite(UpgradeIcon background, UpgradeIcon overlay, int overlaySize, int padding) {
        int offset = 16 - overlaySize - padding;
        return UpgradeIcon.compositeIcon(background, overlay, overlaySize, offset, offset);
    }

    public static UpgradeIcon bottomRightComposite(UpgradeIcon background, UpgradeIcon overlay, int overlaySize) {
        return LTXIBootstrapUtil.bottomRightComposite(background, overlay, overlaySize, 1);
    }

    public static UpgradeIcon spriteOverItemIcon(ItemLike bgItem, String spritePath, int spriteSize) {
        return LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.itemIcon(bgItem), UpgradeIcon.sprite(spritePath), spriteSize);
    }

    public static UpgradeIcon defaultModuleIcon(ItemLike item) {
        return LTXIBootstrapUtil.spriteOverItemIcon(item, "default_overlay", 7);
    }

    public static UpgradeIcon luckOverlayIcon(ItemLike item) {
        return LTXIBootstrapUtil.spriteOverItemIcon(item, "luck_overlay", 7);
    }

    public static UpgradeTooltip energyCapacityTooltip(DoubleLevelBasedValue value, ValueFormat format, ValueSentiment sentiment) {
        return UpgradeTooltip.of(LTXILangKeys.ENERGY_CAPACITY_UPGRADE, LTXIConstants.REM_BLUE.chatStyle(), ValueArgument.of(value, format, sentiment));
    }

    public static UpgradeTooltip energyTransferTooltip(DoubleLevelBasedValue value, ValueFormat format, ValueSentiment sentiment) {
        return UpgradeTooltip.of(LTXILangKeys.ENERGY_TRANSFER_UPGRADE, LTXIConstants.REM_BLUE.chatStyle(), ValueArgument.of(value, format, sentiment));
    }

    public static UpgradeTooltip energyUsageTooltip(DoubleLevelBasedValue value, ValueFormat format, ValueSentiment sentiment) {
        return UpgradeTooltip.of(LTXILangKeys.ENERGY_USAGE_UPGRADE, LTXIConstants.REM_BLUE.chatStyle(), ValueArgument.of(value, format, sentiment));
    }
}

