/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import java.util.concurrent.CompletableFuture;
import liedge.limacore.data.generation.LimaAdvancementGenerator;
import liedge.limacore.data.generation.LimaBootstrapUtil;
import liedge.ltxindustries.data.generation.AdvancementsGen;
import liedge.ltxindustries.data.generation.BlockEntityTagsGen;
import liedge.ltxindustries.data.generation.BlockStatesGen;
import liedge.ltxindustries.data.generation.BlockTagsGen;
import liedge.ltxindustries.data.generation.DamageModsGen;
import liedge.ltxindustries.data.generation.DamageTagsGen;
import liedge.ltxindustries.data.generation.DataMapsGen;
import liedge.ltxindustries.data.generation.EnchantmentTagsGen;
import liedge.ltxindustries.data.generation.EntityTagsGen;
import liedge.ltxindustries.data.generation.EquipmentUpgradesTagsGen;
import liedge.ltxindustries.data.generation.FluidTagsGen;
import liedge.ltxindustries.data.generation.GameEventsTagsGen;
import liedge.ltxindustries.data.generation.ItemModelGen;
import liedge.ltxindustries.data.generation.ItemTagsGen;
import liedge.ltxindustries.data.generation.LanguageGen;
import liedge.ltxindustries.data.generation.LootModifiersGen;
import liedge.ltxindustries.data.generation.LootTablesGen;
import liedge.ltxindustries.data.generation.MachineUpgradesTagsGen;
import liedge.ltxindustries.data.generation.ParticlesGen;
import liedge.ltxindustries.data.generation.RecipesGen;
import liedge.ltxindustries.data.generation.SoundsGen;
import liedge.ltxindustries.data.generation.SpriteSourcesGen;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.bootstrap.LTXIBiomeModifiers;
import liedge.ltxindustries.registry.bootstrap.LTXIConfiguredFeatures;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIMachineUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIPlacedFeatures;
import liedge.ltxindustries.registry.bootstrap.LTXIRecipeModes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="ltxi")
final class LTXIDatagen {
    private LTXIDatagen() {
    }

    @SubscribeEvent
    public static void runDataGeneration(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture baseRegistries = event.getLookupProvider();
        boolean runServer = event.includeServer();
        boolean runClient = event.includeClient();
        BlockTagsGen blockTags = new BlockTagsGen(output, baseRegistries, helper);
        DatapackBuiltinEntriesProvider dataRegistriesProvider = LimaBootstrapUtil.createDataPackProvider((PackOutput)output, (CompletableFuture)baseRegistries, (String)"ltxi", builder -> builder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, LTXIBiomeModifiers::bootstrap).add(Registries.CONFIGURED_FEATURE, LTXIConfiguredFeatures::bootstrap).add(Registries.DAMAGE_TYPE, LTXIDamageTypes::bootstrap).add(Registries.ENCHANTMENT, LTXIEnchantments::bootstrap).add(LTXIRegistries.Keys.EQUIPMENT_UPGRADES, LTXIEquipmentUpgrades::bootstrap).add(LTXIRegistries.Keys.MACHINE_UPGRADES, LTXIMachineUpgrades::bootstrap).add(Registries.PLACED_FEATURE, LTXIPlacedFeatures::bootstrap).add(LTXIRegistries.Keys.RECIPE_MODES, LTXIRecipeModes::bootstrap));
        CompletableFuture patchedRegistries = dataRegistriesProvider.getRegistryProvider();
        generator.addProvider(runServer, (DataProvider)dataRegistriesProvider);
        generator.addProvider(runServer, (DataProvider)LimaAdvancementGenerator.createDataProvider((PackOutput)output, (ExistingFileHelper)helper, (CompletableFuture)patchedRegistries, AdvancementsGen::new));
        generator.addProvider(runServer, (DataProvider)blockTags);
        generator.addProvider(runServer, (DataProvider)new ItemTagsGen(output, patchedRegistries, blockTags.contentsGetter(), helper));
        generator.addProvider(runServer, (DataProvider)new DamageTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new EnchantmentTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new EntityTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new GameEventsTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new BlockEntityTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new EquipmentUpgradesTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new FluidTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new MachineUpgradesTagsGen(output, patchedRegistries, helper));
        generator.addProvider(runServer, (DataProvider)new LootTablesGen(output, patchedRegistries));
        generator.addProvider(runServer, (DataProvider)new LootModifiersGen(output, patchedRegistries));
        generator.addProvider(runServer, (DataProvider)new RecipesGen(output, patchedRegistries));
        generator.addProvider(runServer, (DataProvider)new DataMapsGen(output, patchedRegistries));
        generator.addProvider(runServer, (DataProvider)new DamageModsGen(output, patchedRegistries, helper));
        generator.addProvider(runClient, (DataProvider)new LanguageGen(output));
        generator.addProvider(runClient, (DataProvider)new BlockStatesGen(output, helper));
        generator.addProvider(runClient, (DataProvider)new ItemModelGen(output, helper));
        generator.addProvider(runClient, (DataProvider)new ParticlesGen(output, helper));
        generator.addProvider(runClient, (DataProvider)new SoundsGen(output, helper));
        generator.addProvider(runClient, (DataProvider)new SpriteSourcesGen(output, patchedRegistries, helper));
    }
}

