/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import java.util.function.Supplier;
import liedge.limacore.data.generation.LimaLanguageProvider;
import liedge.limacore.lib.ModResources;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.NeonLightColor;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.client.LTXIKeyMappings;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.SimpleHintItem;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.item.weapon.GrenadeLauncherItem;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseBuilder;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.lib.weapons.WeaponReloadSource;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIMachineUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIRecipeModes;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXICreativeTabs;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIFluids;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIMenus;
import liedge.ltxindustries.registry.game.LTXIMobEffects;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.neoforge.registries.DeferredItem;

class LanguageGen
extends LimaLanguageProvider {
    LanguageGen(PackOutput output) {
        super(output, LTXIndustries.RESOURCES);
    }

    protected void addTranslations() {
        this.addBlock((Supplier)LTXIBlocks.TITANIUM_ORE, "Titanium Ore");
        this.addBlock((Supplier)LTXIBlocks.DEEPSLATE_TITANIUM_ORE, "Deepslate Titanium Ore");
        this.addBlock((Supplier)LTXIBlocks.NIOBIUM_ORE, "Niobium Ore");
        this.addBlock((Supplier)LTXIBlocks.RAW_TITANIUM_BLOCK, "Block of Raw Titanium");
        this.addBlock((Supplier)LTXIBlocks.RAW_NIOBIUM_BLOCK, "Block of Raw Niobium");
        this.addBlock((Supplier)LTXIBlocks.RAW_TITANIUM_CLUSTER, "Raw Titanium Cluster");
        this.addBlock((Supplier)LTXIBlocks.RAW_NIOBIUM_CLUSTER, "Raw Niobium Cluster");
        this.addBlock((Supplier)LTXIBlocks.TITANIUM_BLOCK, "Block of Titanium");
        this.addBlock((Supplier)LTXIBlocks.NIOBIUM_BLOCK, "Block of Niobium");
        this.addBlock((Supplier)LTXIBlocks.SLATESTEEL_BLOCK, "Block of Slatesteel");
        LTXIBlocks.NEON_LIGHTS.forEach((color, holder) -> {
            Object name = color == NeonLightColor.LTX_LIME ? "LTX Lime" : LanguageGen.localizeSimpleName((String)color.toString());
            name = (String)name + " Neon Light";
            this.addBlock((Supplier)holder, (String)name);
        });
        this.addBlock((Supplier)LTXIBlocks.TITANIUM_PANEL, "Titanium Panel");
        this.addBlock((Supplier)LTXIBlocks.SMOOTH_TITANIUM_PANEL, "Smooth Titanium Panel");
        this.addBlock((Supplier)LTXIBlocks.TITANIUM_GLASS, "Titanium Glass");
        this.addBlock((Supplier)LTXIBlocks.SLATESTEEL_PANEL, "Slatesteel Panel");
        this.addBlock((Supplier)LTXIBlocks.SMOOTH_SLATESTEEL_PANEL, "Smooth Slatesteel Panel");
        this.addBlock((Supplier)LTXIBlocks.SPARK_FRUIT, "Spark Fruit");
        this.addBlock((Supplier)LTXIBlocks.BILEVINE, "Bilevine");
        this.addBlock((Supplier)LTXIBlocks.BILEVINE_PLANT, "Bilevine");
        this.addBlock((Supplier)LTXIBlocks.GLOOM_SHROOM, "Gloom Shroom");
        this.addBlock((Supplier)LTXIBlocks.ENERGY_CELL_ARRAY, "Energy Cell Array");
        this.addBlock((Supplier)LTXIBlocks.INFINITE_ENERGY_CELL_ARRAY, "Energy Cell Array (\u221e)");
        this.addBlock((Supplier)LTXIBlocks.DIGITAL_FURNACE, "Digital Furnace");
        this.addBlock((Supplier)LTXIBlocks.DIGITAL_SMOKER, "Digital Smoker");
        this.addBlock((Supplier)LTXIBlocks.DIGITAL_BLAST_FURNACE, "Digital Blast Furnace");
        this.addBlock((Supplier)LTXIBlocks.GRINDER, "Grinder");
        this.addBlock((Supplier)LTXIBlocks.MATERIAL_FUSING_CHAMBER, "Material Fusing Chamber");
        this.addBlock((Supplier)LTXIBlocks.ELECTROCENTRIFUGE, "ElectroCentrifuge");
        this.addBlock((Supplier)LTXIBlocks.MIXER, "Mixer");
        this.addBlock((Supplier)LTXIBlocks.VOLTAIC_INJECTOR, "Voltaic Injector");
        this.addBlock((Supplier)LTXIBlocks.CHEM_LAB, "Chem Lab");
        this.addBlock((Supplier)LTXIBlocks.ASSEMBLER, "Assembler");
        this.addBlock((Supplier)LTXIBlocks.FABRICATOR, "Fabricator");
        this.addBlock((Supplier)LTXIBlocks.AUTO_FABRICATOR, "Auto Fabricator");
        this.addBlock((Supplier)LTXIBlocks.EQUIPMENT_UPGRADE_STATION, "Equipment Upgrade Station");
        this.addBlock((Supplier)LTXIBlocks.MOLECULAR_RECONSTRUCTOR, "Molecular Reconstructor");
        this.addBlock((Supplier)LTXIBlocks.DIGITAL_GARDEN, "Bio/ARU Garden");
        this.addBlock((Supplier)LTXIBlocks.ROCKET_TURRET, this.italicName("%s A/DS Turret", "Atmos"));
        this.addBlock((Supplier)LTXIBlocks.RAILGUN_TURRET, this.italicName("%s A/DS Turret", "Noctis"));
        this.addBlock((Supplier)LTXIBlocks.GLOWSTICK, "Glowstick");
        this.fluidType((Supplier)LTXIFluids.VIRIDIC_ACID_TYPE, "Viridic Acid");
        this.fluidType((Supplier)LTXIFluids.HYDROGEN_TYPE, "Hydrogen");
        this.fluidType((Supplier)LTXIFluids.OXYGEN_TYPE, "Oxygen");
        this.addItem((Supplier)LTXIItems.RAW_TITANIUM, "Raw Titanium");
        this.addItem((Supplier)LTXIItems.TITANIUM_INGOT, "Titanium Ingot");
        this.addItem((Supplier)LTXIItems.TITANIUM_NUGGET, "Titanium Nugget");
        this.addItem((Supplier)LTXIItems.RAW_NIOBIUM, "Raw Niobium");
        this.addItem((Supplier)LTXIItems.NIOBIUM_INGOT, "Niobium Ingot");
        this.addItem((Supplier)LTXIItems.NIOBIUM_NUGGET, "Niobium Nugget");
        this.addItem((Supplier)LTXIItems.VITRIOL_BERRIES, "Vitriol Berries");
        this.addItem((Supplier)LTXIItems.VIRIDIC_ACID_BUCKET, "Viridic Acid Bucket");
        this.addItem((Supplier)LTXIItems.LTX_LIME_PIGMENT, "LTX Lime Pigment");
        this.addItem((Supplier)LTXIItems.ENERGY_BLUE_PIGMENT, "Energy Blue Pigment");
        this.addItem((Supplier)LTXIItems.ELECTRIC_CHARTREUSE_PIGMENT, "Electric Chartreuse Pigment");
        this.addItem((Supplier)LTXIItems.VIRIDIC_GREEN_PIGMENT, "Viridic Green Pigment");
        this.addItem((Supplier)LTXIItems.NEURO_BLUE_PIGMENT, "Neuro Blue Pigment");
        this.addItem((Supplier)LTXIItems.CARBON_DUST, "Carbon Dust");
        this.addItem((Supplier)LTXIItems.RESINOUS_BIOMASS, "Resinous Biomass");
        this.addItem((Supplier)LTXIItems.ACIDIC_BIOMASS, "Acidic Biomass");
        this.addItem((Supplier)LTXIItems.DEEPSLATE_DUST, "Deepslate Dust");
        this.addItem((Supplier)LTXIItems.ELECTRIC_CHEMICAL, "Electrolyte Blend");
        this.addItem((Supplier)LTXIItems.MONOMER_CHEMICAL, "Monomer Solution");
        this.addItem((Supplier)LTXIItems.VIRIDIC_WEAPON_CHEMICAL, "Weapons-Grade Viridic Acid");
        this.addItem((Supplier)LTXIItems.CHORUS_CHEMICAL, "Chorus Extract");
        this.addItem((Supplier)LTXIItems.SCULK_CHEMICAL, "Echo Serum");
        this.addItem((Supplier)LTXIItems.NEURO_CHEMICAL, "Neuro-Suppressant");
        this.addItem((Supplier)LTXIItems.SLATESTEEL_INGOT, "Slatesteel Ingot");
        this.addItem((Supplier)LTXIItems.SLATESTEEL_NUGGET, "Slatesteel Nugget");
        this.addItem((Supplier)LTXIItems.POLYMER_INGOT, "Polymer Bar");
        this.addItem((Supplier)LTXIItems.CIRCUIT_BOARD, "Circuit Board");
        this.simpleHintItem(LTXIItems.T1_CIRCUIT, "Basic Circuit", "First tier circuit. Sufficient energy and data throughput for most entry-level applications.");
        this.simpleHintItem(LTXIItems.T2_CIRCUIT, "Enhanced Circuit", "Second tier circuit. Improved energy and data efficiency from higher quality conductors.");
        this.simpleHintItem(LTXIItems.T3_CIRCUIT, "Precision Circuit", "Third tier circuit. Highest performance on conventional materials. Handles all standard engineering and industrial applications.");
        this.simpleHintItem(LTXIItems.T4_CIRCUIT, "Nano-Core Processor", "Fourth tier circuit. Exotic crystal-metal nanoarchitecture packed into a small form factor. Near unmatched power delivery and data processing.");
        this.simpleHintItem(LTXIItems.T5_CIRCUIT, "Real Virtuality Processor", "Fifth and final tier circuit. Can create digital microverses where its calculations don't break the laws of physics. Don't question it.");
        this.addItem((Supplier)LTXIItems.COAL_ORE_PEBBLES, "Coal Ore Pebbles");
        this.addItem((Supplier)LTXIItems.COPPER_ORE_PEBBLES, "Copper Ore Pebbles");
        this.addItem((Supplier)LTXIItems.IRON_ORE_PEBBLES, "Iron Ore Pebbles");
        this.addItem((Supplier)LTXIItems.LAPIS_ORE_PEBBLES, "Lapis Lazuli Ore Pebbles");
        this.addItem((Supplier)LTXIItems.REDSTONE_ORE_PEBBLES, "Redstone Ore Pebbles");
        this.addItem((Supplier)LTXIItems.GOLD_ORE_PEBBLES, "Gold Ore Pebbles");
        this.addItem((Supplier)LTXIItems.DIAMOND_ORE_PEBBLES, "Diamond Ore Pebbles");
        this.addItem((Supplier)LTXIItems.EMERALD_ORE_PEBBLES, "Emerald Ore Pebbles");
        this.addItem((Supplier)LTXIItems.QUARTZ_ORE_PEBBLES, "Nether Quartz Ore Pebbles");
        this.addItem((Supplier)LTXIItems.NETHERITE_ORE_PEBBLES, "Netherite Scrap Ore Pebbles");
        this.addItem((Supplier)LTXIItems.TITANIUM_ORE_PEBBLES, "Titanium Ore Pebbles");
        this.addItem((Supplier)LTXIItems.NIOBIUM_ORE_PEBBLES, "Niobium Ore Pebbles");
        this.addItem((Supplier)LTXIItems.TIN_ORE_PEBBLES, "Tin Ore Pebbles");
        this.addItem((Supplier)LTXIItems.OSMIUM_ORE_PEBBLES, "Osmium Ore Pebbles");
        this.addItem((Supplier)LTXIItems.NICKEL_ORE_PEBBLES, "Nickel Ore Pebbles");
        this.addItem((Supplier)LTXIItems.LEAD_ORE_PEBBLES, "Lead Ore Pebbles");
        this.addItem((Supplier)LTXIItems.SILVER_ORE_PEBBLES, "Silver Ore Pebbles");
        this.addItem((Supplier)LTXIItems.URANIUM_ORE_PEBBLES, "Uranium Ore Pebbles");
        this.addItem((Supplier)LTXIItems.LTX_DRILL, "\u03b5-Series Drill");
        this.addItem((Supplier)LTXIItems.LTX_SWORD, "\u03b5-Series Sword");
        this.addItem((Supplier)LTXIItems.LTX_SHOVEL, "\u03b5-series Shovel");
        this.addItem((Supplier)LTXIItems.LTX_AXE, "\u03b5-Series Axe");
        this.addItem((Supplier)LTXIItems.LTX_HOE, "\u03b5-Series Hoe");
        this.addItem((Supplier)LTXIItems.LTX_SHEARS, "\u03b5-Series Shears");
        this.addItem((Supplier)LTXIItems.LTX_BRUSH, "\u03b5-Series Brush");
        this.addItem((Supplier)LTXIItems.LTX_FISHING_ROD, "\u03b5-Series Fishing Rod");
        this.addItem((Supplier)LTXIItems.LTX_LIGHTER, "\u03b5-Series Lighter");
        this.addItem((Supplier)LTXIItems.LTX_WRENCH, "\u03b5-Series Wrench");
        this.addItem((Supplier)LTXIItems.EMPTY_UPGRADE_MODULE, "Empty Upgrade Module");
        this.simpleHintItem(LTXIItems.EMPTY_FABRICATION_BLUEPRINT, "Empty Fabrication Blueprint", "Encode a Fabrication recipe in a Fabricator.");
        this.addItem((Supplier)LTXIItems.FABRICATION_BLUEPRINT, "Fabrication Blueprint");
        this.addItem((Supplier)LTXIItems.ITEMS_IO_CONFIG_CARD, "Items IO Config Card");
        this.addItem((Supplier)LTXIItems.ENERGY_IO_CONFIG_CARD, "Energy IO Config Card");
        this.addItem((Supplier)LTXIItems.FLUIDS_IO_CONFIG_CARD, "Fluids IO Config Card");
        this.simpleHintItem(LTXIItems.EXPLOSIVES_WEAPON_TECH_SALVAGE, "Salvaged Tech: Explosive Weapon Systems", "Broken components from an explosives handling device. Might be useful in reconstructing explosive weaponry.");
        this.simpleHintItem(LTXIItems.TARGETING_TECH_SALVAGE, "Salvaged Tech: Auto-Targeting Systems", "Broken electronics from a targeting computer. Might be useful in reconstructing guidance systems for weaponry.");
        this.addItem((Supplier)LTXIItems.SUBMACHINE_GUN, this.italicName("%s 07/SD", "Serenity"));
        this.addItem((Supplier)LTXIItems.GLOWSTICK_LAUNCHER, this.italicName("%s 05/ID", "Wayfinder"));
        this.addItem((Supplier)LTXIItems.SHOTGUN, this.italicName("%s 21/SG", "Aurora"));
        this.addItem((Supplier)LTXIItems.GRENADE_LAUNCHER, this.italicName("%s 33/GL", "Hanabi"));
        this.addItem((Supplier)LTXIItems.LINEAR_FUSION_RIFLE, this.italicName("%s 38/LF", "Stargazer"));
        this.addItem((Supplier)LTXIItems.ROCKET_LAUNCHER, this.italicName("%s 42/RL", "Daybreak"));
        this.addItem((Supplier)LTXIItems.HEAVY_PISTOL, this.italicName("%s 77/HX", "Nova"));
        this.simpleHintItem(LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, "Lightweight Weapon Energy", "Consumable energy cell for powering Lightweight-class weaponry.");
        this.simpleHintItem(LTXIItems.SPECIALIST_WEAPON_ENERGY, "Specialist Weapon Energy", "Consumable energy cell for powering Specialist-class weaponry.");
        this.simpleHintItem(LTXIItems.EXPLOSIVES_WEAPON_ENERGY, "Explosive Weapon Energy", "Consumable energy cell for powering Explosive-class weaponry.");
        this.simpleHintItem(LTXIItems.HEAVY_WEAPON_ENERGY, "Heavy Weapon Energy", "Consumable energy cell for powering Heavy-class weaponry.");
        this.add(LTXILangKeys.TOOL_DEFAULT_UPGRADE_TITLE, "\u03b5 Core Systems");
        this.upgradeDescOnly(LTXIEquipmentUpgrades.LTX_SHOVEL_DEFAULT, "Standard issue operating system. Tool energy cutter preserves topographical integrity.");
        this.upgradeDescOnly(LTXIEquipmentUpgrades.LTX_WRENCH_DEFAULT, "Standard issue operating system. Enables lossless dismantling and retrieval of machines.");
        this.upgradeDescOnly(LTXIEquipmentUpgrades.LTX_MELEE_DEFAULT, "Standard issue operating system. Tool energy blade is optimized for efficient severing and disintegration of organic matter.");
        this.upgradeTooltip(LTXIEquipmentUpgrades.LTX_MELEE_DEFAULT, 0, "%s bonus damage against unarmored targets");
        this.upgrade(LTXIEquipmentUpgrades.GLOWSTICK_LAUNCHER_DEFAULT, "Wayfinder Intrinsics", "Wayfinder's energy feed system ships pre-configured to use Common Energy.");
        this.upgrade(LTXIEquipmentUpgrades.SUBMACHINE_GUN_DEFAULT, "Serenity Intrinsics", "Serenity's small light-frags zip right through targets without a trace.");
        this.upgrade(LTXIEquipmentUpgrades.SHOTGUN_DEFAULT, "Aurora Intrinsics", "Aurora's combat precepts, specialized in fast assault and scout operations.");
        this.upgrade(LTXIEquipmentUpgrades.LFR_DEFAULT, "Stargazer Intrinsics", "Stargazer's systems are calibrated for precise long-range engagements.");
        this.upgradeTooltip(LTXIEquipmentUpgrades.LFR_DEFAULT, 0, "%s bonus damage when at least 40m away from target");
        this.upgradeTooltip(LTXIEquipmentUpgrades.LFR_DEFAULT, 1, "%s bonus damage when standing still and sneaking");
        this.upgrade(LTXIEquipmentUpgrades.TOOL_ENERGY_UPGRADE, "Augmented \u03b5 Battery", "Maximize your \u03b5-Series tool's field uptime with this enhanced battery.");
        this.upgrade(LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, "\u03b5 Anglers' Kit", "\u03b5 series' signature lure attracts more valuable aquatic specimens faster than regular bait.");
        this.upgrade(LTXIEquipmentUpgrades.TOOL_NETHERITE_LEVEL, "Netherite-Core Tool Head", "Upgrades mining tier to Netherite level and increases mining speed.");
        this.upgrade(LTXIEquipmentUpgrades.EPSILON_OMNI_DRILL, "\u03b5 Experimental Drill", "Special-issue drill augur. Modified to work on any material type.");
        this.upgrade(LTXIEquipmentUpgrades.TOOL_VIBRATION_CANCEL, "Resonance-Tuned Servos", "Special lining on this tool's servos dampen vibrations from standard use.");
        this.upgrade(LTXIEquipmentUpgrades.TOOL_DIRECT_DROPS, "Mining Subspace Link", "Tool systems interface directly with your inventory, depositing materials without physical collection.");
        this.upgrade(LTXIEquipmentUpgrades.WEAPON_VIBRATION_CANCEL, "Echo Suppressor", "Augments weapons and projectiles with an anti-resonance field, erasing vibration signatures");
        this.upgrade(LTXIEquipmentUpgrades.WEAPON_DIRECT_DROPS, "Combat Subspace Link", "Weapon systems interface directly with your inventory, depositing loot without physical collection.");
        this.upgrade(LTXIEquipmentUpgrades.WEAPON_ARMOR_PIERCE, "Armor-Piercing Rounds", "Volatile energy dispersal precepts. Allows weapons to partially breach armor.");
        this.upgrade(LTXIEquipmentUpgrades.LIGHTWEIGHT_ENERGY_ADAPTER, "Lightweight Energy Adapter", "Reroutes the energy feed system of Lightweight weaponry to use Common Energy.");
        this.upgrade(LTXIEquipmentUpgrades.SPECIALIST_ENERGY_ADAPTER, "Specialist Energy Adapter", "Reroutes the energy feed system of Specialist weaponry to use Common Energy.");
        this.upgrade(LTXIEquipmentUpgrades.EXPLOSIVES_ENERGY_ADAPTER, "Explosives Energy Adapter", "Reroutes the energy feed system of Explosives weaponry to use Common Energy.");
        this.upgrade(LTXIEquipmentUpgrades.HEAVY_ENERGY_ADAPTER, "Heavy Energy Adapter", "Reroutes the energy feed system of Heavy weaponry to use Common Energy.");
        this.upgrade(LTXIEquipmentUpgrades.UNIVERSAL_INFINITE_AMMO, "//ERR~MAG-Z!!-NE//\u221e", "Ignore the laws of physics with this never-ending ammo source. Try not to cause a mass extinction event.");
        this.upgrade(LTXIEquipmentUpgrades.NEUTRAL_ENEMY_TARGET_FILTER, "Engagement Protocol: Preemption", "Weapon systems restrict engagement to neutral enemies and hostile targets.");
        this.upgrade(LTXIEquipmentUpgrades.HOSTILE_TARGET_FILTER, "Engagement Protocol: Rectification", "Weapon systems restrict engagement to actively hostile targets.");
        this.upgrade(LTXIEquipmentUpgrades.HIGH_IMPACT_ROUNDS, "High Impact Rounds", "Light-frags with a punch! Send targets flying back regardless of their knockback resistances.");
        this.upgrade(LTXIEquipmentUpgrades.HEAVY_PISTOL_GOD_ROUNDS, "Stellar Reality Disruptor", "Rip through reality itself with this Nova upgrade. Ensures swift defeat of even the strongest enemies.");
        this.upgrade(LTXIEquipmentUpgrades.UNIVERSAL_STEALTH_DAMAGE, "Biometric Obfuscation", "Targeting systems mask your signature, leaving no trace of your involvement. May not be effective against all targets.");
        this.upgrade(LTXIEquipmentUpgrades.WEAPON_SHIELD_REGEN, "Regenerative Link", "Captures enemy energy upon elimination to power medical nano-tech and the bubble shield.");
        this.upgrade(LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, "Overclocked Energy Cutters", "Enhances the power feed to the tool's energy cutter.");
        this.upgrade(LTXIEquipmentUpgrades.SILK_TOUCH_ENCHANTMENT, "Stabilized Harvest Matrix", "Calibrated to extract intact samples from the terrain.");
        this.upgrade(LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, "Overclocked Harvest Matrix", "Calibrated to extract superior quantities of valuable resources.");
        this.upgrade(LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, "Combat Yield Protocol", "Calibrated to maximize structural integrity of salvageable biomaterials.");
        this.upgrade(LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, "Munition Trace Unit", "Improves detection of high-grade LTX ammunition in the field.");
        this.upgrade(LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, "Severance Algorithm", "Weapon calibration enables the retrieval of anatomical curiosities.");
        this.upgrade(LTXIEquipmentUpgrades.GRENADE_LAUNCHER_PROJECTILE_SPEED, "Hanabi Launch Boost", "Increases the velocity of the Hanabi grenades.");
        this.upgrade(LTXIEquipmentUpgrades.FLAME_GRENADE_CORE, "Hanabi Core/Flame", "Grenades are loaded with a concentrated fuel that creates powerful flames.");
        this.upgrade(LTXIEquipmentUpgrades.CRYO_GRENADE_CORE, "Hanabi Core/Cryo", "Grenades contain a cryogenic compound that freezes a large area.");
        this.upgrade(LTXIEquipmentUpgrades.ELECTRIC_GRENADE_CORE, "Hanabi Core/Electric", "Grenades create a burst of electrical energy. Recommended for use in humid/aquatic environments.");
        this.upgrade(LTXIEquipmentUpgrades.ACID_GRENADE_CORE, "Hanabi Core/Acid", "Grenades contain a highly corrosive acid that reduces target armor strength.");
        this.upgrade(LTXIEquipmentUpgrades.NEURO_GRENADE_CORE, "Hanabi Core/Neuro", "Grenades contain a powerful neuro-suppressant agent that highly reduces target attack strength.");
        this.upgrade(LTXIEquipmentUpgrades.OMNI_GRENADE_CORE, "Hanabi Core/ARCOIRIS", "Full spectrum adaptable core for the Hanabi. Allows the use of any of grenade shells.");
        this.upgrade(LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, "Auxiliary Energy Cells", "Increases the energy capacity and transfer rate of the Energy Cell Array.");
        this.upgrade(LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, "Standard Machine Systems", "Core modular systems designed for balanced efficiency.");
        this.upgrade(LTXIMachineUpgrades.ULTIMATE_MACHINE_SYSTEMS, "Ultimate Machine Systems", "The pinnacle of engineering precision! Achieves near-instantaneous crafting at the cost of immense energy consumption.");
        this.upgrade(LTXIMachineUpgrades.FABRICATOR_UPGRADE, "Enhanced Tool Head", "Elevate your Fabricator's manufacturing capabilities with superior internal components.");
        this.upgrade(LTXIMachineUpgrades.TURRET_LOOTING, "Efficient Target Disposal", "Smarter turret targeting systems allow for increased loot drops from eliminated targets.");
        this.upgrade(LTXIMachineUpgrades.TURRET_RAZOR, "Headhunter Scope", "Precise turret calibration enables the collection of anatomical curiosities.");
        this.upgrade(LTXIMachineUpgrades.TURRET_LOOT_COLLECTOR, "Matter SubLink", "Loot is sent directly to the turret\u2019s storage. If full, items appear at the turret\u2019s base.");
        this.creativeTab((Supplier)LTXICreativeTabs.MAIN_TAB, "LTX Industries");
        this.creativeTab((Supplier)LTXICreativeTabs.EQUIPMENT_MODULES_TAB, "LTXI Equipment Upgrades");
        this.creativeTab((Supplier)LTXICreativeTabs.MACHINE_MODULES_TAB, "LTXI Machine Upgrades");
        this.menuTitle((Supplier)LTXIMenus.BLOCK_IO_CONFIGURATION, "%s IO Config");
        this.menuTitle((Supplier)LTXIMenus.MACHINE_UPGRADES, "Machine Upgrades");
        this.menuTitle((Supplier)LTXIMenus.ROCKET_TURRET, "Atmos Turret");
        this.menuTitle((Supplier)LTXIMenus.RAILGUN_TURRET, "Noctis Turret");
        this.add(BlockEntityInputType.ITEMS, "Items");
        this.add(BlockEntityInputType.ENERGY, "Energy");
        this.add(BlockEntityInputType.FLUIDS, "Fluids");
        this.add(BlockEntityInputType.SIDEBAR_TOOLTIP, "Configure %s IO");
        this.add((Supplier)LTXIRecipeTypes.GRINDING, "Grinding");
        this.add((Supplier)LTXIRecipeTypes.MATERIAL_FUSING, "Material Fusing");
        this.add((Supplier)LTXIRecipeTypes.ELECTRO_CENTRIFUGING, "ElectroCentrifuging");
        this.add((Supplier)LTXIRecipeTypes.MIXING, "Mixing");
        this.add((Supplier)LTXIRecipeTypes.ENERGIZING, "Energizing");
        this.add((Supplier)LTXIRecipeTypes.CHEMICAL_REACTING, "Chemical Reacting");
        this.add((Supplier)LTXIRecipeTypes.GARDEN_SIMULATING, "Garden Simulating");
        this.add((Supplier)LTXIRecipeTypes.ASSEMBLING, "Assembling");
        this.add((Supplier)LTXIRecipeTypes.FABRICATING, "Fabricating");
        this.recipeMode(LTXIRecipeModes.DYE_EXTRACTION, "Dye Extraction");
        this.recipeMode(LTXIRecipeModes.CHEM_DISSOLUTION, "Dissolution");
        this.recipeMode(LTXIRecipeModes.ECF_ELECTROLYZE, "Electrolyze");
        this.recipeMode(LTXIRecipeModes.GS_FARMING, "Farming");
        this.recipeMode(LTXIRecipeModes.GS_WOODS, "Woods");
        this.recipeMode(LTXIRecipeModes.GS_ORCHARD, "Orchard");
        this.recipeMode(LTXIRecipeModes.GS_FOLIAGE, "Foliage");
        this.addEntityType((Supplier)LTXIEntities.GLOWSTICK_PROJECTILE, "Wayfinder Glowstick");
        this.addEntityType((Supplier)LTXIEntities.ORB_GRENADE, "Orb Grenade");
        this.addEntityType((Supplier)LTXIEntities.DAYBREAK_ROCKET, "Daybreak Rocket");
        this.addEntityType((Supplier)LTXIEntities.TURRET_ROCKET, "Turret Rocket");
        this.addEntityType((Supplier)LTXIEntities.STICKY_FLAME, "Sticky Flame");
        this.addEffect((Supplier)LTXIMobEffects.FROSTBITE, "Frostbite");
        this.addEffect((Supplier)LTXIMobEffects.CORROSIVE, "Corroding");
        this.addEffect((Supplier)LTXIMobEffects.NEURO_SUPPRESSED, "Neuro-Suppressed");
        this.enchantment(LTXIEnchantments.RAZOR, "Razor");
        this.enchantment(LTXIEnchantments.AMMO_SCAVENGER, "Ammo Scavenger");
        this.add(LTXILangKeys.INLINE_ENERGY, "Energy: %s");
        this.add(LTXILangKeys.INLINE_ENERGY_TRANSFER_RATE, "Energy I/O: %s");
        this.add(LTXILangKeys.INLINE_ENERGY_USAGE, "Energy use: %s");
        this.add(LTXILangKeys.INLINE_NO_OWNER_TOOLTIP, "No Owner");
        this.add(LTXILangKeys.INLINE_OWNER_TOOLTIP, "Owner: %s");
        this.add(LTXILangKeys.ENERGY_OVERCHARGE_TOOLTIP, "Energy Overcharged! Your energy stored is more than your current capacity.");
        this.add(LTXILangKeys.NONE_UNIVERSAL_TOOLTIP, "None");
        this.add(LTXILangKeys.BACK_BUTTON_LABEL, "Back");
        this.add(LTXILangKeys.AUTO_OUTPUT_OFF_TOOLTIP, "Auto Output Disabled");
        this.add(LTXILangKeys.AUTO_OUTPUT_ON_TOOLTIP, "Auto Output Enabled");
        this.add(LTXILangKeys.AUTO_INPUT_OFF_TOOLTIP, "Auto Input Disabled");
        this.add(LTXILangKeys.AUTO_INPUT_ON_TOOLTIP, "Auto Input Enabled");
        this.add(LTXILangKeys.MACHINE_UPGRADES_SIDEBAR_TOOLTIP, "Manage Upgrade Modules");
        this.add(LTXILangKeys.RECIPE_MODES_TITLE_OR_TOOLTIP, "Recipe Modes");
        this.add(LTXILangKeys.RECIPE_MODE_CURRENT_MODE, "Current mode: %s");
        this.add(LTXILangKeys.JEI_RECIPE_MODE_NEEDED, "Needs mode: %s");
        this.add(LTXILangKeys.JEI_NO_RECIPE_MODE_NEEDED, "No recipe mode needed.");
        this.add(LTXILangKeys.BLUEPRINT_TOAST_MESSAGE, "New Fabrication Data");
        this.add(LTXILangKeys.MACHINE_TICKS_PER_OP_TOOLTIP, "Ticks per operation: %s");
        this.add(LTXILangKeys.EMPTY_ITEM_INVENTORY_TOOLTIP, "No items stored");
        this.add(LTXILangKeys.ITEM_INVENTORY_TOOLTIP, "Stored Items");
        this.add(LTXILangKeys.FABRICATOR_SELECTED_RECIPE_TOOLTIP, "Left click to craft. Right click to encode blueprint (must have blank blueprint in slot).");
        this.add(LTXILangKeys.INLINE_ENERGY_REQUIRED_TOOLTIP, "Energy required: %s");
        this.add(LTXILangKeys.WORKING_PROGRESS_TOOLTIP, "Working: %s%%");
        this.add(LTXILangKeys.CRAFTING_PROGRESS_TOOLTIP, "Crafting: %s%%");
        this.add(LTXILangKeys.JEI_CRAFTING_TIME_TOOLTIP, "%ss | %st");
        this.add(LTXILangKeys.INPUT_NOT_CONSUMED_TOOLTIP, "Input not consumed");
        this.add(LTXILangKeys.INPUT_CONSUME_CHANCE_TOOLTIP, "Input consume chance: %s");
        this.add(LTXILangKeys.OUTPUT_CHANCE_TOOLTIP, "Output chance: ");
        this.add(LTXILangKeys.OUTPUT_VARIABLE_COUNT_TOOLTIP, "Outputs ");
        this.add(LTXILangKeys.OUTPUT_OPTIONAL_TOOLTIP, "Optional output - discarded if not enough space");
        this.add(LTXILangKeys.ADVANCEMENT_LOCKED_TOOLTIP, "Requires Advancement");
        this.add(LTXILangKeys.UPGRADE_RANK_TOOLTIP, "Rank %s/%s");
        this.add(LTXILangKeys.UPGRADE_REMOVE_HINT, "Shift + left click to remove upgrade. Must have space in your inventory.");
        this.add(LTXILangKeys.UPGRADE_COMPATIBILITY_TOOLTIP, "Compatible with:");
        this.add(LTXILangKeys.EQUIPMENT_UPGRADE_MODULE_TOOLTIP, "Equipment Upgrade Module");
        this.add(LTXILangKeys.MACHINE_UPGRADE_MODULE_TOOLTIP, "Machine Upgrade Module");
        this.add(LTXILangKeys.DAMAGE_ATTRIBUTES_EFFECT_PREFIX, "Against target: ");
        this.add(LTXILangKeys.UPGRADE_INSTALL_SUCCESS, "Installed upgrade.");
        this.add(LTXILangKeys.UPGRADE_INSTALL_FAIL, "Can't install upgrade.");
        this.add(LTXILangKeys.INVALID_UPGRADE_HINT, "The upgrade in this module is invalid or corrupted. Shift+Right Click to clear.");
        this.add(LTXILangKeys.INVALID_BLUEPRINT_HINT, "The recipe in this blueprint is invalid or corrupted. Shift+Right Click to clear.");
        this.add(LTXILangKeys.EMPTY_IO_CARD_HINT, "No IO configuration data stored. Shift+Right Click a machine to copy.");
        this.add(LTXILangKeys.ENCODED_IO_CARD_HINT, "Shift+Right Click on a compatible machine to paste settings, or in the air to clear.");
        this.add(LTXILangKeys.IO_CARD_CLEARED, "IO config cleared.");
        this.add(LTXILangKeys.IO_CARD_COPIED, "Machine IO config copied.");
        this.add(LTXILangKeys.IO_CARD_PASTED, "Applied IO config to machine.");
        this.add(LTXILangKeys.IO_CARD_SAME_CONFIG, "IO config already applied.");
        this.add(LTXILangKeys.IO_CARD_INVALID_SETUP, "Machine does not support this IO config.");
        this.add(LTXILangKeys.IO_CARD_INVALID_TYPE, "Machine does not support %s.");
        this.add(LTXILangKeys.ENERGY_CAPACITY_UPGRADE, "%s energy capacity");
        this.add(LTXILangKeys.ENERGY_TRANSFER_UPGRADE, "%s energy transfer rate");
        this.add(LTXILangKeys.ENERGY_USAGE_UPGRADE, "%s energy usage");
        this.add(LTXILangKeys.MACHINE_SPEED_UPGRADE, "%s machine speed");
        this.add(LTXILangKeys.ENERGY_PER_RECIPE_UPGRADE, "Avg. energy per recipe: %s");
        this.add(LTXILangKeys.INSTANT_PROCESSING_UPGRADE, "Instant machine operation");
        this.add(LTXILangKeys.PROJECTILE_SPEED_UPGRADE, "%s projectile speed");
        this.add(LTXILangKeys.ATTRIBUTE_SCALED_DAMAGE_UPGRADE, "%s of target's %s as extra damage");
        this.add(LTXILangKeys.MINIMUM_MACHINE_SPEED_EFFECT, "Minimum speed: %s ticks");
        this.add(LTXILangKeys.MINING_EFFECTIVE_BLOCKS_EFFECT, "Effective against %s blocks");
        this.add(LTXILangKeys.MINING_BASE_SPEED_EFFECT, "Base mining speed: %s");
        this.add(LTXILangKeys.DYNAMIC_DAMAGE_TAG_EFFECT, "+Damage Tags: %s");
        this.add(LTXILangKeys.SUPPRESS_VIBRATIONS_EFFECT, "Suppresses %s sculk vibrations");
        this.add(LTXILangKeys.DIRECT_BLOCK_DROPS_EFFECT, "Directly collects %s block drops");
        this.add(LTXILangKeys.DIRECT_ENTITY_DROPS_EFFECT, "Directly collects %s entity drops");
        this.add(LTXILangKeys.REDUCTION_MODIFIER_EFFECT, "%s %s breach");
        this.add(LTXILangKeys.BUBBLE_SHIELD_EFFECT, "%s Bubble Shield/kill, (max %s)");
        this.add(LTXILangKeys.MOB_EFFECT_UPGRADE_EFFECT, "Applies %s (%s)");
        this.add(LTXILangKeys.ENCHANTMENT_UPGRADE_EFFECT, "+%s %s levels (max. %s)");
        this.add(LTXILangKeys.GRENADE_UNLOCK_EFFECT, "Can use %s shells");
        this.add(TooltipShiftHintItem.HINT_HOVER_TOOLTIP, "Hold SHIFT for extra info");
        this.add(WeaponReloadSource.Type.ITEM.getItemTooltip(), "Reloads with %s");
        this.add(WeaponReloadSource.Type.ITEM.getUpgradeTooltip(), "Replaces reload item: %s");
        this.add(WeaponReloadSource.Type.COMMON_ENERGY.getItemTooltip(), "Reloads from Common Energy battery");
        this.add(WeaponReloadSource.Type.COMMON_ENERGY.getUpgradeTooltip(), "Weapon reloads from an internal CE battery");
        this.add(WeaponReloadSource.Type.INFINITE.getItemTooltip(), "This weapon has infinite ammo!");
        this.add(WeaponReloadSource.Type.INFINITE.getUpgradeTooltip(), "Grants weapon an infinite, never-draining magazine");
        this.add(WeaponItem.AMMO_LOADED_TOOLTIP, "Ammo: %s/%s");
        this.add(WeaponItem.RELOAD_SPEED_TOOLTIP, "Reload speed: %ss");
        this.add(GrenadeLauncherItem.GRENADE_TYPE_TOOLTIP, "%s shells equipped");
        this.add(LTXITooltipUtil.ALL_HOLDER_SET, "all");
        this.add(LTXITooltipUtil.AMBIGUOUS_HOLDER_SET, "certain");
        this.soundEvent((Holder)LTXISounds.UPGRADE_INSTALL, "Upgrade module installed");
        this.soundEvent((Holder)LTXISounds.UPGRADE_REMOVE, "Upgrade module removed");
        this.soundEvent((Holder)LTXISounds.WEAPON_MODE_SWITCH, "Weapon mode switched");
        this.soundEvent((Holder)LTXISounds.TURRET_TARGET_FOUND, "Turret finds targets");
        this.soundEvent((Holder)LTXISounds.GLOWSTICK_LAUNCHER_FIRE, "Wayfinder fires");
        this.soundEvent((Holder)LTXISounds.SUBMACHINE_GUN_LOOP, "Serenity firing");
        this.soundEvent((Holder)LTXISounds.SHOTGUN_FIRE, "Aurora fires");
        this.soundEvent((Holder)LTXISounds.GRENADE_LAUNCHER_FIRE, "Hanabi fires");
        this.soundEvent((Holder)LTXISounds.LINEAR_FUSION_CHARGE, "Stargazer charges");
        this.soundEvent((Holder)LTXISounds.LINEAR_FUSION_FIRE, "Stargazer fires");
        this.soundEvent((Holder)LTXISounds.ROCKET_LAUNCHER_FIRE, "Daybreak fires");
        this.soundEvent((Holder)LTXISounds.HEAVY_PISTOL_FIRE, "Nova fires");
        this.soundEvent((Holder)LTXISounds.ROCKET_EXPLODE, "Rocket explodes");
        LTXISounds.GRENADE_EXPLOSIONS.forEach((element, holder) -> this.soundEvent((Holder)holder, LanguageGen.localizeSimpleName((StringRepresentable)element) + " grenade explodes"));
        this.soundEvent((Holder)LTXISounds.RAILGUN_BOOM, "Railgun booms");
        for (GrenadeType element2 : GrenadeType.values()) {
            this.add(element2, LanguageGen.localizeSimpleName((StringRepresentable)element2));
        }
        this.add(LTXILangKeys.INVALID_WEAPON_DEATH_MESSAGE, "%s was killed by an invalid LTX weapon");
        this.add(LTXILangKeys.STRAY_PROJECTILE_DEATH_MESSAGE, "%s was killed by a stray %s");
        this.damageType(LTXIDamageTypes.LIGHTFRAG, "%2$s shot %1$s with %3$s");
        this.damageType(LTXIDamageTypes.EXPLOSIVE_GRENADE, "%s was blown away by %s's %s");
        this.damageType(LTXIDamageTypes.FLAME_GRENADE, "%s was incinerated by %s's %s");
        this.damageType(LTXIDamageTypes.CRYO_GRENADE, "%s was frozen solid by %s's %s");
        this.damageType(LTXIDamageTypes.ELECTRIC_GRENADE, "%s was electrocuted by %s's %s");
        this.damageType(LTXIDamageTypes.ACID_GRENADE, "%s was dissolved by %s's %s");
        this.damageType(LTXIDamageTypes.NEURO_GRENADE, "%s was decayed by %s's %s");
        this.damageType(LTXIDamageTypes.ROCKET_LAUNCHER, "%s was blown up by %s's %s");
        this.noItemCausingEntityOnlyDamageMessage(LTXIDamageTypes.STICKY_FLAME, "%s was cooked well-done by %s", "%s was cooked well-done");
        this.noItemCausingEntityOnlyDamageMessage(LTXIDamageTypes.TURRET_ROCKET, "%s was shot down by %s's Atmos turret", "%s was shot down by a rogue Atmos turret");
        this.noItemCausingEntityOnlyDamageMessage(LTXIDamageTypes.RAILGUN_TURRET, "%s was obliterated by %s's Noctis turret", "%s was obliterated by a rogue Noctis turret");
        this.add(LTXITags.Items.WRENCH_BREAKABLE, "wrench-breakable");
        this.add(LTXITags.GameEvents.WEAPON_VIBRATIONS, "weaponry");
        this.add(LTXITags.GameEvents.HANDHELD_EQUIPMENT, "handheld tool");
        this.namedDamageTag(LTXITags.DamageTypes.WEAPON_DAMAGE, "Weapon Damage");
        this.namedDamageTag(LTXITags.DamageTypes.BYPASS_SURVIVAL_DEFENSES, "Bypass All Survival Defenses");
        this.namedDamageTag((TagKey<DamageType>)DamageTypeTags.NO_ANGER, "No Anger");
        this.namedDamageTag((TagKey<DamageType>)DamageTypeTags.NO_KNOCKBACK, "No Knockback");
        this.add(this.modResources.translationKey("item.{}.guide_tablet"), "Guide Tablet");
        this.add(this.modResources.translationKey("hint.{}.guide_tablet"), "To be completed Soon\u2122");
        this.add(LTXIKeyMappings.CATEGORY_LTXI, "LTX Industries");
        this.add(LTXIKeyMappings.RELOAD_KEY_SUBTITLE, "Reload Weapon");
    }

    private void simpleHintItem(DeferredItem<SimpleHintItem> item, String name, String hint) {
        this.addItem((Supplier)item, name);
        this.add(((SimpleHintItem)item.get()).getShiftHint(), hint);
    }

    private String italicName(String pattern, String name) {
        name = "\u00a7o" + (String)name + "\u00a7r";
        return String.format(pattern, name);
    }

    private void noItemCausingEntityOnlyDamageMessage(ResourceKey<DamageType> damageTypeKey, String translation, String unownedTranslation) {
        this.damageTypeAndVariants(damageTypeKey, translation, collector -> collector.accept("unowned", unownedTranslation));
    }

    private void upgrade(ResourceKey<? extends UpgradeBase<?, ?>> key, String title, String description) {
        this.add(UpgradeBaseBuilder.defaultTitleKey(key), title);
        this.add(UpgradeBaseBuilder.defaultDescriptionKey(key), description);
    }

    private void upgradeDescOnly(ResourceKey<? extends UpgradeBase<?, ?>> key, String description) {
        this.add(UpgradeBaseBuilder.defaultDescriptionKey(key), description);
    }

    private void upgradeTooltip(ResourceKey<? extends UpgradeBase<?, ?>> key, int index, String value) {
        this.add(UpgradeBaseBuilder.tooltipKey(key, index), value);
    }

    private void recipeMode(ResourceKey<RecipeMode> key, String value) {
        this.add(ModResources.registryPrefixedIdLangKey(key), value);
    }

    private void namedDamageTag(TagKey<DamageType> tagKey, String value) {
        this.add(LTXILangKeys.namedDamageTagKey(tagKey), value);
    }
}

