/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import liedge.limacore.data.generation.loot.LimaBlockLootSubProvider;
import liedge.limacore.data.generation.loot.LimaLootSubProvider;
import liedge.limacore.data.generation.loot.LimaLootTableProvider;
import liedge.limacore.lib.MobHostility;
import liedge.limacore.lib.math.LimaRoundingMode;
import liedge.limacore.util.LimaLootUtil;
import liedge.limacore.world.loot.DynamicWeightLootEntry;
import liedge.limacore.world.loot.condition.EntityHostilityLootCondition;
import liedge.limacore.world.loot.level.RangedLookupLevelBasedValue;
import liedge.limacore.world.loot.number.EntityEnchantmentLevelProvider;
import liedge.limacore.world.loot.number.LevelBasedNumberProvider;
import liedge.limacore.world.loot.number.RoundingNumberProvider;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.registry.LTXILootTables;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIMobEffects;
import liedge.ltxindustries.world.GrenadeSubPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.loot.CanItemPerformAbility;

class LootTablesGen
extends LimaLootTableProvider {
    LootTablesGen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
    }

    protected void createSubProviders() {
        this.addSubProvider(EntityBonusDrops::new, LootContextParamSets.ENTITY);
        this.addSubProvider(BlockDrops::new, LootContextParamSets.BLOCK);
    }

    private static class BlockDrops
    extends LimaBlockLootSubProvider {
        BlockDrops(HolderLookup.Provider provider) {
            super(provider, "ltxi");
        }

        protected void generate() {
            Holder fortune = this.registries.holderOrThrow(Enchantments.FORTUNE);
            this.oreDrop((Holder)LTXIBlocks.TITANIUM_ORE, (ItemLike)LTXIItems.RAW_TITANIUM);
            this.oreDrop((Holder)LTXIBlocks.DEEPSLATE_TITANIUM_ORE, (ItemLike)LTXIItems.RAW_TITANIUM);
            this.oreDrop((Holder)LTXIBlocks.NIOBIUM_ORE, (ItemLike)LTXIItems.RAW_NIOBIUM);
            this.dropSelf(new Holder[]{LTXIBlocks.RAW_TITANIUM_BLOCK, LTXIBlocks.RAW_NIOBIUM_BLOCK, LTXIBlocks.TITANIUM_BLOCK, LTXIBlocks.NIOBIUM_BLOCK, LTXIBlocks.SLATESTEEL_BLOCK});
            this.oreCluster((Holder<Block>)LTXIBlocks.RAW_TITANIUM_CLUSTER, (ItemLike)LTXIItems.RAW_TITANIUM);
            this.oreCluster((Holder<Block>)LTXIBlocks.RAW_NIOBIUM_CLUSTER, (ItemLike)LTXIItems.RAW_NIOBIUM);
            this.dropSelf(LTXIBlocks.NEON_LIGHTS.values());
            this.dropSelf(new Holder[]{LTXIBlocks.TITANIUM_PANEL, LTXIBlocks.SMOOTH_TITANIUM_PANEL, LTXIBlocks.TITANIUM_GLASS, LTXIBlocks.SLATESTEEL_PANEL, LTXIBlocks.SMOOTH_SLATESTEEL_PANEL});
            this.add((Holder)LTXIBlocks.SPARK_FRUIT, block -> {
                LootItemBlockStatePropertyCondition.Builder fullGrown = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.AGE_2, 2));
                return this.singleItemTable((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)this.lootItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)).when((LootItemCondition.Builder)fullGrown)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune).when((LootItemCondition.Builder)fullGrown))));
            });
            this.berryVines((Holder<Block>)LTXIBlocks.BILEVINE);
            this.berryVines((Holder<Block>)LTXIBlocks.BILEVINE_PLANT);
            this.dropSelf((Holder)LTXIBlocks.GLOOM_SHROOM);
            this.dropSelfWithEntity((Holder)LTXIBlocks.ENERGY_CELL_ARRAY);
            this.dropSelfWithEntity((Holder)LTXIBlocks.INFINITE_ENERGY_CELL_ARRAY);
            this.dropSelfWithEntity((Holder)LTXIBlocks.DIGITAL_FURNACE);
            this.dropSelfWithEntity((Holder)LTXIBlocks.DIGITAL_SMOKER);
            this.dropSelfWithEntity((Holder)LTXIBlocks.DIGITAL_BLAST_FURNACE);
            this.dropSelfWithEntity((Holder)LTXIBlocks.GRINDER);
            this.dropSelfWithEntity((Holder)LTXIBlocks.MATERIAL_FUSING_CHAMBER);
            this.dropSelfWithEntity((Holder)LTXIBlocks.ELECTROCENTRIFUGE);
            this.dropSelfWithEntity((Holder)LTXIBlocks.MIXER);
            this.dropSelfWithEntity((Holder)LTXIBlocks.VOLTAIC_INJECTOR);
            this.dropSelfWithEntity((Holder)LTXIBlocks.CHEM_LAB);
            this.dropSelfWithEntity((Holder)LTXIBlocks.ASSEMBLER);
            this.dropSelfWithEntity((Holder)LTXIBlocks.FABRICATOR);
            this.dropSelfWithEntity((Holder)LTXIBlocks.AUTO_FABRICATOR);
            this.dropSelfWithEntity((Holder)LTXIBlocks.EQUIPMENT_UPGRADE_STATION);
            this.dropSelfWithEntity((Holder)LTXIBlocks.MOLECULAR_RECONSTRUCTOR);
            this.dropSelfWithEntity((Holder)LTXIBlocks.DIGITAL_GARDEN);
            this.dropSelfWithEntity((Holder)LTXIBlocks.ROCKET_TURRET);
            this.dropSelfWithEntity((Holder)LTXIBlocks.RAILGUN_TURRET);
        }

        private void oreCluster(Holder<Block> oreCluster, ItemLike rawOre) {
            this.add(oreCluster, block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)this.lootItem(rawOre).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))))));
        }

        private void berryVines(Holder<Block> holder) {
            this.add(holder, block -> this.singleItemTable((LootPoolSingletonContainer.Builder)this.lootItem((ItemLike)LTXIItems.VITRIOL_BERRIES).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.BERRIES, true)), CanItemPerformAbility.canItemPerformAbility((ItemAbility)ItemAbilities.SHEARS_DIG)}))));
        }
    }

    private static class EntityBonusDrops
    extends LimaLootSubProvider {
        EntityBonusDrops(HolderLookup.Provider registries) {
            super(registries);
        }

        protected void generateTables() {
            Holder ammoScavengerEnchantment = this.registries.holderOrThrow(LTXIEnchantments.AMMO_SCAVENGER);
            Holder razorEnchantment = this.registries.holderOrThrow(LTXIEnchantments.RAZOR);
            LootPool.Builder phantomDrops = LootPool.lootPool().when(LimaLootUtil.needsEntityType((EntityType)EntityType.PHANTOM)).when(LootItemRandomChanceCondition.randomChance((float)0.1f)).add((LootPoolEntryContainer.Builder)this.lootItem((ItemLike)LTXIItems.TARGETING_TECH_SALVAGE));
            LootItemCondition.Builder acidFinalBlow = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new GrenadeSubPredicate(GrenadeType.ACID)));
            LootItemCondition.Builder corrodingCheck = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().effects(MobEffectsPredicate.Builder.effects().and(LTXIMobEffects.CORROSIVE)));
            LootPool.Builder wardenDrops = LootPool.lootPool().when(LimaLootUtil.needsEntityType((EntityType)EntityType.WARDEN)).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{acidFinalBlow, corrodingCheck})).add((LootPoolEntryContainer.Builder)this.lootItem((ItemLike)LTXIItems.NEURO_CHEMICAL));
            this.addTable(LTXILootTables.ENTITY_EXTRA_DROPS, LootTable.lootTable().withPool(phantomDrops).withPool(wardenDrops));
            Function<LevelBasedValue, NumberProvider> ammoWeights = lbv -> LevelBasedNumberProvider.of((NumberProvider)EntityEnchantmentLevelProvider.enchantLevel((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (Holder)ammoScavengerEnchantment), (LevelBasedValue)lbv);
            LootPool.Builder ammoDrops = LootPool.lootPool().when(EntityHostilityLootCondition.atLeast((MobHostility)MobHostility.NEUTRAL_ENEMY)).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.1f, (float)0.02f)).add((LootPoolEntryContainer.Builder)this.lootItem((ItemLike)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY).setWeight(80)).add((LootPoolEntryContainer.Builder)DynamicWeightLootEntry.dynamicWeightItem(LTXIItems.SPECIALIST_WEAPON_ENERGY, (int)15).setReplaceWeight(false).setDynamicWeight(ammoWeights.apply((LevelBasedValue)LevelBasedValue.perLevel((float)6.0f)))).add((LootPoolEntryContainer.Builder)DynamicWeightLootEntry.dynamicWeightItem(LTXIItems.EXPLOSIVES_WEAPON_ENERGY, (int)5).setReplaceWeight(false).setDynamicWeight(ammoWeights.apply((LevelBasedValue)LevelBasedValue.perLevel((float)3.0f)))).add((LootPoolEntryContainer.Builder)DynamicWeightLootEntry.dynamicWeightItem(LTXIItems.HEAVY_WEAPON_ENERGY, (int)1).setReplaceWeight(false).setDynamicWeight(ammoWeights.apply((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)))).setRolls(RoundingNumberProvider.of((NumberProvider)ammoWeights.apply((LevelBasedValue)RangedLookupLevelBasedValue.lookupAfterLevel((int)3, (float[])new float[]{1.0f, 1.5f, 2.0f})), (LimaRoundingMode)LimaRoundingMode.RANDOM));
            this.addTable(LTXILootTables.ENEMY_AMMO_DROPS, LootTable.lootTable().withPool(ammoDrops));
            LootPool.Builder razorGeneralHeads = LootPool.lootPool().when(LimaLootUtil.randomChanceLinearEnchantBonus((Holder)razorEnchantment, (float)0.0f, (float)0.1f)).add(this.lootItem((ItemLike)Items.ZOMBIE_HEAD).when(LimaLootUtil.needsEntityTag((TagKey)EntityTypeTags.ZOMBIES))).add(((LootPoolSingletonContainer.Builder)this.lootItem((ItemLike)Items.SKELETON_SKULL).when(LimaLootUtil.needsEntityTag((TagKey)EntityTypeTags.SKELETONS))).when(LimaLootUtil.needsEntityType((EntityType)EntityType.WITHER_SKELETON).invert())).add(this.lootItem((ItemLike)Items.CREEPER_HEAD).when(LimaLootUtil.needsEntityType((EntityType)EntityType.CREEPER))).add(this.lootItem((ItemLike)Items.PIGLIN_HEAD).when(LimaLootUtil.needsEntityType((EntityType)EntityType.PIGLIN))).add(this.lootItem((ItemLike)Items.WITHER_SKELETON_SKULL).when(LimaLootUtil.needsEntityType((EntityType)EntityType.WITHER_SKELETON))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.lootItem((ItemLike)Items.PLAYER_HEAD).when(LimaLootUtil.needsEntityType((EntityType)EntityType.PLAYER))).apply((LootItemFunction.Builder)FillPlayerHead.fillPlayerHead((LootContext.EntityTarget)LootContext.EntityTarget.THIS)));
            LootPool.Builder razorDragonHead = LootPool.lootPool().when(LimaLootUtil.needsEntityType((EntityType)EntityType.ENDER_DRAGON)).when(LimaLootUtil.randomChanceWithEnchantBonus((Holder)razorEnchantment, (float)0.0f, (LevelBasedValue)RangedLookupLevelBasedValue.lookupAfterLevelOrBelow((int)4, (float)0.0f, (float[])new float[]{0.5f, 1.0f}))).add((LootPoolEntryContainer.Builder)this.lootItem((ItemLike)Items.DRAGON_HEAD));
            LootPool.Builder razorRabbitFoot = LootPool.lootPool().when(LimaLootUtil.needsEntityType((EntityType)EntityType.RABBIT)).when(LimaLootUtil.randomChanceLinearEnchantBonus((Holder)razorEnchantment, (float)0.0f, (float)0.33f)).add((LootPoolEntryContainer.Builder)this.lootItem((ItemLike)Items.RABBIT_FOOT));
            this.addTable(LTXILootTables.RAZOR_LOOT_TABLE, LootTable.lootTable().withPool(razorGeneralHeads).withPool(razorDragonHead).withPool(razorRabbitFoot));
        }
    }
}

