/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import liedge.limacore.data.generation.LimaRecipeProvider;
import liedge.limacore.data.generation.recipe.LimaCookingRecipeBuilder;
import liedge.limacore.data.generation.recipe.LimaCustomRecipeBuilder;
import liedge.limacore.data.generation.recipe.LimaShapelessRecipeBuilder;
import liedge.limacore.lib.ModResources;
import liedge.limacore.lib.function.ObjectIntFunction;
import liedge.limacore.recipe.result.ItemResult;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.NeonLightColor;
import liedge.ltxindustries.integration.guideme.GuideMEIntegration;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgradeEntry;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrade;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgradeEntry;
import liedge.ltxindustries.recipe.AssemblingRecipe;
import liedge.ltxindustries.recipe.ChemicalReactingRecipe;
import liedge.ltxindustries.recipe.DefaultUpgradeModuleRecipe;
import liedge.ltxindustries.recipe.ElectroCentrifugingRecipe;
import liedge.ltxindustries.recipe.EnergizingRecipe;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.recipe.GardenSimulatingRecipe;
import liedge.ltxindustries.recipe.GrindingRecipe;
import liedge.ltxindustries.recipe.LTXIRecipe;
import liedge.ltxindustries.recipe.LTXIRecipeSerializer;
import liedge.ltxindustries.recipe.MaterialFusingRecipe;
import liedge.ltxindustries.recipe.MixingRecipe;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIMachineUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIRecipeModes;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIFluids;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeSerializers;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.Nullable;

class RecipesGen
extends LimaRecipeProvider {
    RecipesGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, LTXIndustries.RESOURCES);
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        SpecialRecipeBuilder.special(DefaultUpgradeModuleRecipe::new).save(output, this.modResources.location("default_upgrade_module"));
        this.nineStorageRecipes(output, (ItemLike)LTXIItems.RAW_TITANIUM, (ItemLike)LTXIBlocks.RAW_TITANIUM_BLOCK);
        this.nineStorageRecipes(output, (ItemLike)LTXIItems.RAW_NIOBIUM, (ItemLike)LTXIBlocks.RAW_NIOBIUM_BLOCK);
        this.nuggetIngotBlockRecipes(output, "titanium", (ItemLike)LTXIItems.TITANIUM_NUGGET, (ItemLike)LTXIItems.TITANIUM_INGOT, (ItemLike)LTXIBlocks.TITANIUM_BLOCK);
        this.nuggetIngotBlockRecipes(output, "niobium", (ItemLike)LTXIItems.NIOBIUM_NUGGET, (ItemLike)LTXIItems.NIOBIUM_INGOT, (ItemLike)LTXIBlocks.NIOBIUM_BLOCK);
        this.nuggetIngotBlockRecipes(output, "slatesteel", (ItemLike)LTXIItems.SLATESTEEL_NUGGET, (ItemLike)LTXIItems.SLATESTEEL_INGOT, (ItemLike)LTXIBlocks.SLATESTEEL_BLOCK);
        this.shaped((ItemLike)LTXIBlocks.TITANIUM_PANEL, 32).input('t', LTXIItems.TITANIUM_INGOT).input('f', LTXIItems.POLYMER_INGOT).patterns(new String[]{"tft", "f f", "tft"}).bookCategory(CraftingBookCategory.BUILDING).save(output);
        this.shaped((ItemLike)LTXIBlocks.SMOOTH_TITANIUM_PANEL, 32).input('t', LTXIItems.TITANIUM_INGOT).input('f', LTXIItems.POLYMER_INGOT).patterns(new String[]{"ftf", "t t", "ftf"}).bookCategory(CraftingBookCategory.BUILDING).save(output);
        this.shaped((ItemLike)LTXIBlocks.SLATESTEEL_PANEL, 32).input('s', LTXIItems.SLATESTEEL_INGOT).input('f', LTXIItems.POLYMER_INGOT).patterns(new String[]{"sfs", "f f", "sfs"}).bookCategory(CraftingBookCategory.BUILDING).save(output);
        this.shaped((ItemLike)LTXIBlocks.SMOOTH_SLATESTEEL_PANEL, 32).input('s', LTXIItems.SLATESTEEL_INGOT).input('f', LTXIItems.POLYMER_INGOT).patterns(new String[]{"fsf", "s s", "fsf"}).bookCategory(CraftingBookCategory.BUILDING).save(output);
        this.shaped((ItemLike)LTXIItems.T1_CIRCUIT).input('c', (ItemLike)Items.STONE_PRESSURE_PLATE).input('m', (ItemLike)Items.COPPER_INGOT).input('r', (ItemLike)Items.REDSTONE).input('t', LTXIItems.TITANIUM_INGOT).patterns(new String[]{"tmt", "mcm", "rmr"}).save(output);
        this.shaped((ItemLike)LTXIItems.T2_CIRCUIT).input('c', LTXIItems.T1_CIRCUIT).input('m', (ItemLike)Items.GOLD_INGOT).input('r', (ItemLike)Items.REPEATER).input('t', LTXIItems.TITANIUM_INGOT).input('b', (ItemLike)Items.COPPER_INGOT).patterns(new String[]{" r ", "mcm", "tbt"}).save(output);
        this.shaped((ItemLike)LTXIItems.EMPTY_UPGRADE_MODULE).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('g', Tags.Items.GLASS_BLOCKS_CHEAP).patterns(new String[]{"ggg", "gcg", "ttt"}).save(output);
        this.shaped((ItemLike)LTXIItems.EMPTY_FABRICATION_BLUEPRINT, 2).input('l', Tags.Items.DYES_LIME).input('p', (ItemLike)Items.PAPER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).patterns(new String[]{"lll", "ppp", "tct"}).save(output);
        this.shaped((ItemLike)LTXIItems.ITEMS_IO_CONFIG_CARD).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('m', (ItemLike)Items.CHEST).patterns(new String[]{" m ", "tct", " t "}).save(output);
        this.shaped((ItemLike)LTXIItems.ENERGY_IO_CONFIG_CARD).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('m', LTXIItems.ELECTRIC_CHEMICAL).patterns(new String[]{" m ", "tct", " t "}).save(output);
        this.shaped((ItemLike)LTXIItems.FLUIDS_IO_CONFIG_CARD).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('m', (ItemLike)Items.BUCKET).patterns(new String[]{" m ", "tct", " t "}).save(output);
        this.shaped(this.defaultUpgradableItem((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_WRENCH, registries)).input('t', LTXIItems.TITANIUM_INGOT).input('l', Tags.Items.DYES_LIME).patterns(new String[]{"t t", " l ", " t "}).save(output);
        ((LimaShapelessRecipeBuilder)((LimaShapelessRecipeBuilder)((LimaShapelessRecipeBuilder)((LimaShapelessRecipeBuilder)this.shapeless(GuideMEIntegration.createGuideTabletItem()).condition((ICondition)new ModLoadedCondition("guideme"))).input((ItemLike)Items.BOOK)).input(LTXIItems.TITANIUM_INGOT)).input(Tags.Items.DYES_LIME)).save(output, "guide_tablet");
        this.shaped((ItemLike)LTXIBlocks.ENERGY_CELL_ARRAY).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('e', LTXIItems.ELECTRIC_CHEMICAL).input('b', (ItemLike)Items.COPPER_BLOCK).patterns(new String[]{"tct", "ebe", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.DIGITAL_FURNACE).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('a', (ItemLike)Items.FURNACE).input('g', Tags.Items.GLASS_BLOCKS_CHEAP).patterns(new String[]{"tct", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.DIGITAL_SMOKER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('a', (ItemLike)Items.SMOKER).input('g', Tags.Items.GLASS_BLOCKS_CHEAP).patterns(new String[]{"tct", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.DIGITAL_BLAST_FURNACE).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('a', (ItemLike)Items.BLAST_FURNACE).input('g', Tags.Items.GLASS_BLOCKS_CHEAP).patterns(new String[]{"tct", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.GRINDER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('a', (ItemLike)Items.GRINDSTONE).input('i', (ItemLike)Items.IRON_INGOT).patterns(new String[]{"tct", "iai", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.MATERIAL_FUSING_CHAMBER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T2_CIRCUIT).input('a', (ItemLike)Items.BLAST_FURNACE).input('o', (ItemLike)Items.OBSIDIAN).patterns(new String[]{"tct", "oao", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.ELECTROCENTRIFUGE).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T2_CIRCUIT).input('a', (ItemLike)Items.CAULDRON).input('g', LTXIBlocks.TITANIUM_GLASS).patterns(new String[]{"gcg", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.MIXER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T2_CIRCUIT).input('a', (ItemLike)Items.CAULDRON).input('g', LTXIBlocks.TITANIUM_GLASS).patterns(new String[]{"tct", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.VOLTAIC_INJECTOR).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T1_CIRCUIT).input('a', (ItemLike)Items.STONE_PRESSURE_PLATE).input('r', (ItemLike)Items.LIGHTNING_ROD).patterns(new String[]{"tct", "rar", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.CHEM_LAB).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T2_CIRCUIT).input('a', (ItemLike)Items.BREWING_STAND).input('g', LTXIBlocks.TITANIUM_GLASS).patterns(new String[]{"tct", "gag", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.ASSEMBLER).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T2_CIRCUIT).input('a', (ItemLike)Items.CRAFTER).input('s', LTXIItems.SLATESTEEL_INGOT).patterns(new String[]{"tct", "sas", "tct"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.FABRICATOR).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T3_CIRCUIT).input('a', (ItemLike)Items.CRAFTING_TABLE).patterns(new String[]{"tct", "cac", "ttt"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.AUTO_FABRICATOR).input('p', LTXIItems.POLYMER_INGOT).input('t', LTXIItems.TITANIUM_INGOT).input('c', LTXIItems.T3_CIRCUIT).input('s', LTXIItems.SLATESTEEL_INGOT).input('g', LTXIBlocks.TITANIUM_GLASS).input('a', (ItemLike)Items.CRAFTER).patterns(new String[]{"pcp", "gag", "tst"}).save(output);
        this.shaped((ItemLike)LTXIBlocks.EQUIPMENT_UPGRADE_STATION).input('t', LTXIItems.TITANIUM_INGOT).input('a', (ItemLike)Items.ANVIL).input('l', Tags.Items.DYES_LIME).patterns(new String[]{"ttt", "lal", "ttt"}).save(output);
        String smsRecipeName = LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS.location().getPath();
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 1)).input('m', LTXIItems.EMPTY_UPGRADE_MODULE).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T1_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_1");
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 2)).input('m', this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 1)).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T1_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_2");
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 3)).input('m', this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 2)).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T2_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_3");
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 4)).input('m', this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 3)).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T2_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_4");
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 5)).input('m', this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 4)).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T3_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_5");
        this.shaped(this.mumStack(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 6)).input('m', this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 5)).input('r', (ItemLike)Items.REDSTONE).input('c', LTXIItems.T3_CIRCUIT).patterns(new String[]{" r ", "rmr", " c "}).save(output, smsRecipeName + "_6");
        LTXIBlocks.NEON_LIGHTS.forEach((color, holder) -> this.shaped((ItemLike)holder, 4).input('d', this.neonLightDye((NeonLightColor)((Object)color))).input('g', (ItemLike)Items.GLOWSTONE).patterns(new String[]{"dg", "gd"}).save(output));
        this.oreSmeltBlast(output, "smelt_raw_titanium", (ItemLike)LTXIItems.RAW_TITANIUM, this.stackOf((ItemLike)LTXIItems.TITANIUM_INGOT));
        this.oreSmeltBlast(output, "smelt_stone_titanium", (ItemLike)LTXIBlocks.TITANIUM_ORE, this.stackOf((ItemLike)LTXIItems.TITANIUM_INGOT));
        this.oreSmeltBlast(output, "smelt_deepslate_titanium", (ItemLike)LTXIBlocks.DEEPSLATE_TITANIUM_ORE, this.stackOf((ItemLike)LTXIItems.TITANIUM_INGOT));
        this.oreSmeltBlast(output, "smelt_raw_niobium", (ItemLike)LTXIItems.RAW_NIOBIUM, this.stackOf((ItemLike)LTXIItems.NIOBIUM_INGOT));
        this.oreSmeltBlast(output, "smelt_niobium_ore", (ItemLike)LTXIBlocks.NIOBIUM_ORE, this.stackOf((ItemLike)LTXIItems.NIOBIUM_INGOT));
        this.orePebblesCooking((ItemLike)LTXIItems.COAL_ORE_PEBBLES, (ItemLike)Items.COAL, 2, output);
        this.orePebblesCooking((ItemLike)LTXIItems.COPPER_ORE_PEBBLES, (ItemLike)Items.COPPER_INGOT, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.IRON_ORE_PEBBLES, (ItemLike)Items.IRON_INGOT, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.LAPIS_ORE_PEBBLES, (ItemLike)Items.LAPIS_LAZULI, 6, output);
        this.orePebblesCooking((ItemLike)LTXIItems.REDSTONE_ORE_PEBBLES, (ItemLike)Items.REDSTONE, 8, output);
        this.orePebblesCooking((ItemLike)LTXIItems.GOLD_ORE_PEBBLES, (ItemLike)Items.GOLD_INGOT, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.DIAMOND_ORE_PEBBLES, (ItemLike)Items.DIAMOND, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.EMERALD_ORE_PEBBLES, (ItemLike)Items.EMERALD, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.QUARTZ_ORE_PEBBLES, (ItemLike)Items.QUARTZ, 4, output);
        this.orePebblesCooking((ItemLike)LTXIItems.NETHERITE_ORE_PEBBLES, (ItemLike)Items.NETHERITE_SCRAP, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.TITANIUM_ORE_PEBBLES, (ItemLike)LTXIItems.TITANIUM_INGOT, 1, output);
        this.orePebblesCooking((ItemLike)LTXIItems.NIOBIUM_ORE_PEBBLES, (ItemLike)LTXIItems.NIOBIUM_INGOT, 1, output);
        this.grindingRecipes(output, registries);
        this.mfcRecipes(output);
        this.electroCentrifugingRecipes(output, registries);
        this.mixingRecipes(output);
        this.energizingRecipes(output, registries);
        this.chemLabRecipes(output);
        this.assemblingRecipes(output, registries);
        this.gardenSimRecipes(output, registries);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(20000000).input((ItemLike)LTXIItems.CIRCUIT_BOARD)).input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 12)).input((ItemLike)LTXIItems.POLYMER_INGOT, 16)).input((ItemLike)Items.REDSTONE, 32)).input((ItemLike)LTXIItems.NIOBIUM_INGOT, 8)).input((ItemLike)Items.DIAMOND, 8)).input((ItemLike)LTXIItems.CHORUS_CHEMICAL, 4)).output((ItemLike)LTXIItems.T4_CIRCUIT)).group("circuits")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(100000000).input((ItemLike)LTXIItems.CIRCUIT_BOARD)).input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 24)).input((ItemLike)LTXIItems.POLYMER_INGOT, 48)).input((ItemLike)LTXIItems.NIOBIUM_INGOT, 16)).input((ItemLike)Items.REDSTONE, 48)).input((ItemLike)Items.AMETHYST_SHARD, 12)).input((ItemLike)LTXIItems.SCULK_CHEMICAL, 8)).output((ItemLike)LTXIItems.T5_CIRCUIT)).group("circuits")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(1000000).input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 12)).output((ItemLike)LTXIBlocks.DIGITAL_GARDEN)).group("machines")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(2000000).input((ItemLike)Items.ANVIL)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 20)).input((ItemLike)LTXIBlocks.SLATESTEEL_BLOCK)).input((ItemLike)LTXIItems.T4_CIRCUIT)).output((ItemLike)LTXIBlocks.MOLECULAR_RECONSTRUCTOR)).group("machines")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(500000).input((ItemLike)Items.GUNPOWDER, 8)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIItems.T2_CIRCUIT)).output((ItemLike)LTXIItems.EXPLOSIVES_WEAPON_TECH_SALVAGE)).group("tech_parts")).requiresAdvancement().unlockedBy("visited_fortress", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)registries.holderOrThrow(BuiltinStructures.FORTRESS))))).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(2500000).input((ItemLike)LTXIItems.TARGETING_TECH_SALVAGE)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 32)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 16)).input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).output((ItemLike)LTXIBlocks.ROCKET_TURRET)).group("turrets")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.fabricating(5000000).input((ItemLike)LTXIItems.TARGETING_TECH_SALVAGE)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 32)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 16)).input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).output((ItemLike)LTXIBlocks.RAILGUN_TURRET)).group("turrets")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_DRILL, registries, 1000000).input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 9)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 3)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 6)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_SWORD, registries, 1000000).input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_SHOVEL, registries, 1000000).input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 3)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 1)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 2)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_AXE, registries, 1000000).input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 9)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 3)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 6)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_HOE, registries, 1000000).input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_SHEARS, registries, 500000).input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 2)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_BRUSH, registries, 500000).input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 3)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT)).input((ItemLike)Items.FEATHER, 3)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 2)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_FISHING_ROD, registries, 500000).input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)Items.STRING, 2)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LTX_LIGHTER, registries, 500000).input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 3)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT)).input((ItemLike)Items.FLINT)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 2)).group("ltx/tool")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.GLOWSTICK_LAUNCHER, registries, 250000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input(Tags.Items.DYES_LIME, 3)).input((ItemLike)Items.GLOWSTONE_DUST, 8)).input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.SUBMACHINE_GUN, registries, 500000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 24)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.SHOTGUN, registries, 1000000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 24)).input((ItemLike)LTXIItems.POLYMER_INGOT, 16)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 8)).input((ItemLike)LTXIItems.T2_CIRCUIT, 4)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.GRENADE_LAUNCHER, registries, 20000000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 24)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 12)).input((ItemLike)LTXIItems.EXPLOSIVES_WEAPON_TECH_SALVAGE)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 6)).input((ItemLike)LTXIItems.T2_CIRCUIT, 6)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.LINEAR_FUSION_RIFLE, registries, 25000000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 24)).input((ItemLike)LTXIItems.POLYMER_INGOT, 32)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 12)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 8)).input((ItemLike)Items.AMETHYST_SHARD, 2)).input((ItemLike)LTXIItems.T2_CIRCUIT, 6)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.ROCKET_LAUNCHER, registries, 30000000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 48)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 24)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 16)).input((ItemLike)LTXIItems.EXPLOSIVES_WEAPON_TECH_SALVAGE)).input((ItemLike)LTXIItems.T3_CIRCUIT, 8)).group("ltx/weapon")).save(output);
        ((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)this.upgradeableItemFabricating((Supplier<? extends UpgradableEquipmentItem>)LTXIItems.HEAVY_PISTOL, registries, 50000000).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 8)).input((ItemLike)LTXIItems.T4_CIRCUIT, 1)).requiresAdvancement().unlockedBy("kill_boss", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(LTXITags.EntityTypes.HIGH_THREAT_TARGETS)))).group("ltx/weapon")).save(output);
        String eumTools = "eum/tool";
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_ENERGY_UPGRADE, 1, 100000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 2)).input((ItemLike)LTXIItems.POLYMER_INGOT, 4)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 4));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_ENERGY_UPGRADE, 2, 250000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIItems.POLYMER_INGOT, 8)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 8));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_ENERGY_UPGRADE, 3, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 16)).input((ItemLike)Items.GOLD_INGOT, 4)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 16));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_ENERGY_UPGRADE, 4, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIItems.NIOBIUM_INGOT, 2)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 32));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, 1, 100000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT)).input((ItemLike)Items.STRING, 4)).input((ItemLike)Items.COD, 2));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, 2, 250000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).input((ItemLike)Items.STRING, 8)).input((ItemLike)Items.COD, 4)).input((ItemLike)Items.SALMON, 2));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, 3, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 2)).input((ItemLike)Items.STRING, 8)).input((ItemLike)Items.PUFFERFISH, 2));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, 4, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)Items.STRING, 4)).input((ItemLike)LTXIItems.CARBON_DUST, 12)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 6)).input((ItemLike)Items.PRISMARINE_CRYSTALS, 2));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_FISHING_LURE, 5, 2000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 4)).input((ItemLike)LTXIItems.POLYMER_INGOT, 8)).input((ItemLike)Items.STRING, 8)).input((ItemLike)LTXIItems.CARBON_DUST, 24)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 12)).input((ItemLike)Items.HEART_OF_THE_SEA));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_NETHERITE_LEVEL, 1, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.DIAMOND, 3)).input((ItemLike)Items.NETHERITE_INGOT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 4));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.EPSILON_OMNI_DRILL, 1, 20000000, builder -> (FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 16));
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_VIBRATION_CANCEL, 1, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 8)).input(ItemTags.WOOL, 8)).input((ItemLike)LTXIItems.SCULK_CHEMICAL, 4));
        UnaryOperator directDrops = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)Items.NETHER_STAR)).input((ItemLike)LTXIItems.CHORUS_CHEMICAL, 8)).input((ItemLike)Items.ENDER_PEARL, 8);
        this.equipmentModuleFab(output, registries, "eum/tool", LTXIEquipmentUpgrades.TOOL_DIRECT_DROPS, 1, 15000000, directDrops);
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_DIRECT_DROPS, 1, 15000000, directDrops);
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_ARMOR_PIERCE, 1, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.OBSIDIAN, 8)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_ARMOR_PIERCE, 2, 2500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.OBSIDIAN, 32)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 32));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_ARMOR_PIERCE, 3, 5000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)Items.OBSIDIAN, 64)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 4));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.HIGH_IMPACT_ROUNDS, 1, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.TNT, 8)).input((ItemLike)Items.PISTON, 2));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_VIBRATION_CANCEL, 1, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.POLYMER_INGOT, 16)).input(ItemTags.WOOL, 16)).input((ItemLike)LTXIItems.SCULK_CHEMICAL, 8));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.UNIVERSAL_STEALTH_DAMAGE, 1, 750000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)Items.PHANTOM_MEMBRANE, 12)).input((ItemLike)Items.ENDER_PEARL, 8)).input(DataComponentIngredient.of((boolean)false, (DataComponentPredicate)DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.INVISIBILITY)).build(), (ItemLike[])new ItemLike[]{Items.POTION})));
        UnaryOperator targetFilter = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)Items.PHANTOM_MEMBRANE, 2)).input((ItemLike)Items.ENDER_PEARL, 2);
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.NEUTRAL_ENEMY_TARGET_FILTER, 1, 225000, targetFilter);
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.HOSTILE_TARGET_FILTER, 1, 225000, targetFilter);
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_SHIELD_REGEN, 1, 1500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.GOLDEN_APPLE, 1)).input(DataComponentIngredient.of((boolean)false, (DataComponentPredicate)DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.FIRE_RESISTANCE)).build(), (ItemLike[])new ItemLike[]{Items.POTION}))).input((ItemLike)Items.SHIELD)).input((ItemLike)Items.DIAMOND, 4));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_SHIELD_REGEN, 2, 3000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)Items.GOLDEN_APPLE, 2)).input((ItemLike)Items.DIAMOND, 8)).input((ItemLike)Items.AMETHYST_SHARD, 2));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.WEAPON_SHIELD_REGEN, 3, 5000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 1)).input((ItemLike)Items.AMETHYST_SHARD, 8)).input((ItemLike)Items.ENCHANTED_GOLDEN_APPLE));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, 1, 250000, builder -> (FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 4));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, 2, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 4)).input((ItemLike)Items.REDSTONE, 8));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, 3, 750000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 8)).input((ItemLike)Items.BLAZE_POWDER, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, 4, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 8)).input((ItemLike)Items.BLAZE_POWDER, 8)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 4)).input((ItemLike)LTXIItems.POLYMER_INGOT, 8));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.EFFICIENCY_ENCHANTMENT, 5, 2000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)Items.REDSTONE, 8)).input((ItemLike)Items.BLAZE_POWDER, 12)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 12)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 16));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.SILK_TOUCH_ENCHANTMENT, 1, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT)).input((ItemLike)Items.EMERALD, 1)).input((ItemLike)Items.SLIME_BALL, 8)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 4));
        UnaryOperator multi1 = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).input((ItemLike)Items.IRON_INGOT, 4)).input((ItemLike)Items.RABBIT_FOOT)).input((ItemLike)Items.LAPIS_LAZULI, 4);
        UnaryOperator multi2 = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)Items.RABBIT_FOOT, 2)).input((ItemLike)Items.LAPIS_LAZULI, 8);
        UnaryOperator multi3 = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)Items.EMERALD, 2)).input((ItemLike)Items.DIAMOND, 2)).input((ItemLike)Items.LAPIS_BLOCK, 2);
        UnaryOperator multi4 = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 8)).input((ItemLike)Items.EMERALD, 6)).input((ItemLike)Items.DIAMOND, 6)).input((ItemLike)Items.AMETHYST_BLOCK, 3)).input((ItemLike)Items.NETHER_STAR, 1)).input((ItemLike)Items.LAPIS_BLOCK, 4);
        UnaryOperator multi5 = builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)Items.EMERALD_BLOCK, 1)).input((ItemLike)Items.DIAMOND_BLOCK, 1)).input((ItemLike)Items.AMETHYST_BLOCK, 6)).input((ItemLike)Items.NETHER_STAR, 2)).input((ItemLike)Items.LAPIS_BLOCK, 8);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, 1, 125000, multi1);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, 1, 125000, multi1);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, 2, 250000, multi2);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, 2, 250000, multi2);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, 3, 500000, multi3);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, 3, 500000, multi3);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, 4, 1000000, multi4);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, 4, 1000000, multi4);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.LOOTING_ENCHANTMENT, 5, 10000000, multi5);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.FORTUNE_ENCHANTMENT, 5, 10000000, multi5);
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, 1, 250000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)Items.ZOMBIE_HEAD)).input((ItemLike)Items.CREEPER_HEAD)).input((ItemLike)Items.SKELETON_SKULL));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, 2, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.DIAMOND, 2)).input((ItemLike)Items.ZOMBIE_HEAD, 2)).input((ItemLike)Items.CREEPER_HEAD, 2)).input((ItemLike)Items.SKELETON_SKULL, 2));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, 3, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.ZOMBIE_HEAD, 4)).input((ItemLike)Items.SKELETON_SKULL, 4)).input((ItemLike)Items.CREEPER_HEAD, 4));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, 4, 200000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)Items.WITHER_SKELETON_SKULL, 6)).input((ItemLike)Items.PIGLIN_HEAD, 6));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.RAZOR_ENCHANTMENT, 5, 4000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)Items.ZOMBIE_HEAD, 8)).input((ItemLike)Items.CREEPER_HEAD, 8)).input((ItemLike)Items.SKELETON_SKULL, 8)).input((ItemLike)Items.WITHER_SKELETON_SKULL, 8)).input((ItemLike)Items.PIGLIN_HEAD, 8)).input((ItemLike)Items.DRAGON_HEAD, 1));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, 1, 300000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)Items.GUNPOWDER, 8)).input((ItemLike)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, 2));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, 2, 600000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 12)).input((ItemLike)Items.LAPIS_LAZULI, 16)).input((ItemLike)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, 4));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, 3, 900000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, 8)).input((ItemLike)LTXIItems.SPECIALIST_WEAPON_ENERGY, 2));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, 4, 1200000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)LTXIItems.SPECIALIST_WEAPON_ENERGY, 4)).input((ItemLike)LTXIItems.EXPLOSIVES_WEAPON_ENERGY, 2));
        this.equipmentModuleFab(output, registries, "eum/enchant", LTXIEquipmentUpgrades.AMMO_SCAVENGER_ENCHANTMENT, 5, 1500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 4)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 2)).input((ItemLike)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, 16)).input((ItemLike)LTXIItems.SPECIALIST_WEAPON_ENERGY, 8)).input((ItemLike)LTXIItems.EXPLOSIVES_WEAPON_ENERGY, 4)).input((ItemLike)LTXIItems.HEAVY_WEAPON_ENERGY, 2));
        this.equipmentModuleFab(output, registries, "eum/weapon/gl", LTXIEquipmentUpgrades.FLAME_GRENADE_CORE, 1, 2500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 8)).input((ItemLike)Items.BLAZE_POWDER, 16));
        this.equipmentModuleFab(output, registries, "eum/weapon/gl", LTXIEquipmentUpgrades.CRYO_GRENADE_CORE, 1, 2500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 8)).input((ItemLike)Items.ICE, 16));
        this.equipmentModuleFab(output, registries, "eum/weapon/gl", LTXIEquipmentUpgrades.ELECTRIC_GRENADE_CORE, 1, 5000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 16)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 12)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 32));
        this.equipmentModuleFab(output, registries, "eum/weapon/gl", LTXIEquipmentUpgrades.ACID_GRENADE_CORE, 1, 25000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 32)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 16)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIItems.VIRIDIC_WEAPON_CHEMICAL, 16));
        this.equipmentModuleFab(output, registries, "eum/weapon/gl", LTXIEquipmentUpgrades.NEURO_GRENADE_CORE, 1, 50000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)LTXIBlocks.TITANIUM_GLASS, 32)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 16)).input((ItemLike)LTXIItems.POLYMER_INGOT, 24)).input((ItemLike)LTXIItems.NEURO_CHEMICAL, 8));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.GRENADE_LAUNCHER_PROJECTILE_SPEED, 1, 750000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.FIREWORK_ROCKET, 9)).input((ItemLike)Items.PHANTOM_MEMBRANE, 2));
        this.equipmentModuleFab(output, registries, "eum/weapon", LTXIEquipmentUpgrades.GRENADE_LAUNCHER_PROJECTILE_SPEED, 2, 2000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 3)).input((ItemLike)Items.FIREWORK_ROCKET, 36)).input((ItemLike)Items.PHANTOM_MEMBRANE, 8));
        this.machineModuleFab(output, registries, "mum/gpm", LTXIMachineUpgrades.ULTIMATE_MACHINE_SYSTEMS, 1, 250000000, false, null, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input(this.mumIngredient(registries, LTXIMachineUpgrades.STANDARD_MACHINE_SYSTEMS, 6))).input((ItemLike)LTXIItems.T5_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE_BLOCK, 16)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 32));
        this.machineModuleFab(output, registries, "mum/eca", LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, 1, 250000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T1_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 4)).input((ItemLike)Items.COPPER_INGOT, 4));
        this.machineModuleFab(output, registries, "mum/eca", LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, 2, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 8)).input((ItemLike)Items.COPPER_INGOT, 8));
        this.machineModuleFab(output, registries, "mum/eca", LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, 3, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T2_CIRCUIT, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 16)).input((ItemLike)Items.GOLD_INGOT, 8));
        this.machineModuleFab(output, registries, "mum/eca", LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, 4, 5000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 12)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 4)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 24)).input((ItemLike)LTXIItems.NIOBIUM_INGOT, 4));
        this.machineModuleFab(output, registries, "mum/eca", LTXIMachineUpgrades.ECA_CAPACITY_UPGRADE, 5, 20000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 8)).input((ItemLike)LTXIItems.POLYMER_INGOT, 12)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 48)).input((ItemLike)LTXIItems.NIOBIUM_INGOT, 8)).input((ItemLike)LTXIItems.CHORUS_CHEMICAL, 8));
        this.machineModuleFab(output, registries, "mum/fabricator", LTXIMachineUpgrades.FABRICATOR_UPGRADE, 1, 500000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).input((ItemLike)Items.DIAMOND, 2)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.T2_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 8));
        this.machineModuleFab(output, registries, "mum/fabricator", LTXIMachineUpgrades.FABRICATOR_UPGRADE, 2, 1000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 4)).input((ItemLike)Items.DIAMOND, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 8)).input((ItemLike)LTXIItems.T3_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 8));
        this.machineModuleFab(output, registries, "mum/fabricator", LTXIMachineUpgrades.FABRICATOR_UPGRADE, 3, 5000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 8)).input((ItemLike)Items.AMETHYST_SHARD, 4)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.T4_CIRCUIT)).input((ItemLike)Items.REDSTONE, 32));
        this.machineModuleFab(output, registries, "mum/fabricator", LTXIMachineUpgrades.FABRICATOR_UPGRADE, 4, 10000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.LTX_LIME_PIGMENT, 8)).input((ItemLike)Items.AMETHYST_SHARD, 8)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 16)).input((ItemLike)LTXIItems.T4_CIRCUIT, 2)).input((ItemLike)Items.REDSTONE, 32));
        this.machineModuleFab(output, registries, "mum/turret", LTXIMachineUpgrades.TURRET_LOOT_COLLECTOR, 1, 10000000, builder -> (FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)((FabricatingBuilder)builder.input((ItemLike)LTXIItems.T3_CIRCUIT, 3)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 12)).input((ItemLike)LTXIItems.SLATESTEEL_INGOT, 6)).input((ItemLike)LTXIItems.CHORUS_CHEMICAL, 4)).input((ItemLike)Items.ENDER_PEARL, 4));
        this.machineModuleFab(output, registries, "mum/turret", LTXIMachineUpgrades.TURRET_LOOTING, 1, 125000, multi1);
        this.machineModuleFab(output, registries, "mum/turret", LTXIMachineUpgrades.TURRET_LOOTING, 2, 250000, multi2);
        this.machineModuleFab(output, registries, "mum/turret", LTXIMachineUpgrades.TURRET_LOOTING, 3, 500000, multi3);
    }

    private void grindingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)Items.STONE)).output((ItemLike)Items.COBBLESTONE)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.grinding().input(Tags.Items.COBBLESTONES_NORMAL)).output((ItemLike)Items.GRAVEL)).optionalRandomOutput((ItemLike)Items.FLINT, 1, 0.25f)).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input(Tags.Items.GRAVELS)).output((ItemLike)Items.SAND)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.grinding().input(Tags.Items.CROPS_SUGAR_CANE)).output((ItemLike)LTXIItems.RESINOUS_BIOMASS)).output((ItemLike)Items.SUGAR, 2)).save(output, "grind_sugar_cane");
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)Items.BAMBOO)).output((ItemLike)LTXIItems.RESINOUS_BIOMASS)).save(output, "grind_bamboo");
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)LTXIItems.SPARK_FRUIT)).output((ItemLike)LTXIItems.ELECTRIC_CHEMICAL)).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)LTXIItems.VITRIOL_BERRIES)).output((ItemLike)LTXIItems.ACIDIC_BIOMASS)).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.CHARCOAL}), Ingredient.of((TagKey)ItemTags.COALS)}))).output((ItemLike)LTXIItems.CARBON_DUST)).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input(LTXITags.Items.DEEPSLATE_GRINDABLES)).output((ItemLike)LTXIItems.DEEPSLATE_DUST)).save(output, "grind_deepslate");
        Holder dyes = registries.holderOrThrow(LTXIRecipeModes.DYE_EXTRACTION);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.grinding().input(LTXITags.Items.GREEN_GROUP_DYE_SOURCES, 4)).randomOutput((ItemLike)Items.GREEN_DYE, 1, 0.8f)).randomOutput((ItemLike)Items.LIME_DYE, 1, 0.5f)).needsMode((Holder<RecipeMode>)dyes).time(120).save(output, "extract_green_group_dyes");
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)Items.SEA_PICKLE)).output((ItemLike)Items.LIME_DYE, 2)).needsMode((Holder<RecipeMode>)dyes).time(120).save(output);
        this.orePebbleGrinding((ItemLike)LTXIItems.COAL_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_COAL, null, "coal", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.COPPER_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_COPPER, (TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER, "copper", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.IRON_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_IRON, (TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON, "iron", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.LAPIS_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_LAPIS, null, "lapis", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.REDSTONE_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_REDSTONE, null, "redstone", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.GOLD_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_GOLD, (TagKey<Item>)Tags.Items.RAW_MATERIALS_GOLD, "gold", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.DIAMOND_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_DIAMOND, null, "diamond", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.EMERALD_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_EMERALD, null, "emerald", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.QUARTZ_ORE_PEBBLES, (TagKey<Item>)Tags.Items.ORES_QUARTZ, null, "quartz", output);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input(Tags.Items.ORES_NETHERITE_SCRAP)).output((ItemLike)LTXIItems.NETHERITE_ORE_PEBBLES, 2)).save(output, "grind_debris");
        this.orePebbleGrinding((ItemLike)LTXIItems.TITANIUM_ORE_PEBBLES, LTXITags.Items.TITANIUM_ORES, LTXITags.Items.RAW_TITANIUM_MATERIALS, "titanium", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.NIOBIUM_ORE_PEBBLES, LTXITags.Items.NIOBIUM_ORES, LTXITags.Items.RAW_NIOBIUM_MATERIALS, "niobium", output);
        this.orePebbleGrinding((ItemLike)LTXIItems.TIN_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/tin"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/tin"), "tin", output, true);
        this.orePebbleGrinding((ItemLike)LTXIItems.OSMIUM_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/osmium"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/osmium"), "osmium", output, true);
        this.orePebbleGrinding((ItemLike)LTXIItems.NICKEL_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/nickel"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/nickel"), "nickel", output, true);
        this.orePebbleGrinding((ItemLike)LTXIItems.LEAD_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/lead"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/lead"), "lead", output, true);
        this.orePebbleGrinding((ItemLike)LTXIItems.SILVER_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/silver"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/silver"), "silver", output, true);
        this.orePebbleGrinding((ItemLike)LTXIItems.URANIUM_ORE_PEBBLES, (TagKey<Item>)ModResources.COMMON.itemTag("ores/uranium"), (TagKey<Item>)ModResources.COMMON.itemTag("raw_materials/uranium"), "uranium", output, true);
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)LTXIBlocks.RAW_TITANIUM_CLUSTER)).output((ItemLike)LTXIItems.RAW_TITANIUM, 5)).save(output, "grind_titanium_clusters");
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)LTXIBlocks.RAW_NIOBIUM_CLUSTER)).output((ItemLike)LTXIItems.RAW_NIOBIUM, 5)).save(output, "grind_niobium_clusters");
        ((LTXIBuilder)((LTXIBuilder)this.grinding().input((ItemLike)LTXIItems.GLOOM_SHROOM)).output((ItemLike)LTXIItems.NEURO_BLUE_PIGMENT, 2)).time(120).save(output, "shrooms_to_dye");
    }

    private void mfcRecipes(RecipeOutput output) {
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input((ItemLike)LTXIItems.NETHERITE_ORE_PEBBLES, 2)).input((ItemLike)Items.GOLD_INGOT)).output((ItemLike)Items.NETHERITE_INGOT)).save(output, "pebble_netherite");
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input((ItemLike)Items.NETHERITE_SCRAP, 4)).input((ItemLike)Items.GOLD_INGOT, 1)).output((ItemLike)Items.NETHERITE_INGOT)).save(output, "scrap_netherite");
        LTXIBlocks.NEON_LIGHTS.forEach((color, holder) -> ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input(LTXITags.Items.NEON_LIGHT_MATERIALS, 2)).input(this.neonLightDye((NeonLightColor)((Object)color)))).time(80).output((ItemLike)holder, 8)).save(output));
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input((ItemLike)Items.IRON_INGOT)).input((ItemLike)LTXIItems.CARBON_DUST)).input((ItemLike)LTXIItems.DEEPSLATE_DUST, 4)).fluidInput(LTXITags.Fluids.OXYGEN_FLUIDS, 250)).time(400).output((ItemLike)LTXIItems.SLATESTEEL_INGOT)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input((ItemLike)LTXIItems.TITANIUM_INGOT)).input(Tags.Items.GEMS_QUARTZ, 3)).output((ItemLike)LTXIBlocks.TITANIUM_GLASS, 2)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().input((ItemLike)Items.AMETHYST_SHARD)).input((ItemLike)LTXIItems.SCULK_CHEMICAL, 4)).output((ItemLike)Items.ECHO_SHARD)).time(400).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.fusing().randomInput((ItemLike)Items.SCULK_CATALYST, 1, 0.0f)).randomInput((ItemLike)LTXIItems.SCULK_CHEMICAL, 1, 0.5f)).input((ItemLike)Items.DIRT)).output((ItemLike)Items.SCULK)).save(output);
    }

    private void electroCentrifugingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        Holder electrolyze = registries.holderOrThrow(LTXIRecipeModes.ECF_ELECTROLYZE);
        Holder dyes = registries.holderOrThrow(LTXIRecipeModes.DYE_EXTRACTION);
        Holder dissolution = registries.holderOrThrow(LTXIRecipeModes.CHEM_DISSOLUTION);
        ((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().input(Tags.Items.DYES_LIME)).output((ItemLike)LTXIItems.LTX_LIME_PIGMENT)).time(120).needsMode((Holder<RecipeMode>)dyes).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().input((ItemLike)LTXIItems.VITRIOL_BERRIES)).output((ItemLike)LTXIItems.VIRIDIC_GREEN_PIGMENT, 2)).time(120).needsMode((Holder<RecipeMode>)dyes).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().input((ItemLike)LTXIItems.SPARK_FRUIT)).output((ItemLike)LTXIItems.ELECTRIC_CHARTREUSE_PIGMENT, 2)).time(120).needsMode((Holder<RecipeMode>)dyes).save(output);
        ((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().input((ItemLike)LTXIItems.GLOOM_SHROOM)).output((ItemLike)LTXIItems.NEURO_BLUE_PIGMENT, 2)).time(120).needsMode((Holder<RecipeMode>)dyes).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().input((ItemLike)Items.MUD)).output((ItemLike)Items.DIRT)).variableCountOutput((ItemLike)Items.CLAY_BALL, 1, 3)).optionalRandomOutput((ItemLike)Items.MANGROVE_PROPAGULE, 1, 0.05f)).fluidOutput((Fluid)Fluids.WATER, 1000)).time(120).save(output, "split_mud");
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().needsMode((Holder<RecipeMode>)electrolyze).fluidInput((Fluid)Fluids.WATER, 1000)).fluidOutput((Holder)LTXIFluids.HYDROGEN, 1000)).fluidOutput((Holder)LTXIFluids.OXYGEN, 500)).time(300).save(output, "water_electrolyzing");
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().needsMode((Holder<RecipeMode>)dissolution).fluidInput((Holder)LTXIFluids.VIRIDIC_ACID, 250)).input((ItemLike)Items.CHORUS_FRUIT, 2)).output((ItemLike)LTXIItems.CHORUS_CHEMICAL)).time(300).save(output, "chorus_fruit_extraction");
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.electroCentrifuging().needsMode((Holder<RecipeMode>)dissolution).fluidInput((Holder)LTXIFluids.VIRIDIC_ACID, 2000)).input((ItemLike)LTXIItems.GLOOM_SHROOM)).output((ItemLike)LTXIItems.SCULK_CHEMICAL)).randomOutput((ItemLike)LTXIItems.NEURO_CHEMICAL, 1, 0.05f)).time(400).save(output, "gloom_shroom_extraction");
    }

    private void mixingRecipes(RecipeOutput output) {
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.mixing().input((ItemLike)Items.DIRT)).fluidInput((Fluid)Fluids.WATER, 1000)).output((ItemLike)Items.MUD)).time(120).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.mixing().input((ItemLike)LTXIItems.ACIDIC_BIOMASS, 4)).fluidInput((Fluid)Fluids.WATER, 1000)).fluidOutput((Holder)LTXIFluids.VIRIDIC_ACID, 1000)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.mixing().input((ItemLike)LTXIItems.RESINOUS_BIOMASS, 2)).fluidInput((Holder)LTXIFluids.VIRIDIC_ACID, 250)).output((ItemLike)LTXIItems.MONOMER_CHEMICAL)).save(output);
    }

    private void energizingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        Holder dyes = registries.holderOrThrow(LTXIRecipeModes.DYE_EXTRACTION);
        ((LTXIBuilder)((LTXIBuilder)this.energizing().input(Tags.Items.DYES_LIGHT_BLUE)).output((ItemLike)LTXIItems.ENERGY_BLUE_PIGMENT)).needsMode((Holder<RecipeMode>)dyes).time(120).save(output, "energize_light_blue_dyes");
        ((LTXIBuilder)((LTXIBuilder)this.energizing().input(Tags.Items.DYES_BLUE)).output((ItemLike)LTXIItems.ENERGY_BLUE_PIGMENT)).needsMode((Holder<RecipeMode>)dyes).time(120).save(output, "energize_blue_dyes");
    }

    private void chemLabRecipes(RecipeOutput output) {
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.chemLab().input((ItemLike)LTXIItems.MONOMER_CHEMICAL)).fluidInput(LTXITags.Fluids.OXYGEN_FLUIDS, 125)).output((ItemLike)LTXIItems.POLYMER_INGOT)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.chemLab().input((ItemLike)LTXIItems.POLYMER_INGOT)).input((ItemLike)Items.COPPER_INGOT, 2)).fluidInput((Holder)LTXIFluids.VIRIDIC_ACID, 125)).output((ItemLike)LTXIItems.CIRCUIT_BOARD)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.chemLab().input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 2)).fluidInput((Holder)LTXIFluids.VIRIDIC_ACID, 8000)).fluidInput(LTXITags.Fluids.HYDROGEN_FLUIDS, 2000)).output((ItemLike)LTXIItems.VIRIDIC_WEAPON_CHEMICAL)).time(900).save(output);
    }

    private void assemblingRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.assembling().input((ItemLike)LTXIItems.CIRCUIT_BOARD)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 2)).input((ItemLike)Items.REDSTONE, 4)).input((ItemLike)Items.COPPER_INGOT, 2)).output((ItemLike)LTXIItems.T1_CIRCUIT, 2)).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.assembling().input((ItemLike)LTXIItems.CIRCUIT_BOARD)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 4)).input((ItemLike)Items.REDSTONE, 8)).input((ItemLike)Items.GOLD_INGOT, 2)).output((ItemLike)LTXIItems.T2_CIRCUIT, 2)).time(300).save(output);
        ((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)((LTXIBuilder)this.assembling().input((ItemLike)LTXIItems.CIRCUIT_BOARD)).input((ItemLike)LTXIItems.T2_CIRCUIT)).input((ItemLike)LTXIItems.TITANIUM_INGOT, 6)).input((ItemLike)Items.REDSTONE, 12)).input((ItemLike)Items.QUARTZ, 8)).input((ItemLike)LTXIItems.ELECTRIC_CHEMICAL, 4)).output((ItemLike)LTXIItems.T3_CIRCUIT)).time(400).save(output);
    }

    private void gardenSimRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        Holder farming = registries.holderOrThrow(LTXIRecipeModes.GS_FARMING);
        Holder woods = registries.holderOrThrow(LTXIRecipeModes.GS_WOODS);
        Holder orchard = registries.holderOrThrow(LTXIRecipeModes.GS_ORCHARD);
        Holder foliage = registries.holderOrThrow(LTXIRecipeModes.GS_FOLIAGE);
        ((GardenBuilder)this.garden().needsMode(farming)).growSeed((ItemLike)Items.WHEAT_SEEDS, (ItemLike)Items.WHEAT, 1).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.POTATO, 2).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.CARROT, 2).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).growSeed((ItemLike)Items.BEETROOT_SEEDS, (ItemLike)Items.BEETROOT, 2).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.SWEET_BERRIES).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.COCOA_BEANS, 2).water(500).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).growSeed((ItemLike)Items.PUMPKIN_SEEDS, (ItemLike)Items.PUMPKIN, 1).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).growSeed((ItemLike)Items.MELON_SEEDS, (ItemLike)Items.MELON, 1).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.GLOW_BERRIES).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.BAMBOO).water(500).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.SUGAR_CANE).water(500).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.CACTUS).water(125).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.KELP).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.SEA_PICKLE, 2).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.NETHER_WART).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).growSeed((ItemLike)Items.CHORUS_FLOWER, (ItemLike)Items.CHORUS_FRUIT, 2).water(1000).save(output);
        this.garden().reproduce((ItemLike)Items.DANDELION).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.POPPY).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.BLUE_ORCHID).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.ALLIUM).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.AZURE_BLUET).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.RED_TULIP).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.ORANGE_TULIP).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.WHITE_TULIP).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.PINK_TULIP).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.OXEYE_DAISY).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.CORNFLOWER).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.LILY_OF_THE_VALLEY).water(125).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.WITHER_ROSE).water(500).save(output);
        this.garden().growSeed((ItemLike)Items.TORCHFLOWER_SEEDS, (ItemLike)Items.TORCHFLOWER, 1).water(500).save(output);
        this.garden().reproduce((ItemLike)Items.SUNFLOWER).water(250).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.LILAC).water(250).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.PEONY).water(250).time(300).save(output);
        this.garden().reproduce((ItemLike)Items.ROSE_BUSH).water(250).time(300).save(output);
        this.garden().growSeed((ItemLike)Items.PITCHER_POD, (ItemLike)Items.PITCHER_PLANT, 1).water(500).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.RED_MUSHROOM).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.BROWN_MUSHROOM).water(250).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.OAK_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.BIRCH_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.SPRUCE_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.JUNGLE_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.DARK_OAK_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.ACACIA_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.CHERRY_SAPLING).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.MANGROVE_PROPAGULE).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.AZALEA).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.FLOWERING_AZALEA).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.CRIMSON_FUNGUS).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(farming)).reproduce((ItemLike)Items.WARPED_FUNGUS).water(250).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.OAK_SAPLING, (ItemLike)Items.OAK_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.BIRCH_SAPLING, (ItemLike)Items.BIRCH_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.SPRUCE_SAPLING, (ItemLike)Items.SPRUCE_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.JUNGLE_SAPLING, (ItemLike)Items.JUNGLE_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.DARK_OAK_SAPLING, (ItemLike)Items.DARK_OAK_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.ACACIA_SAPLING, (ItemLike)Items.ACACIA_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.CHERRY_SAPLING, (ItemLike)Items.CHERRY_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.MANGROVE_PROPAGULE, (ItemLike)Items.MANGROVE_LOG, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.CRIMSON_FUNGUS, (ItemLike)Items.CRIMSON_STEM, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(woods)).growSeed((ItemLike)Items.WARPED_FUNGUS, (ItemLike)Items.WARPED_STEM, 4).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(orchard)).growSeed(LTXITags.Items.APPLE_SAPLINGS, (ItemLike)Items.APPLE, 3).water(1000).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.OAK_SAPLING, (ItemLike)Items.OAK_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.BIRCH_SAPLING, (ItemLike)Items.BIRCH_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.SPRUCE_SAPLING, (ItemLike)Items.SPRUCE_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.JUNGLE_SAPLING, (ItemLike)Items.JUNGLE_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.DARK_OAK_SAPLING, (ItemLike)Items.DARK_OAK_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.ACACIA_SAPLING, (ItemLike)Items.ACACIA_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.CHERRY_SAPLING, (ItemLike)Items.CHERRY_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.AZALEA, (ItemLike)Items.AZALEA_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.FLOWERING_AZALEA, (ItemLike)Items.FLOWERING_AZALEA_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.MANGROVE_PROPAGULE, (ItemLike)Items.MANGROVE_LEAVES, 8).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.CRIMSON_FUNGUS, (ItemLike)Items.NETHER_WART_BLOCK, 2).water(1500).time(300).save(output);
        ((GardenBuilder)this.garden().needsMode(foliage)).growSeed((ItemLike)Items.WARPED_FUNGUS, (ItemLike)Items.WARPED_WART_BLOCK, 2).water(1500).time(300).save(output);
        this.garden().reproduce((ItemLike)LTXIItems.SPARK_FRUIT).water(500).save(output);
        this.garden().reproduce((ItemLike)LTXIItems.VITRIOL_BERRIES).water(1000).save(output);
        this.garden().reproduce((ItemLike)LTXIItems.GLOOM_SHROOM).water(10000).time(1200).save(output);
    }

    private void orePebblesCooking(ItemLike orePebble, ItemLike resultItem, int resultCount, RecipeOutput output) {
        String name = RecipesGen.getItemName((ItemLike)orePebble);
        ((LimaCookingRecipeBuilder)this.smelting(this.stackOf(resultItem, resultCount)).input(orePebble)).xp(0.5f).save(output, "smelt_" + name);
        ((LimaCookingRecipeBuilder)this.blasting(this.stackOf(resultItem, resultCount)).input(orePebble)).xp(0.5f).save(output, "blast_" + name);
    }

    private LTXIBuilder<GrindingRecipe> grinding() {
        return new LTXIBuilder<GrindingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<GrindingRecipe>>)LTXIRecipeSerializers.GRINDING);
    }

    private void orePebbleGrinding(ItemLike orePebble, TagKey<Item> oreTag, @Nullable TagKey<Item> rawOreTag, String name, RecipeOutput output, boolean optional) {
        LTXIBuilder oreRecipe = (LTXIBuilder)((LTXIBuilder)this.grinding().input(oreTag)).output(orePebble, 3);
        if (optional) {
            oreRecipe.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(oreTag)));
        }
        oreRecipe.save(output, "grind_" + name + "_ores");
        if (rawOreTag != null) {
            LTXIBuilder rawMatRecipe = (LTXIBuilder)((LTXIBuilder)this.grinding().input(rawOreTag)).output(orePebble, 2);
            if (optional) {
                rawMatRecipe.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(rawOreTag)));
            }
            rawMatRecipe.save(output, "grind_raw_" + name + "_materials");
        }
    }

    private void orePebbleGrinding(ItemLike orePebble, TagKey<Item> oreTag, @Nullable TagKey<Item> rawOreTag, String name, RecipeOutput output) {
        this.orePebbleGrinding(orePebble, oreTag, rawOreTag, name, output, false);
    }

    private LTXIBuilder<MaterialFusingRecipe> fusing() {
        return new LTXIBuilder<MaterialFusingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<MaterialFusingRecipe>>)LTXIRecipeSerializers.MATERIAL_FUSING);
    }

    private LTXIBuilder<ElectroCentrifugingRecipe> electroCentrifuging() {
        return new LTXIBuilder<ElectroCentrifugingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<ElectroCentrifugingRecipe>>)LTXIRecipeSerializers.ELECTRO_CENTRIFUGING);
    }

    private LTXIBuilder<MixingRecipe> mixing() {
        return new LTXIBuilder<MixingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<MixingRecipe>>)LTXIRecipeSerializers.MIXING);
    }

    private LTXIBuilder<EnergizingRecipe> energizing() {
        return new LTXIBuilder<EnergizingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<EnergizingRecipe>>)LTXIRecipeSerializers.ENERGIZING);
    }

    private LTXIBuilder<ChemicalReactingRecipe> chemLab() {
        return new LTXIBuilder<ChemicalReactingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<ChemicalReactingRecipe>>)LTXIRecipeSerializers.CHEMICAL_REACTING);
    }

    private LTXIBuilder<AssemblingRecipe> assembling() {
        return new LTXIBuilder<AssemblingRecipe>(this.modResources, (Supplier<LTXIRecipeSerializer<AssemblingRecipe>>)LTXIRecipeSerializers.ASSEMBLING);
    }

    private GardenBuilder garden() {
        return new GardenBuilder(this.modResources);
    }

    private FabricatingBuilder fabricating(int energyRequired) {
        return new FabricatingBuilder(this.modResources, energyRequired);
    }

    private FabricatingBuilder upgradeableItemFabricating(Supplier<? extends UpgradableEquipmentItem> itemSupplier, HolderLookup.Provider registries, int energyRequired) {
        return (FabricatingBuilder)this.fabricating(energyRequired).output(this.defaultUpgradableItem(itemSupplier, registries));
    }

    private <U extends UpgradeBase<?, U>, UE extends UpgradeBaseEntry<U>> Ingredient moduleIngredient(HolderLookup.Provider registries, ResourceKey<U> upgradeKey, int upgradeRank, ItemLike moduleItem, DataComponentType<UE> componentType, ObjectIntFunction<Holder<U>, UE> entryFactory) {
        Holder upgradeHolder = registries.holderOrThrow(upgradeKey);
        return DataComponentIngredient.of((boolean)true, componentType, (Object)((UpgradeBaseEntry)entryFactory.applyWithInt((Object)upgradeHolder, upgradeRank)), (ItemLike[])new ItemLike[]{moduleItem});
    }

    private Ingredient eumIngredient(HolderLookup.Provider registries, ResourceKey<EquipmentUpgrade> upgradeKey, int upgradeRank) {
        return this.moduleIngredient(registries, (ResourceKey)upgradeKey, upgradeRank, (ItemLike)LTXIItems.EQUIPMENT_UPGRADE_MODULE, (DataComponentType)((DataComponentType)LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY.get()), (ObjectIntFunction)EquipmentUpgradeEntry::new);
    }

    private Ingredient mumIngredient(HolderLookup.Provider registries, ResourceKey<MachineUpgrade> upgradeKey, int upgradeRank) {
        return this.moduleIngredient(registries, (ResourceKey)upgradeKey, upgradeRank, (ItemLike)LTXIItems.MACHINE_UPGRADE_MODULE, (DataComponentType)((DataComponentType)LTXIDataComponents.MACHINE_UPGRADE_ENTRY.get()), (ObjectIntFunction)MachineUpgradeEntry::new);
    }

    private <U extends UpgradeBase<?, U>, UE extends UpgradeBaseEntry<U>> ItemStack moduleStack(HolderLookup.Provider registries, ResourceKey<U> upgradeKey, int upgradeRank, ItemLike moduleItem, DataComponentType<UE> componentType, ObjectIntFunction<Holder<U>, UE> entryFactory) {
        Holder upgrade = registries.holderOrThrow(upgradeKey);
        ItemStack stack = new ItemStack(moduleItem);
        stack.set(componentType, (Object)((UpgradeBaseEntry)entryFactory.applyWithInt((Object)upgrade, upgradeRank)));
        return stack;
    }

    private ItemStack eumStack(HolderLookup.Provider registries, ResourceKey<EquipmentUpgrade> upgradeKey, int upgradeRank) {
        return this.moduleStack(registries, (ResourceKey)upgradeKey, upgradeRank, (ItemLike)LTXIItems.EQUIPMENT_UPGRADE_MODULE, (DataComponentType)((DataComponentType)LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY.get()), (ObjectIntFunction)EquipmentUpgradeEntry::new);
    }

    private ItemStack mumStack(HolderLookup.Provider registries, ResourceKey<MachineUpgrade> upgradeKey, int upgradeRank) {
        return this.moduleStack(registries, (ResourceKey)upgradeKey, upgradeRank, (ItemLike)LTXIItems.MACHINE_UPGRADE_MODULE, (DataComponentType)((DataComponentType)LTXIDataComponents.MACHINE_UPGRADE_ENTRY.get()), (ObjectIntFunction)MachineUpgradeEntry::new);
    }

    private <U extends UpgradeBase<?, U>, UE extends UpgradeBaseEntry<U>> void upgradeFabricating(RecipeOutput output, HolderLookup.Provider registries, String group, ResourceKey<U> upgradeKey, int upgradeRank, int energyRequired, DataComponentType<UE> componentType, ObjectIntFunction<Holder<U>, UE> entryFactory, ItemLike moduleItem, boolean addBaseModuleInput, @Nullable String suffix, UnaryOperator<FabricatingBuilder> op) {
        FabricatingBuilder builder = (FabricatingBuilder)((FabricatingBuilder)this.fabricating(energyRequired).group(group)).output(this.moduleStack(registries, upgradeKey, upgradeRank, moduleItem, componentType, entryFactory));
        if (addBaseModuleInput) {
            Ingredient moduleIngredient = upgradeRank == 1 ? Ingredient.of((ItemLike[])new ItemLike[]{LTXIItems.EMPTY_UPGRADE_MODULE}) : this.moduleIngredient(registries, upgradeKey, upgradeRank - 1, moduleItem, componentType, entryFactory);
            builder.input(moduleIngredient);
        }
        String name = upgradeKey.registry().getPath() + "s/" + upgradeKey.location().getPath();
        if (upgradeRank > 1) {
            name = name + "_" + upgradeRank;
        }
        if (suffix != null) {
            name = name + suffix;
        }
        ((FabricatingBuilder)((Object)op.apply(builder))).save(output, name);
    }

    private void equipmentModuleFab(RecipeOutput output, HolderLookup.Provider registries, String group, ResourceKey<EquipmentUpgrade> upgradeKey, int upgradeRank, int energyRequired, boolean addBaseModuleInput, @Nullable String suffix, UnaryOperator<FabricatingBuilder> op) {
        this.upgradeFabricating(output, registries, group, (ResourceKey)upgradeKey, upgradeRank, energyRequired, (DataComponentType)((DataComponentType)LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY.get()), (ObjectIntFunction)EquipmentUpgradeEntry::new, (ItemLike)LTXIItems.EQUIPMENT_UPGRADE_MODULE, addBaseModuleInput, suffix, op);
    }

    private void equipmentModuleFab(RecipeOutput output, HolderLookup.Provider registries, String group, ResourceKey<EquipmentUpgrade> upgradeKey, int upgradeRank, int energyRequired, UnaryOperator<FabricatingBuilder> op) {
        this.equipmentModuleFab(output, registries, group, upgradeKey, upgradeRank, energyRequired, true, null, op);
    }

    private void machineModuleFab(RecipeOutput output, HolderLookup.Provider registries, String group, ResourceKey<MachineUpgrade> upgradeKey, int upgradeRank, int energyRequired, boolean addBaseModuleInput, @Nullable String suffix, UnaryOperator<FabricatingBuilder> op) {
        this.upgradeFabricating(output, registries, group, (ResourceKey)upgradeKey, upgradeRank, energyRequired, (DataComponentType)((DataComponentType)LTXIDataComponents.MACHINE_UPGRADE_ENTRY.get()), (ObjectIntFunction)MachineUpgradeEntry::new, (ItemLike)LTXIItems.MACHINE_UPGRADE_MODULE, addBaseModuleInput, suffix, op);
    }

    private void machineModuleFab(RecipeOutput output, HolderLookup.Provider registries, String group, ResourceKey<MachineUpgrade> upgradeKey, int upgradeRank, int energyRequired, UnaryOperator<FabricatingBuilder> op) {
        this.machineModuleFab(output, registries, group, upgradeKey, upgradeRank, energyRequired, true, null, op);
    }

    private ItemStack defaultUpgradableItem(Supplier<? extends UpgradableEquipmentItem> itemSupplier, HolderLookup.Provider registries) {
        return itemSupplier.get().createStackWithDefaultUpgrades(registries);
    }

    private Ingredient neonLightDye(NeonLightColor color) {
        Either either = switch (color) {
            case NeonLightColor.LTX_LIME -> Either.left(LTXIItems.LTX_LIME_PIGMENT);
            case NeonLightColor.ENERGY_BLUE -> Either.left(LTXIItems.ENERGY_BLUE_PIGMENT);
            case NeonLightColor.ELECTRIC_CHARTREUSE -> Either.left(LTXIItems.ELECTRIC_CHARTREUSE_PIGMENT);
            case NeonLightColor.VIRIDIC_GREEN -> Either.left(LTXIItems.VIRIDIC_GREEN_PIGMENT);
            case NeonLightColor.NEURO_BLUE -> Either.left(LTXIItems.NEURO_BLUE_PIGMENT);
            default -> Either.right((Object)Objects.requireNonNull(color.getDyeColor()).getTag());
        };
        return (Ingredient)either.map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0}), Ingredient::of);
    }

    private static class FabricatingBuilder
    extends LimaCustomRecipeBuilder<FabricatingRecipe, FabricatingBuilder> {
        private final int energyRequired;
        private boolean advancementLocked = false;

        FabricatingBuilder(ModResources resources, int energyRequired) {
            super(resources);
            this.energyRequired = energyRequired;
        }

        public FabricatingBuilder requiresAdvancement() {
            this.advancementLocked = true;
            return this;
        }

        protected FabricatingRecipe buildRecipe() {
            Preconditions.checkState((this.itemResults.size() == 1 ? 1 : 0) != 0, (Object)"Fabricating recipe must have only 1 output");
            ItemResult result = (ItemResult)this.itemResults.getFirst();
            return new FabricatingRecipe(this.itemIngredients, result, this.energyRequired, this.advancementLocked, this.getGroupOrBlank());
        }
    }

    private static class LTXIBuilder<R extends LTXIRecipe>
    extends LimaCustomRecipeBuilder<R, LTXIBuilder<R>> {
        private final LTXIRecipeSerializer<R> serializer;
        private int craftTime;
        @Nullable
        private Holder<RecipeMode> mode;

        LTXIBuilder(ModResources resources, Supplier<? extends LTXIRecipeSerializer<R>> serializerSupplier) {
            super(resources);
            this.serializer = serializerSupplier.get();
            this.craftTime = this.serializer.defaultTime();
        }

        LTXIBuilder<R> time(int craftTime) {
            this.craftTime = craftTime;
            return this;
        }

        LTXIBuilder<R> needsMode(Holder<RecipeMode> mode) {
            this.mode = mode;
            return this;
        }

        LTXIBuilder<R> needsMode(HolderGetter<RecipeMode> holders, ResourceKey<RecipeMode> key) {
            return this.needsMode((Holder<RecipeMode>)holders.getOrThrow(key));
        }

        protected R buildRecipe() {
            return this.serializer.factory().create(this.itemIngredients, this.fluidIngredients, this.itemResults, this.fluidResults, this.craftTime, this.mode);
        }
    }

    private static class GardenBuilder
    extends LTXIBuilder<GardenSimulatingRecipe> {
        GardenBuilder(ModResources modResources) {
            super(modResources, LTXIRecipeSerializers.GARDEN_SIMULATING);
        }

        GardenBuilder needsMode(Holder<RecipeMode> mode) {
            return (GardenBuilder)super.needsMode(mode);
        }

        GardenBuilder needsMode(HolderGetter<RecipeMode> holders, ResourceKey<RecipeMode> key) {
            return (GardenBuilder)super.needsMode(holders, key);
        }

        GardenBuilder water(int amount) {
            this.fluidInput((Fluid)Fluids.WATER, amount);
            return this;
        }

        GardenBuilder reproduce(ItemLike cropItem, int outputCount) {
            ((LTXIBuilder)this.randomInput(cropItem, 1, 0.0f)).output(cropItem, outputCount);
            return this;
        }

        GardenBuilder reproduce(ItemLike cropItem) {
            return this.reproduce(cropItem, 1);
        }

        GardenBuilder growSeed(ItemLike seeds, ItemLike produce, int outputCount) {
            ((LTXIBuilder)this.randomInput(seeds, 1, 0.0f)).output(produce, outputCount);
            return this;
        }

        GardenBuilder growSeed(TagKey<Item> seedTag, ItemLike produce, int outputCount) {
            ((LTXIBuilder)this.randomInput(seedTag, 1, 0.0f)).output(produce, outputCount);
            return this;
        }
    }
}

