/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.data.generation;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import liedge.limacore.lib.ModResources;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.gui.UpgradeIconSprites;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.client.textures.NamespacedDirectoryLister;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SpriteSourceProvider;

class SpriteSourcesGen
extends SpriteSourceProvider {
    SpriteSourcesGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, registries, "ltxi", helper);
    }

    protected void gather() {
        SpriteSource machineModuleIcon = this.itemSheetCopy("machine_upgrade_module");
        this.atlas(UpgradeIconSprites.ATLAS_LOCATION).addSource(this.nsDirSource("upgrade_module")).addSource(machineModuleIcon);
        this.atlas(ModResources.MC.location("gui")).addSource(machineModuleIcon).addSource(this.singleSprite("gui/light_panel", "slot/empty"));
        this.atlas(BLOCKS_ATLAS).addSource(this.singleSprite("misc/solid_lime", "solid_lime")).addSource(this.singleSprite("misc/lime_fluid", "lime_fluid")).addSource(this.singleSprite("misc/flowing_lime_fluid", "flowing_lime_fluid"));
    }

    private SpriteSource nsDirSource(String path) {
        return new NamespacedDirectoryLister("ltxi", path, "");
    }

    private SpriteSource singleSprite(String path, String name) {
        return new SingleFile(LTXIndustries.RESOURCES.location(path), Optional.of(LTXIndustries.RESOURCES.location(name)));
    }

    private SpriteSource itemSheetCopy(String name) {
        return this.singleSprite("item/" + name, name);
    }
}

