/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import java.util.UUID;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.entity.LimaTraceableProjectile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AutoTrackingProjectile
extends LimaTraceableProjectile {
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity targeted;

    protected AutoTrackingProjectile(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Nullable
    public Entity getTargetEntity() {
        Level level;
        if (this.targeted == null && this.targetUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.targeted = serverLevel.getEntity(this.targetUUID);
        }
        if (this.targeted != null && !LTXIEntityUtil.isEntityAlive(this.targeted)) {
            this.targeted = null;
            this.targetUUID = null;
        }
        return this.targeted;
    }

    public void setTargetEntity(@Nullable Entity targeted) {
        if (targeted != null) {
            this.targetUUID = targeted.getUUID();
            this.targeted = targeted;
        }
    }

    @Override
    protected void tickProjectile(Level level, boolean isClientSide) {
        Entity target;
        if (!isClientSide && (target = this.getTargetEntity()) != null) {
            this.aimTowardsEntity(target, this.getDeltaMovement().length(), 0.0, 30.0f);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.targetUUID = LimaNbtUtil.getOptionalUUID((CompoundTag)tag, (String)"target");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        LimaNbtUtil.putOptionalUUID((CompoundTag)tag, (String)"target", (UUID)this.targetUUID);
    }
}

