/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.ColorSizeParticleOptions;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.entity.AutoTrackingProjectile;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRocketEntity
extends AutoTrackingProjectile {
    protected BaseRocketEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected abstract void damageTarget(Level var1, @Nullable LivingEntity var2, Entity var3, Vec3 var4, boolean var5);

    @Override
    public int getLifetime() {
        return 1000;
    }

    @Override
    protected void onProjectileHit(Level level, HitResult hitResult, Vec3 hitLocation) {
        Entity directHit;
        LivingEntity owner = this.getOwner();
        Entity entity = directHit = hitResult.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)hitResult).getEntity() : null;
        if (directHit != null) {
            this.damageTarget(level, owner, directHit, hitLocation, true);
        }
        this.getEntitiesInAOE(level, hitLocation, 3.0, owner, directHit).forEach(aoeHit -> this.damageTarget(level, owner, (Entity)aoeHit, hitLocation, false));
        level.playSound(null, hitLocation.x, hitLocation.y, hitLocation.z, (SoundEvent)LTXISounds.ROCKET_EXPLODE.get(), SoundSource.PLAYERS, 4.0f, 0.9f);
        LimaNetworkUtil.sendParticle((Level)level, (ParticleOptions)new ColorParticleOptions(LTXIParticles.HALF_SONIC_BOOM_EMITTER, LTXIConstants.LIME_GREEN), (double)512.0, (Vec3)hitLocation);
    }

    @Override
    protected void tickProjectile(Level level, boolean isClientSide) {
        super.tickProjectile(level, isClientSide);
        if (isClientSide) {
            double dx = this.getX() + (this.random.nextDouble() - this.random.nextDouble()) * 0.35;
            double dz = this.getZ() + (this.random.nextDouble() - this.random.nextDouble()) * 0.35;
            level.addAlwaysVisibleParticle((ParticleOptions)new ColorSizeParticleOptions(LTXIParticles.COLOR_GLITTER, LTXIConstants.LIME_GREEN, 1.75f), true, dx, this.getY(0.5), dz, 0.0, 0.0, 0.0);
        }
    }
}

