/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.entity.DynamicClipContext;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record CompoundHitResult(Vec3 origin, List<EntityHitResult> entityHits, HitResult impact) {
    public static CompoundHitResult tracePath(Level level, LivingEntity sourceEntity, UpgradesContainerBase<?, ?> upgrades, double range, double deviation, int maxHits, double blockPierceDistance, DynamicClipContext.FluidCollisionPredicate fluidCollision, ToDoubleFunction<Entity> bbExpansionFunction) {
        Vec3 origin = sourceEntity.getEyePosition();
        Vec3 path = LimaCoreMath.createMotionVector((LivingEntity)sourceEntity, (double)range, (double)deviation);
        Vec3 pathEnd = range <= 32.0 ? origin.add(path) : LimaBlockUtil.traceLoadedChunks((LevelAccessor)level, (Vec3)origin, (Vec3)path);
        BlockHitResult blockTrace = level.clip((ClipContext)new DynamicClipContext(origin, pathEnd, (Entity)sourceEntity, fluidCollision, blockPierceDistance));
        Vec3 end = blockTrace.getLocation();
        List<EntityHitResult> entityHits = level.getEntities((Entity)sourceEntity, sourceEntity.getBoundingBox().expandTowards(path).inflate(0.3), hit -> LTXIEntityUtil.checkWeaponTargetValidity((Entity)sourceEntity, hit, upgrades)).stream().sorted(Comparator.comparingDouble(hit -> hit.distanceToSqr(origin))).flatMap(hit -> Stream.ofNullable(LTXIEntityUtil.clipEntityBoundingBox(hit, origin, end, bbExpansionFunction.applyAsDouble((Entity)hit)))).limit(maxHits).toList();
        BlockHitResult impact = entityHits.size() < maxHits ? blockTrace : (HitResult)entityHits.getLast();
        return new CompoundHitResult(origin, entityHits, (HitResult)impact);
    }

    public static CompoundHitResult tracePath(Level level, LivingEntity sourceEntity, UpgradesContainerBase<?, ?> upgrades, double range, double deviation, int maxHits, double blockPierceDistance, DynamicClipContext.FluidCollisionPredicate fluidCollision, double bbExpansion) {
        return CompoundHitResult.tracePath(level, sourceEntity, upgrades, range, deviation, maxHits, blockPierceDistance, fluidCollision, ignored -> bbExpansion);
    }

    public double traceDistance() {
        return this.origin.distanceTo(this.impactLocation());
    }

    public Vec3 impactLocation() {
        return this.impact.getLocation();
    }
}

