/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import java.util.Optional;
import liedge.limacore.util.LimaBlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;

public final class DynamicClipContext
extends ClipContext {
    private final double[] collisionBypass;
    private final FluidCollisionPredicate fluidCollision;

    public DynamicClipContext(Vec3 from, Vec3 to, Entity entity, FluidCollisionPredicate fluidCollision, double[] collisionBypass) {
        super(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        this.fluidCollision = fluidCollision;
        this.collisionBypass = collisionBypass;
    }

    public DynamicClipContext(Vec3 from, Vec3 to, Entity entity, FluidCollisionPredicate fluidCollision, double bypassAmount) {
        this(from, to, entity, fluidCollision, new double[]{bypassAmount});
    }

    public VoxelShape getBlockShape(BlockState blockState, BlockGetter level, BlockPos pos) {
        VoxelShape shape = super.getBlockShape(blockState, level, pos);
        if (shape.isEmpty() || this.collisionBypass[0] <= 0.0) {
            return shape;
        }
        boolean pierced = true;
        for (AABB bb : LimaBlockUtil.blockPosShiftedAABBs((VoxelShape)shape, (BlockPos)pos)) {
            Optional exit;
            Optional entry = bb.contains(this.getFrom()) ? Optional.of(this.getFrom()) : bb.clip(this.getFrom(), this.getTo());
            Optional optional = exit = bb.contains(this.getTo()) ? Optional.of(this.getTo()) : bb.clip(this.getTo(), this.getFrom());
            if (!entry.isPresent() || !exit.isPresent()) continue;
            double remainingBypass = this.collisionBypass[0];
            double clipDistance = ((Vec3)entry.get()).distanceTo((Vec3)exit.get());
            if (clipDistance <= remainingBypass) {
                this.collisionBypass[0] = remainingBypass - clipDistance;
                continue;
            }
            pierced = false;
            break;
        }
        return pierced ? Shapes.empty() : shape;
    }

    public VoxelShape getFluidShape(FluidState state, BlockGetter level, BlockPos pos) {
        return this.fluidCollision.test(state, level, pos) ? state.getShape(level, pos) : Shapes.empty();
    }

    @FunctionalInterface
    public static interface FluidCollisionPredicate {
        public static final FluidCollisionPredicate NONE = (state, level, pos) -> false;
        public static final FluidCollisionPredicate ANY = (state, level, pos) -> true;
        public static final FluidCollisionPredicate SOURCE_ONLY = (state, level, pos) -> state.isSource();

        public static FluidCollisionPredicate any(FluidType type) {
            return (state, level, pos) -> state.getFluidType().equals(type);
        }

        public static FluidCollisionPredicate any(TagKey<Fluid> tag) {
            return (state, level, pos) -> state.is(tag);
        }

        public static FluidCollisionPredicate sourceOnly(FluidType type) {
            return (state, level, pos) -> state.isSource() && state.getFluidType().equals(type);
        }

        public static FluidCollisionPredicate sourceOnly(TagKey<Fluid> tagKey) {
            return (state, level, pos) -> state.isSource() && state.is(tagKey);
        }

        public boolean test(FluidState var1, BlockGetter var2, BlockPos var3);
    }
}

