/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import liedge.limacore.client.particle.ColorSizeParticleOptions;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.block.SurfaceStickingBlock;
import liedge.ltxindustries.entity.LimaTraceableProjectile;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GlowstickProjectileEntity
extends LimaTraceableProjectile {
    public GlowstickProjectileEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public GlowstickProjectileEntity(Level level) {
        this((EntityType)LTXIEntities.GLOWSTICK_PROJECTILE.get(), level);
    }

    @Override
    public int getLifetime() {
        return 100;
    }

    @Override
    protected HitResult tracePath(Level level) {
        Vec3 origin = this.position();
        Vec3 path = this.getDeltaMovement();
        return level.clip(new ClipContext(origin, origin.add(path), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    @Override
    protected void onProjectileHit(Level level, HitResult hitResult, Vec3 hitLocation) {
        if (hitResult instanceof BlockHitResult) {
            BlockState state;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Direction placeDirection = blockHitResult.getDirection();
            BlockPos placePos = blockHitResult.getBlockPos().relative(placeDirection);
            if (level.getBlockState(placePos).canBeReplaced() && (state = (BlockState)((BlockState)((SurfaceStickingBlock)((Object)LTXIBlocks.GLOWSTICK.get())).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)placeDirection)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(placePos).is((Fluid)Fluids.WATER)))).canSurvive((LevelReader)level, placePos)) {
                level.setBlockAndUpdate(placePos, state);
            }
        }
        this.discard();
    }

    @Override
    protected void tickProjectile(Level level, boolean isClientSide) {
        if (isClientSide && this.tickCount % 2 == 0) {
            double dx = this.getX() + (this.random.nextDouble() - this.random.nextDouble()) * 0.125;
            double dz = this.getZ() + (this.random.nextDouble() - this.random.nextDouble()) * 0.125;
            level.addAlwaysVisibleParticle((ParticleOptions)new ColorSizeParticleOptions(LTXIParticles.COLOR_GLITTER, LTXIConstants.LIME_GREEN, 0.75f), true, dx, this.getY(0.5), dz, 0.0, 0.0, 0.0);
        }
    }
}

