/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import liedge.limacore.advancement.ItemBrokenTrigger;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaEntityUtil;
import liedge.limacore.util.LimaLootUtil;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.entity.LimaTraceableEntity;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import liedge.ltxindustries.registry.game.LTXICriterionTriggers;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import liedge.ltxindustries.util.config.LTXIServerConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public final class LTXIEntityUtil {
    private static final int MAX_ENTITY_CHECK_RECURSION = 5;

    private LTXIEntityUtil() {
    }

    public static boolean isEntityAlive(Entity entity) {
        if (entity instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)entity;
            return dragon.getHealth() > 1.0f;
        }
        return entity.isAlive();
    }

    public static boolean checkPlayerPVPRule(@Nullable Entity attackingEntity, Player target) {
        if (attackingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)attackingEntity;
            return serverPlayer.canHarmPlayer(target) && LTXIServerConfig.ENABLE_MOD_PVP.getAsBoolean();
        }
        return true;
    }

    public static boolean checkTurretTargetValidity(@Nullable Entity attackingEntity, Entity target, UpgradesContainerBase<?, ?> upgrades, Predicate<Entity> defaultTurretTargets) {
        if (!LTXIEntityUtil.checkBaseTargetValidity(attackingEntity, target)) {
            return false;
        }
        TriState result = LTXIEntityUtil.checkUpgradeTargetValidity(attackingEntity, target, upgrades);
        return result.isDefault() ? defaultTurretTargets.test(target) : result.isTrue();
    }

    public static boolean checkWeaponTargetValidity(@Nullable Entity attackingEntity, Entity target, UpgradesContainerBase<?, ?> upgrades) {
        return LTXIEntityUtil.checkBaseTargetValidity(attackingEntity, target) && !LTXIEntityUtil.checkUpgradeTargetValidity(attackingEntity, target, upgrades).isFalse();
    }

    public static TriState checkUpgradeTargetValidity(@Nullable Entity attackingEntity, Entity target, UpgradesContainerBase<?, ?> upgrades) {
        ServerLevel level = (ServerLevel)LimaCoreUtil.castOrThrow(ServerLevel.class, (Object)target.level(), (String)"Upgrades target check called on client.");
        LootContext context = LimaLootUtil.chestLootContext((ServerLevel)level, (Entity)target, (Entity)attackingEntity);
        List conditions = upgrades.effectFlatStream(LTXIUpgradeEffectComponents.TARGET_CONDITIONS).toList();
        if (conditions.isEmpty()) {
            return TriState.DEFAULT;
        }
        boolean result = conditions.stream().allMatch(o -> o.test((Object)context));
        return result ? TriState.TRUE : TriState.FALSE;
    }

    public static boolean checkBaseTargetValidity(@Nullable Entity attackingEntity, Entity target) {
        return LTXIEntityUtil.checkBaseTargetValidity(attackingEntity, target, 0);
    }

    private static boolean checkBaseTargetValidity(@Nullable Entity attackingEntity, Entity target, int recursionDepth) {
        boolean bl;
        if (recursionDepth > 5) {
            return false;
        }
        if (!LTXIEntityUtil.isEntityAlive(target) || target == attackingEntity || target.getType().is(LTXITags.EntityTypes.INVALID_TARGETS)) {
            return false;
        }
        boolean validAttacker = attackingEntity != null;
        Entity entity = target;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TraceableEntity.class, OwnableEntity.class, PartEntity.class, Player.class}, (Object)entity2, n)) {
                case 0: {
                    TraceableEntity traceable = (TraceableEntity)entity2;
                    if (!validAttacker || traceable.getOwner() != attackingEntity) {
                        n = 1;
                        continue block6;
                    }
                    bl = false;
                    break block6;
                }
                case 1: {
                    OwnableEntity ownable = (OwnableEntity)entity2;
                    if (!validAttacker || ownable.getOwner() != attackingEntity) {
                        n = 2;
                        continue block6;
                    }
                    bl = false;
                    break block6;
                }
                case 2: {
                    PartEntity part = (PartEntity)entity2;
                    if (LTXIEntityUtil.checkBaseTargetValidity(attackingEntity, part.getParent(), recursionDepth + 1)) {
                        n = 3;
                        continue block6;
                    }
                    bl = false;
                    break block6;
                }
                case 3: {
                    Player player = (Player)entity2;
                    if (LTXIEntityUtil.checkPlayerPVPRule(attackingEntity, player)) {
                        n = 4;
                        continue block6;
                    }
                    bl = false;
                    break block6;
                }
                default: {
                    if (validAttacker && !attackingEntity.isPassengerOfSameVehicle(target)) {
                        bl = true;
                        break block6;
                    }
                    bl = false;
                    break block6;
                }
            }
            break;
        }
        return bl;
    }

    public static IntList flattenEntityIds(Collection<Entity> entities) {
        IntArrayList list = new IntArrayList(entities.size());
        for (Entity e : entities) {
            int depth;
            for (depth = 0; e instanceof PartEntity && depth <= 5; ++depth) {
                e = ((PartEntity)e).getParent();
            }
            if (depth > 5) continue;
            list.add(LimaEntityUtil.getEntityId((Entity)e));
        }
        return list;
    }

    @Nullable
    public static EntityHitResult clipEntityBoundingBox(Entity target, Vec3 start, Vec3 end, double bbExpansion) {
        AABB bb = target.getBoundingBox().inflate(Math.max((double)target.getPickRadius(), bbExpansion));
        if (bb.contains(start)) {
            return new EntityHitResult(target, start);
        }
        return bb.clip(start, end).map(vec -> new EntityHitResult(target, vec)).orElse(null);
    }

    public static HitResult traceProjectileEntityPath(Level level, LimaTraceableEntity projectile, ClipContext.Block blockCollision, ClipContext.Fluid fluidCollision, double bbExpansion) {
        Vec3 origin = projectile.position();
        Vec3 path = projectile.getDeltaMovement();
        BlockHitResult blockTrace = level.clip(new ClipContext(origin, origin.add(path), blockCollision, fluidCollision, (Entity)projectile));
        Vec3 impact = blockTrace.getLocation();
        EntityHitResult entityTrace = level.getEntities((Entity)projectile, projectile.getBoundingBox().expandTowards(path).inflate(0.3), hit -> LTXIEntityUtil.checkWeaponTargetValidity((Entity)projectile.getOwner(), hit, projectile.getUpgrades())).stream().sorted(Comparator.comparingDouble(hit -> hit.distanceToSqr(origin))).flatMap(hit -> Stream.ofNullable(LTXIEntityUtil.clipEntityBoundingBox(hit, origin, impact, bbExpansion))).findFirst().orElse(null);
        return entityTrace != null ? entityTrace : blockTrace;
    }

    public static void hurtWithEnchantedFakePlayer(ServerLevel level, Entity target, @Nullable LivingEntity owner, UpgradesContainerBase<?, ?> upgrades, Function<@Nullable LivingEntity, ? extends DamageSource> damageSourceFunction, float damage) {
        if (owner instanceof Player) {
            ItemEnchantments enchantments = upgrades.getEnchantments();
            owner = FakePlayerFactory.get((ServerLevel)level, (GameProfile)((Player)owner).getGameProfile());
            if (enchantments.isEmpty()) {
                owner.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                target.hurt(damageSourceFunction.apply(owner), damage);
            } else {
                ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
                stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
                owner.setItemInHand(InteractionHand.MAIN_HAND, stack);
                target.hurt(damageSourceFunction.apply(owner), damage);
                owner.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
        } else {
            target.hurt(damageSourceFunction.apply(owner), damage);
        }
    }

    public static void damageArmorWithAcid(ServerLevel serverLevel, @Nullable ServerPlayer attackingPlayer, LivingEntity entity, int minDamage, float damagePercent) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!EquipmentSlotGroup.ARMOR.test(slot) || !(stack = entity.getItemBySlot(slot)).isDamageableItem()) continue;
            int durabilityDamage = Math.max(minDamage, Mth.floor((float)((float)stack.getMaxDamage() * damagePercent)));
            stack.hurtAndBreak(durabilityDamage, serverLevel, entity, item -> {
                entity.onEquippedItemBroken(item, slot);
                if (attackingPlayer != null) {
                    ((ItemBrokenTrigger)LTXICriterionTriggers.ITEM_BROKEN_BY_ACID.get()).trigger(attackingPlayer, stack, slot);
                }
            });
        }
    }
}

