/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import liedge.limacore.util.LimaBlockUtil;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public abstract class LimaTraceableEntity
extends Entity
implements TraceableEntity {
    private static final String LAUNCHER_ITEM_KEY = "launcher";
    private final ObjectSet<FluidType> touchingFluidTypes = new ObjectOpenHashSet();
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity owner;
    private ItemStack launcherItem = ItemStack.EMPTY;

    protected LimaTraceableEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected ItemStack getLauncherItem() {
        return this.launcherItem;
    }

    public void setLauncherItem(ItemStack launcherItem) {
        this.launcherItem = launcherItem;
    }

    public UpgradesContainerBase<?, ?> getUpgrades() {
        return UpgradableEquipmentItem.getEquipmentUpgradesFromStack(this.getLauncherItem());
    }

    @Nullable
    public LivingEntity getOwner() {
        Level level;
        if (this.owner != null && !this.owner.isRemoved()) {
            return this.owner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.ownerUUID);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            }
            return this.owner;
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.owner = owner;
        }
    }

    protected List<Entity> getEntitiesInAOE(Level level, AABB aabb, @Nullable LivingEntity owner, @Nullable Entity directHit) {
        return level.getEntities((Entity)this, aabb, e -> LTXIEntityUtil.checkWeaponTargetValidity((Entity)owner, e, this.getUpgrades()) && !Objects.equals(directHit, e));
    }

    protected List<Entity> getEntitiesInAOE(Level level, Vec3 hitLocation, double radius, @Nullable LivingEntity owner, @Nullable Entity directHit) {
        return this.getEntitiesInAOE(level, AABB.ofSize((Vec3)hitLocation, (double)(radius *= 2.0), (double)radius, (double)radius), owner, directHit);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getInt("age");
        this.ownerUUID = LimaNbtUtil.getOptionalUUID((CompoundTag)tag, (String)"owner");
        this.launcherItem = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound(LAUNCHER_ITEM_KEY));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("age", this.tickCount);
        LimaNbtUtil.putOptionalUUID((CompoundTag)tag, (String)"owner", (UUID)this.ownerUUID);
        if (!this.launcherItem.isEmpty()) {
            tag.put(LAUNCHER_ITEM_KEY, this.launcherItem.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected RegistryOps<Tag> createRegistryOps() {
        return RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.registryAccess());
    }

    protected MachineUpgrades readMachineUpgrades(CompoundTag tag) {
        return (MachineUpgrades)LimaNbtUtil.tryDecode(MachineUpgrades.CODEC, this.createRegistryOps(), (CompoundTag)tag, (String)"upgrades", (Object)MachineUpgrades.EMPTY);
    }

    protected void writeMachineUpgrades(MachineUpgrades upgrades, CompoundTag tag) {
        LimaNbtUtil.tryEncodeTo(MachineUpgrades.CODEC, this.createRegistryOps(), (Object)upgrades, (CompoundTag)tag, (String)"upgrades");
    }

    public boolean isInWater() {
        return this.touchingFluidTypes.contains(NeoForgeMod.WATER_TYPE.value()) || super.isInWater();
    }

    protected void updateFluidHeightOnly(Level level) {
        this.forgeFluidTypeHeight.clear();
        AABB bb = this.getBoundingBox().inflate(0.001);
        LimaBlockUtil.betweenClosedStreamSafeCeil((Level)level, (AABB)bb).forEach(pos -> {
            FluidState fluidState = level.getFluidState(pos);
            FluidType fluidType = fluidState.getFluidType();
            if (!fluidType.isAir()) {
                float stateHeight = (float)pos.getY() + fluidState.getHeight((BlockGetter)level, pos);
                float actualFluidHeight = Math.max(0.0f, stateHeight - (float)bb.minY);
                this.setFluidTypeHeight(fluidType, actualFluidHeight);
            }
        });
        ObjectOpenHashSet previouslyTouchedFluids = new ObjectOpenHashSet(this.touchingFluidTypes);
        this.touchingFluidTypes.clear();
        this.forgeFluidTypeHeight.object2DoubleEntrySet().stream().filter(entry -> entry.getDoubleValue() > 0.0).map(Map.Entry::getKey).forEach(arg_0 -> this.lambda$updateFluidHeightOnly$3((ObjectSet)previouslyTouchedFluids, arg_0));
        previouslyTouchedFluids.forEach(fluidType -> {
            if (this.getFluidTypeHeight((FluidType)fluidType) == 0.0) {
                this.onExitFluidType((FluidType)fluidType);
            }
        });
    }

    protected void onEnteredFluidType(FluidType fluidType) {
        if (fluidType == NeoForgeMod.WATER_TYPE.value() && !this.firstTick) {
            this.doWaterSplashEffect();
        }
    }

    protected void onExitFluidType(FluidType fluidType) {
    }

    private /* synthetic */ void lambda$updateFluidHeightOnly$3(ObjectSet previouslyTouchedFluids, FluidType fluidType) {
        if (!previouslyTouchedFluids.remove((Object)fluidType)) {
            this.onEnteredFluidType(fluidType);
        }
        this.touchingFluidTypes.add((Object)fluidType);
    }
}

