/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.entity.LimaTraceableEntity;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;

public abstract class LimaTraceableProjectile
extends LimaTraceableEntity {
    protected LimaTraceableProjectile(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void aimAndSetPosFromShooter(LivingEntity shooter, double speed, double inaccuracy) {
        this.setPos(shooter.getEyePosition());
        Vec3 motion = LimaCoreMath.createMotionVector((LivingEntity)shooter, (double)speed, (double)inaccuracy);
        this.setRot(LimaCoreMath.getYRot((Vec3)motion), LimaCoreMath.getXRot((Vec3)motion));
        this.setDeltaMovement(motion);
    }

    public void aimTowardsPoint(Vec3 target, double speed, double inaccuracy) {
        Vector2f angles = LimaCoreMath.xyRotBetweenPoints((Vec3)this.position(), (Vec3)target);
        this.setRot(angles.y, angles.x);
        this.setDeltaMovement(LimaCoreMath.createMotionVector((float)angles.x, (float)angles.y, (double)speed, (double)inaccuracy));
    }

    public void aimTowardsPoint(Vec3 target, double speed, double inaccuracy, float maxTurnAngle) {
        Vector2f angles = LimaCoreMath.xyRotBetweenPoints((Vec3)this.position(), (Vec3)target);
        float yr = Mth.approachDegrees((float)this.getYRot(), (float)angles.y, (float)maxTurnAngle);
        float xr = Mth.approachDegrees((float)this.getXRot(), (float)angles.x, (float)maxTurnAngle);
        this.setRot(yr, xr);
        this.setDeltaMovement(LimaCoreMath.createMotionVector((float)xr, (float)yr, (double)speed, (double)inaccuracy));
    }

    public void aimTowardsEntity(Entity target, double speed, double inaccuracy) {
        this.aimTowardsPoint(target.getBoundingBox().getCenter(), speed, inaccuracy);
    }

    public void aimTowardsEntity(Entity target, double speed, double inaccuracy, float maxTurnAngle) {
        this.aimTowardsPoint(target.getBoundingBox().getCenter(), speed, inaccuracy, maxTurnAngle);
    }

    public abstract int getLifetime();

    protected float getProjectileGravity() {
        return 0.0f;
    }

    protected HitResult tracePath(Level level) {
        return LTXIEntityUtil.traceProjectileEntityPath(level, this, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getBoundingBox().getSize());
    }

    protected abstract void onProjectileHit(Level var1, HitResult var2, Vec3 var3);

    protected abstract void tickProjectile(Level var1, boolean var2);

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof LimaTraceableProjectile || source.getEntity() == this.getOwner()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public final void baseTick() {
        Level level = this.level();
        level.getProfiler().push("entityBaseTick");
        if (this.tickCount >= this.getLifetime()) {
            this.discard();
            return;
        }
        this.updateFluidHeightOnly(level);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.xo = x;
        this.yo = y;
        this.zo = z;
        Vec3 delta = this.getDeltaMovement();
        float gravity = this.getProjectileGravity();
        if (!this.isNoGravity() && gravity > 0.0f) {
            this.setDeltaMovement(delta.x, delta.y - (double)gravity, delta.z);
        }
        this.setPos(x + delta.x, y + delta.y, z + delta.z);
        this.checkInsideBlocks();
        this.handlePortal();
        this.checkBelowWorld();
        this.firstTick = false;
        this.level().getProfiler().pop();
    }

    public final void tick() {
        HitResult hitResult;
        Level level = this.level();
        boolean isClientSide = level.isClientSide();
        if (!isClientSide && (hitResult = this.tracePath(level)).getType() != HitResult.Type.MISS) {
            Vec3 hitLocation = hitResult.getLocation();
            this.setPos(hitLocation);
            this.onProjectileHit(level, hitResult, hitLocation);
            boolean postGameEvent = this.getUpgrades().noneMatch((DataComponentType)LTXIUpgradeEffectComponents.PREVENT_VIBRATION.get(), (effect, rank) -> effect.apply(null, (Holder<GameEvent>)LTXIGameEvents.PROJECTILE_IMPACT));
            if (postGameEvent) {
                level.gameEvent((Entity)this.getOwner(), LTXIGameEvents.PROJECTILE_IMPACT, hitLocation);
            }
            this.discard();
            return;
        }
        this.tickProjectile(level, isClientSide);
        this.baseTick();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance <= 16384.0;
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            this.setYRot(LimaCoreMath.toDeg((double)Mth.atan2((double)z, (double)x)) - 90.0f);
            this.setXRot(LimaCoreMath.toDeg((double)(-Mth.atan2((double)y, (double)LimaCoreMath.vec2Length((double)x, (double)z)))));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

