/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import java.util.List;
import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.ColorSizeParticleOptions;
import liedge.limacore.util.LimaBlockUtil;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.client.particle.GrenadeExplosionParticleOptions;
import liedge.ltxindustries.entity.LimaTraceableProjectile;
import liedge.ltxindustries.entity.StickyFlameEntity;
import liedge.ltxindustries.item.weapon.GrenadeLauncherItem;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIMobEffects;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.config.LTXIWeaponsConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class OrbGrenadeEntity
extends LimaTraceableProjectile
implements IEntityWithComplexSpawn {
    private GrenadeType grenadeType = GrenadeType.EXPLOSIVE;
    private float spin0;
    private float spin;

    public OrbGrenadeEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public OrbGrenadeEntity(Level level, GrenadeType grenadeType, ItemStack launcherItem) {
        this((EntityType)LTXIEntities.ORB_GRENADE.get(), level);
        this.grenadeType = grenadeType;
        this.setLauncherItem(launcherItem.copy());
    }

    public GrenadeType getGrenadeType() {
        return this.grenadeType;
    }

    private void setGrenadeType(GrenadeType grenadeType) {
        this.grenadeType = grenadeType;
    }

    public float lerpSpinAnimation(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.spin0, (float)this.spin);
    }

    private double getBlastRadius() {
        return switch (this.getGrenadeType()) {
            default -> throw new MatchException(null, null);
            case GrenadeType.EXPLOSIVE -> 5.0;
            case GrenadeType.FLAME -> 4.5;
            case GrenadeType.CRYO -> 6.0;
            case GrenadeType.ELECTRIC -> {
                if (this.checkGrenadeInRainOrWater()) {
                    yield 10.0;
                }
                yield 5.0;
            }
            case GrenadeType.ACID, GrenadeType.NEURO -> 2.5;
        };
    }

    private ResourceKey<DamageType> getDamageType() {
        return switch (this.getGrenadeType()) {
            default -> throw new MatchException(null, null);
            case GrenadeType.EXPLOSIVE -> LTXIDamageTypes.EXPLOSIVE_GRENADE;
            case GrenadeType.FLAME -> LTXIDamageTypes.FLAME_GRENADE;
            case GrenadeType.CRYO -> LTXIDamageTypes.CRYO_GRENADE;
            case GrenadeType.ELECTRIC -> LTXIDamageTypes.ELECTRIC_GRENADE;
            case GrenadeType.ACID -> LTXIDamageTypes.ACID_GRENADE;
            case GrenadeType.NEURO -> LTXIDamageTypes.NEURO_GRENADE;
        };
    }

    private boolean checkGrenadeInRainOrWater() {
        Level level = this.level();
        return LimaBlockUtil.betweenClosedStreamSafe((Level)level, (AABB)this.getBoundingBox().inflate(0.001)).anyMatch(pos -> level.isRainingAt(pos) || level.getFluidState(pos).is(Tags.Fluids.WATER));
    }

    private double getDamageMultiplier(Entity hitEntity) {
        EntityType type = hitEntity.getType();
        return switch (this.grenadeType) {
            case GrenadeType.FLAME -> {
                if (type.is(LTXITags.EntityTypes.WEAK_TO_FLAME)) {
                    yield LTXIWeaponsConfig.FLAME_GRENADE_DAMAGE_MULTIPLIER.getAsDouble();
                }
                yield 1.0;
            }
            case GrenadeType.CRYO -> {
                if (type.is(LTXITags.EntityTypes.WEAK_TO_CRYO)) {
                    yield LTXIWeaponsConfig.CRYO_GRENADE_DAMAGE_MULTIPLIER.getAsDouble();
                }
                yield 1.0;
            }
            case GrenadeType.ELECTRIC -> {
                if (hitEntity.isInWaterOrRain() || type.is(LTXITags.EntityTypes.WEAK_TO_ELECTRIC)) {
                    yield LTXIWeaponsConfig.ELECTRIC_GRENADE_DAMAGE_MULTIPLIER.getAsDouble();
                }
                yield 1.0;
            }
            default -> 1.0;
        };
    }

    private double getBaseDamage() {
        ModConfigSpec.DoubleValue configValue = switch (this.grenadeType) {
            default -> throw new MatchException(null, null);
            case GrenadeType.EXPLOSIVE -> LTXIWeaponsConfig.EXPLOSIVE_GRENADE_BASE_DAMAGE;
            case GrenadeType.FLAME -> LTXIWeaponsConfig.FLAME_GRENADE_BASE_DAMAGE;
            case GrenadeType.CRYO -> LTXIWeaponsConfig.CRYO_GRENADE_BASE_DAMAGE;
            case GrenadeType.ELECTRIC -> LTXIWeaponsConfig.ELECTRIC_GRENADE_BASE_DAMAGE;
            case GrenadeType.ACID -> LTXIWeaponsConfig.ACID_GRENADE_BASE_DAMAGE;
            case GrenadeType.NEURO -> LTXIWeaponsConfig.NEURO_GRENADE_BASE_DAMAGE;
        };
        return configValue.getAsDouble();
    }

    private void applyPotionEffects(LivingEntity hitEntity) {
        MobEffectInstance instance;
        switch (this.grenadeType) {
            case CRYO: {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(LTXIMobEffects.FROSTBITE, 400, 2);
                break;
            }
            case ACID: {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(LTXIMobEffects.CORROSIVE, 200, 2);
                break;
            }
            case NEURO: {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(LTXIMobEffects.NEURO_SUPPRESSED, 600, 2);
                break;
            }
            default: {
                MobEffectInstance mobEffectInstance = instance = null;
            }
        }
        if (instance != null) {
            hitEntity.forceAddEffect(instance, (Entity)this.getOwner());
        }
    }

    private void spawnHitEntityParticles(Level level, Vec3 hitLocation, Entity hitEntity) {
        if (this.grenadeType == GrenadeType.ELECTRIC) {
            LimaNetworkUtil.sendParticle((Level)level, (ParticleOptions)new ColorParticleOptions(LTXIParticles.FIXED_ELECTRIC_BOLT, this.grenadeType.getColor()), (double)32.0, (Vec3)hitLocation, (Vec3)hitEntity.getEyePosition());
        }
    }

    @Override
    public int getLifetime() {
        return 200;
    }

    @Override
    protected float getProjectileGravity() {
        if (this.grenadeType == GrenadeType.ELECTRIC && this.isInWater()) {
            return 0.0f;
        }
        return 0.0325f;
    }

    @Override
    protected void onProjectileHit(Level level, HitResult hitResult, Vec3 hitLocation) {
        LivingEntity owner = this.getOwner();
        double blastRadius = this.getBlastRadius();
        List<Entity> hits = this.getEntitiesInAOE(level, hitLocation, blastRadius, owner, null);
        if (this.grenadeType == GrenadeType.FLAME) {
            for (int i = 0; i < 9; ++i) {
                int offsetX = i % 3 - 1;
                int offsetZ = i / 3 - 1;
                StickyFlameEntity flames = new StickyFlameEntity(level, this.getLauncherItem());
                flames.setOwner(owner);
                flames.setPos(hitLocation.x + (double)(2.0f * (float)offsetX), hitLocation.y, hitLocation.z + (double)(2.0f * (float)offsetZ));
                level.addFreshEntity((Entity)flames);
            }
        }
        hits.forEach(hitEntity -> {
            if (hitEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)hitEntity;
                this.applyPotionEffects(living);
            }
            double baseDamage = this.getBaseDamage() * this.getDamageMultiplier((Entity)hitEntity);
            ((GrenadeLauncherItem)LTXIItems.GRENADE_LAUNCHER.get()).causeProjectileDamage(this.getLauncherItem(), this, owner, this.getDamageType(), (Entity)hitEntity, baseDamage);
            this.spawnHitEntityParticles(level, hitLocation, (Entity)hitEntity);
        });
        level.playSound(null, hitLocation.x, hitLocation.y, hitLocation.z, (SoundEvent)LTXISounds.GRENADE_EXPLOSIONS.get(this.grenadeType).get(), SoundSource.PLAYERS, 2.5f, Mth.randomBetween((RandomSource)this.random, (float)0.77f, (float)0.9f));
        LimaNetworkUtil.sendParticle((Level)level, (ParticleOptions)new GrenadeExplosionParticleOptions(this.grenadeType, blastRadius * 2.0), (double)512.0, (Vec3)hitLocation);
    }

    @Override
    protected void tickProjectile(Level level, boolean isClientSide) {
        if (isClientSide) {
            float speed = (float)this.getDeltaMovement().length();
            this.spin0 = this.spin;
            this.spin = (this.spin - 60.0f * speed) % 360.0f;
            if (this.tickCount % 2 == 0) {
                double dx = this.getX() + (this.random.nextDouble() - this.random.nextDouble()) * 0.2;
                double dz = this.getZ() + (this.random.nextDouble() - this.random.nextDouble()) * 0.2;
                level.addAlwaysVisibleParticle((ParticleOptions)new ColorSizeParticleOptions(LTXIParticles.COLOR_GLITTER, this.grenadeType.getColor(), 1.125f), true, dx, this.getY(0.5), dz, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setGrenadeType((GrenadeType)GrenadeType.CODEC.byNameOrElse(tag.getString("grenade_type"), (Enum)GrenadeType.EXPLOSIVE));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("grenade_type", this.grenadeType.getSerializedName());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        GrenadeType.STREAM_CODEC.encode((Object)buffer, (Object)this.grenadeType);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setGrenadeType((GrenadeType)GrenadeType.STREAM_CODEC.decode((Object)additionalData));
    }
}

