/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.entity.LimaTraceableEntity;
import liedge.ltxindustries.item.weapon.GrenadeLauncherItem;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StickyFlameEntity
extends LimaTraceableEntity {
    private boolean stuckOnBlock;

    public StickyFlameEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public StickyFlameEntity(Level level, ItemStack launcherItem) {
        this((EntityType)LTXIEntities.STICKY_FLAME.get(), level);
        this.setLauncherItem(launcherItem);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        Level level = this.level();
        if (this.tickCount > 80) {
            this.discard();
        }
        this.updateFluidHeightOnly(level);
        if (this.isInWaterOrRain()) {
            this.discard();
            level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL);
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        this.xo = x;
        this.yo = y;
        this.zo = z;
        if (this.stuckOnBlock && level.noBlockCollision((Entity)this, this.getBoundingBox().inflate(0.001))) {
            this.stuckOnBlock = false;
        } else {
            Vec3 delta = this.getDeltaMovement();
            this.setDeltaMovement(delta.x, delta.y - 0.05, delta.z);
            Vec3 start = this.position();
            Vec3 end = start.add(delta);
            BlockHitResult hitResult = level.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, (Entity)this));
            if (hitResult.getType() != HitResult.Type.MISS) {
                this.setPos(hitResult.getLocation());
                this.setDeltaMovement(Vec3.ZERO);
                this.stuckOnBlock = true;
            } else {
                this.setPos(end);
            }
        }
        if (!level.isClientSide) {
            if (this.tickCount % 4 == 0) {
                LivingEntity owner = this.getOwner();
                this.getEntitiesInAOE(level, this.getBoundingBox(), owner, null).forEach(hit -> {
                    if (((GrenadeLauncherItem)LTXIItems.GRENADE_LAUNCHER.get()).causeProjectileDamage(this.getLauncherItem(), this, owner, LTXIDamageTypes.STICKY_FLAME, (Entity)hit, 4.0)) {
                        hit.setRemainingFireTicks(400);
                    }
                });
            }
        } else if (LimaCoreMath.rollRandomChance((double)0.05)) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.2, 0.0);
        }
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.stuckOnBlock = tag.getBoolean("stuck");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("stuck", this.stuckOnBlock);
    }
}

