/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.util.LimaBlockUtil;
import liedge.limacore.util.LimaNbtUtil;
import liedge.ltxindustries.blockentity.RocketTurretBlockEntity;
import liedge.ltxindustries.entity.BaseRocketEntity;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.entity.damage.TurretDamageSource;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TurretRocketEntity
extends BaseRocketEntity {
    private MachineUpgrades upgrades = MachineUpgrades.EMPTY;
    @Nullable
    private BlockPos turretPos;

    public TurretRocketEntity(EntityType<?> type, Level level, @Nullable BlockPos turretPos) {
        super(type, level);
        this.turretPos = turretPos;
    }

    public TurretRocketEntity(EntityType<?> type, Level level) {
        this(type, level, null);
    }

    public TurretRocketEntity(Level level, RocketTurretBlockEntity blockEntity) {
        this((EntityType)LTXIEntities.TURRET_ROCKET.get(), level, blockEntity.getBlockPos());
        this.upgrades = blockEntity.getUpgrades();
    }

    public MachineUpgrades getUpgrades() {
        return this.upgrades;
    }

    @Override
    protected void damageTarget(Level level, @Nullable LivingEntity owner, Entity targetEntity, Vec3 hitLocation, boolean isDirectHit) {
        RocketTurretBlockEntity be;
        float baseDamage = (float)LTXIMachinesConfig.ATMOS_TURRET_ROCKET_DAMAGE.getAsDouble();
        RocketTurretBlockEntity rocketTurretBlockEntity = be = this.turretPos != null ? (RocketTurretBlockEntity)LimaBlockUtil.getSafeBlockEntity((LevelReader)level, (BlockPos)this.turretPos, RocketTurretBlockEntity.class) : null;
        if (be != null) {
            LTXIEntityUtil.hurtWithEnchantedFakePlayer((ServerLevel)level, targetEntity, owner, be.getUpgrades(), le -> TurretDamageSource.create(level, LTXIDamageTypes.TURRET_ROCKET, be, this, (Entity)le, null), baseDamage);
        } else {
            targetEntity.hurt(level.damageSources().source(LTXIDamageTypes.TURRET_ROCKET, (Entity)this, (Entity)owner), baseDamage);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.upgrades = this.readMachineUpgrades(tag);
        if (tag.contains("turret_pos")) {
            this.turretPos = (BlockPos)LimaNbtUtil.strictDecode((Codec)BlockPos.CODEC, (DynamicOps)NbtOps.INSTANCE, (CompoundTag)tag, (String)"turret_pos");
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.writeMachineUpgrades(this.upgrades, tag);
        if (this.turretPos != null) {
            tag.put("turret_pos", (Tag)LimaCoreCodecs.strictEncode((Codec)BlockPos.CODEC, (DynamicOps)NbtOps.INSTANCE, (Object)this.turretPos));
        }
    }
}

