/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity.damage;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.Nullable;

public record DropsRedirect(IItemHandler targetInventory, @Nullable Vec3 newDropsLocation, Predicate<ItemEntity> predicate) {
    private static <U extends UpgradeBase<?, U>> HolderSet<Item> mergeSets(UpgradesContainerBase<?, U> upgrades, DirectDropsUpgradeEffect.Type type) {
        ObjectArrayList sets = new ObjectArrayList();
        for (Object2IntMap.Entry<Holder<U>> entry : upgrades.toEntrySet()) {
            List effects = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect((DataComponentType)LTXIUpgradeEffectComponents.DIRECT_DROPS.get());
            for (DirectDropsUpgradeEffect effect : effects) {
                if (effect.type() != type) continue;
                HolderSet<Item> set = effect.items();
                if (set instanceof AnyHolderSet) {
                    return set;
                }
                sets.add(set);
            }
        }
        return LimaRegistryUtil.mergeHolderSets((List)sets);
    }

    @Nullable
    public static <U extends UpgradeBase<?, U>> DropsRedirect create(IItemHandler targetInventory, @Nullable Vec3 newDropsLocation, UpgradesContainerBase<?, U> upgrades, DirectDropsUpgradeEffect.Type type) {
        HolderSet<Item> set = DropsRedirect.mergeSets(upgrades, type);
        if (set.equals((Object)HolderSet.empty())) {
            return null;
        }
        return new DropsRedirect(targetInventory, newDropsLocation, ie -> set.contains(ie.getItem().getItemHolder()));
    }

    @Nullable
    public static DropsRedirect forPlayer(Player player, UpgradesContainerBase<?, ?> upgrades, DirectDropsUpgradeEffect.Type type) {
        return DropsRedirect.create((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), player.getEyePosition(), upgrades, type);
    }

    public void captureAndRelocateDrops(Collection<ItemEntity> itemEntities) {
        Iterator<ItemEntity> iterator = itemEntities.iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity = iterator.next();
            if (!this.predicate.test(itemEntity)) continue;
            ItemStack original = itemEntity.getItem();
            ItemStack insertRemainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.targetInventory, (ItemStack)original, (boolean)false);
            if (insertRemainder.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (this.newDropsLocation != null) {
                itemEntity.setPos(this.newDropsLocation);
                itemEntity.setDeltaMovement(Vec3.ZERO);
            }
            if (original.getCount() == insertRemainder.getCount()) continue;
            itemEntity.setItem(insertRemainder);
        }
    }
}

