/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity.damage;

import com.google.common.base.Preconditions;
import liedge.ltxindustries.blockentity.BaseTurretBlockEntity;
import liedge.ltxindustries.entity.damage.DropsRedirect;
import liedge.ltxindustries.entity.damage.UpgradableDamageSource;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TurretDamageSource
extends UpgradableDamageSource {
    private final BaseTurretBlockEntity blockEntity;

    public static TurretDamageSource create(Level level, ResourceKey<DamageType> damageTypeKey, BaseTurretBlockEntity blockEntity, @Nullable Entity directEntity, @Nullable Entity owner, @Nullable Vec3 location) {
        Preconditions.checkArgument((directEntity != null || location != null ? 1 : 0) != 0, (Object)"Turret damage must have either a direct projectile entity or a location");
        return new TurretDamageSource((Holder<DamageType>)level.registryAccess().holderOrThrow(damageTypeKey), blockEntity, directEntity, owner, location);
    }

    private TurretDamageSource(Holder<DamageType> type, BaseTurretBlockEntity blockEntity, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 location) {
        super(type, directEntity, causingEntity, location);
        this.blockEntity = blockEntity;
    }

    @Override
    public UpgradesContainerBase<?, ?> getUpgrades() {
        return this.blockEntity.getUpgrades();
    }

    @Override
    @Nullable
    public DropsRedirect createDropsRedirect() {
        return DropsRedirect.create((IItemHandler)this.blockEntity.getOutputInventory(), this.blockEntity.getProjectileStart(), this.getUpgrades(), DirectDropsUpgradeEffect.Type.ENTITY_DROPS);
    }
}

