/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity.damage;

import liedge.limacore.util.LimaCoreUtil;
import liedge.ltxindustries.entity.damage.DropsRedirect;
import liedge.ltxindustries.entity.damage.UpgradableDamageSource;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpgradableEquipmentDamageSource
extends UpgradableDamageSource {
    private final ItemStack weaponItem;
    private final EquipmentUpgrades upgrades;

    public static UpgradableEquipmentDamageSource directDamage(ResourceKey<DamageType> typeKey, Entity attacker, ItemStack weaponItem) {
        return new UpgradableEquipmentDamageSource(typeKey, attacker, attacker, weaponItem);
    }

    public static UpgradableEquipmentDamageSource projectileDamage(ResourceKey<DamageType> typeKey, Entity projectile, @Nullable Entity attacker, ItemStack weaponItem) {
        return new UpgradableEquipmentDamageSource(typeKey, projectile, attacker, weaponItem);
    }

    private UpgradableEquipmentDamageSource(ResourceKey<DamageType> typeKey, Entity directEntity, @Nullable Entity causingEntity, ItemStack weaponItem) {
        super((Holder<DamageType>)directEntity.level().registryAccess().holderOrThrow(typeKey), directEntity, causingEntity);
        this.weaponItem = weaponItem;
        this.upgrades = UpgradableEquipmentItem.getEquipmentUpgradesFromStack(weaponItem);
    }

    @NotNull
    public ItemStack getWeaponItem() {
        return this.weaponItem;
    }

    public EquipmentUpgrades getUpgrades() {
        return this.upgrades;
    }

    @Override
    @Nullable
    public DropsRedirect createDropsRedirect() {
        Player player = (Player)LimaCoreUtil.castOrNull(Player.class, (Object)this.getEntity());
        return player != null ? DropsRedirect.forPlayer(player, this.upgrades, DirectDropsUpgradeEffect.Type.ENTITY_DROPS) : null;
    }
}

