/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.entity.effect;

import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class FrostbiteMobEffect
extends MobEffect {
    public FrostbiteMobEffect(ResourceLocation id) {
        super(MobEffectCategory.HARMFUL, LTXIConstants.CRYO_LIGHT_BLUE.argb32());
        this.addAttributeModifier(Attributes.ATTACK_SPEED, id.withSuffix(".attack_speed"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, id.withSuffix(".move_speed"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.FLYING_SPEED, id.withSuffix(".fly_speed"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.BLOCK_BREAK_SPEED, id.withSuffix(".dig_speed"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.canFreeze()) {
            int ticksFrozen = livingEntity.getTicksRequiredToFreeze() + 10;
            livingEntity.setTicksFrozen(ticksFrozen);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public ParticleOptions createParticleOptions(MobEffectInstance effect) {
        return (ParticleOptions)LTXIParticles.CRYO_SNOWFLAKE.get();
    }
}

