/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import java.util.function.Supplier;
import liedge.limacore.recipe.LimaRecipeType;
import liedge.limacore.util.LimaTextUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.FabricatorProgressWidget;
import liedge.ltxindustries.integration.jei.LTXIJeiCategory;
import liedge.ltxindustries.integration.jei.LTXIJeiPlugin;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.RecipeHolder;

class FabricatingJeiCategory
extends LTXIJeiCategory<FabricatingRecipe> {
    private final IDrawableStatic progressBackground = this.guiSpriteDrawable(FabricatorProgressWidget.BACKGROUND_SPRITE, 5, 22).build();
    private final IDrawableAnimated progressForeground = this.guiSpriteDrawable(FabricatorProgressWidget.FILL_SPRITE, 3, 20).buildAnimated(80, IDrawableAnimated.StartDirection.BOTTOM, false);

    FabricatingJeiCategory(IGuiHelper helper, Supplier<LimaRecipeType<FabricatingRecipe>> typeSupplier) {
        super(helper, typeSupplier, 140, 76);
    }

    public RecipeType<RecipeHolder<FabricatingRecipe>> getRecipeType() {
        return LTXIJeiPlugin.FABRICATING_JEI;
    }

    @Override
    protected void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<FabricatingRecipe> holder, FabricatingRecipe recipe, IFocusGroup focuses, RegistryAccess registries) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 114, 36).addItemStack(recipe.getFabricatingResultItem());
        this.sizedIngredientSlotsGrid(builder, recipe, 2, 2, 6);
    }

    @Override
    protected void drawRecipe(RecipeHolder<FabricatingRecipe> recipeHolder, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        LTXIScreen.blitEmptySlotGrid(graphics, 1, 1, 6, 2);
        LTXIScreen.blitEmptySlotGrid(graphics, 1, 37, 4, 1);
        LTXIScreen.blitOutputSlotSprite(graphics, 111, 33);
        this.progressBackground.draw(graphics, 133, 33);
        this.progressForeground.draw(graphics, 134, 34);
        FabricatingRecipe recipe = (FabricatingRecipe)recipeHolder.value();
        MutableComponent energyText = LTXILangKeys.INLINE_ENERGY.translateArgs(new Object[]{LimaTextUtil.formatWholeNumber((int)recipe.getEnergyRequired())});
        graphics.drawString(Minecraft.getInstance().font, (Component)energyText, 2, 57, LTXIConstants.REM_BLUE.argb32(), false);
        if (recipe.isAdvancementLocked()) {
            graphics.drawString(Minecraft.getInstance().font, (Component)LTXILangKeys.ADVANCEMENT_LOCKED_TOOLTIP.translate(), 2, 67, LTXIConstants.HOSTILE_ORANGE.argb32(), false);
        }
    }
}

