/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import java.util.List;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.limacore.util.LimaTextUtil;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;

final class FluidIngredientRenderer
implements IIngredientRenderer<FluidStack> {
    static final FluidIngredientRenderer INSTANCE = new FluidIngredientRenderer();

    private FluidIngredientRenderer() {
    }

    public void render(GuiGraphics guiGraphics, FluidStack ingredient) {
        LimaGuiUtil.renderFluidWithAmount((GuiGraphics)guiGraphics, (FluidStack)ingredient, (int)0, (int)0);
    }

    public void getTooltip(ITooltipBuilder tooltip, FluidStack ingredient, TooltipFlag tooltipFlag) {
        tooltip.add((FormattedText)ingredient.getHoverName());
        tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{LimaTextUtil.formatWholeNumber((int)ingredient.getAmount())}));
        if (tooltipFlag.isAdvanced()) {
            ResourceLocation id = LimaRegistryUtil.getNonNullRegistryId((Holder)ingredient.getFluidHolder());
            tooltip.add((FormattedText)Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public List<Component> getTooltip(FluidStack ingredient, TooltipFlag tooltipFlag) {
        return List.of();
    }
}

