/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeType;
import liedge.limacore.recipe.ingredient.ConsumeChanceIngredient;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.recipe.result.ItemResultType;
import liedge.limacore.util.LimaTextUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.widget.MachineProgressWidget;
import liedge.ltxindustries.integration.jei.FluidIngredientRenderer;
import liedge.ltxindustries.integration.jei.ScaledFontDrawable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class LTXIJeiCategory<R extends LimaCustomRecipe<?>>
implements IRecipeCategory<RecipeHolder<R>> {
    protected final IGuiHelper helper;
    private final int width;
    private final int height;
    private final Component title;
    protected final IDrawableStatic machineProgressBackground;
    protected final IDrawableAnimated machineProgress;

    protected LTXIJeiCategory(IGuiHelper helper, LimaRecipeType<R> gameRecipeType, int width, int height) {
        this.helper = helper;
        this.width = width;
        this.height = height;
        this.title = gameRecipeType.translate();
        this.machineProgressBackground = this.guiSpriteDrawable(MachineProgressWidget.BACKGROUND_SPRITE, 24, 6).build();
        this.machineProgress = this.guiSpriteDrawable(MachineProgressWidget.FILL_SPRITE, 22, 4).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    protected LTXIJeiCategory(IGuiHelper helper, Supplier<? extends LimaRecipeType<R>> typeSupplier, int width, int height) {
        this(helper, typeSupplier.get(), width, height);
    }

    protected abstract void setRecipe(IRecipeLayoutBuilder var1, RecipeHolder<R> var2, R var3, IFocusGroup var4, RegistryAccess var5);

    protected abstract void drawRecipe(RecipeHolder<R> var1, IRecipeSlotsView var2, GuiGraphics var3, double var4, double var6);

    protected final RegistryAccess localRegistryAccess() {
        return Objects.requireNonNull(Minecraft.getInstance().level, "Minecraft local level is null").registryAccess();
    }

    protected ResourceLocation unwrapGuiSpriteTexture(ResourceLocation spriteLocation) {
        return spriteLocation.withPath(path -> String.format("textures/gui/sprites/%s.png", path));
    }

    protected IDrawableBuilder guiSpriteDrawable(ResourceLocation spriteLocation, int width, int height) {
        return this.helper.drawableBuilder(this.unwrapGuiSpriteTexture(spriteLocation), 0, 0, width, height).setTextureSize(width, height);
    }

    protected void sizedIngredientsSlot(IRecipeLayoutBuilder builder, R recipe, int ingredientIndex, int x, int y) {
        SizedIngredient sizedIngredient = recipe.getItemIngredient(ingredientIndex);
        IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(List.of(sizedIngredient.getItems()));
        ICustomIngredient iCustomIngredient = sizedIngredient.ingredient().getCustomIngredient();
        if (iCustomIngredient instanceof ConsumeChanceIngredient) {
            ConsumeChanceIngredient chanceIngredient = (ConsumeChanceIngredient)iCustomIngredient;
            if (chanceIngredient.consumeChance() == 0.0f) {
                slot.setOverlay((IDrawable)ScaledFontDrawable.withStyle("NC", ChatFormatting.GREEN, 0.5f), 1, 1).addRichTooltipCallback((view, lines) -> lines.add((FormattedText)LTXILangKeys.INPUT_NOT_CONSUMED_TOOLTIP.translate().withStyle(ChatFormatting.GREEN)));
            } else {
                String formattedChance = LimaTextUtil.format1PlacePercentage((double)chanceIngredient.consumeChance());
                slot.setOverlay((IDrawable)ScaledFontDrawable.withStyle(formattedChance, ChatFormatting.YELLOW, 0.5f), 1, 1).addRichTooltipCallback((view, lines) -> lines.add((FormattedText)LTXILangKeys.INPUT_CONSUME_CHANCE_TOOLTIP.translateArgs(new Object[]{formattedChance}).withStyle(ChatFormatting.YELLOW)));
            }
        }
    }

    protected void sizedIngredientSlotsGrid(IRecipeLayoutBuilder builder, R recipe, int x, int y, int columns) {
        List ingredients = recipe.getItemIngredients();
        for (int i = 0; i < ingredients.size(); ++i) {
            int sx = x + i % columns * 18;
            int sy = y + i / columns * 18;
            this.sizedIngredientsSlot(builder, recipe, i, sx, sy);
        }
    }

    protected void fluidIngredientSlot(IRecipeLayoutBuilder builder, R recipe, int ingredientIndex, int x, int y) {
        FluidStack[] fluids;
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, y).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)FluidIngredientRenderer.INSTANCE);
        SizedFluidIngredient ingredient = recipe.getFluidIngredient(ingredientIndex);
        for (FluidStack stack : fluids = ingredient.getFluids()) {
            slotBuilder.addFluidStack(stack.getFluid(), (long)stack.getAmount());
        }
    }

    protected void itemResultSlot(IRecipeLayoutBuilder builder, R recipe, int resultIndex, int x, int y) {
        ItemResultType type;
        ItemResult result = recipe.getItemResult(resultIndex);
        IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(result.getGuiPreviewResult());
        if (!result.requiredOutput()) {
            slot.addRichTooltipCallback((view, lines) -> lines.add((FormattedText)LTXILangKeys.OUTPUT_OPTIONAL_TOOLTIP.translate().withStyle(LTXIConstants.OUTPUT_ORANGE.chatStyle())));
        }
        if ((type = result.getType()) == ItemResultType.RANDOM_CHANCE) {
            String formattedChance = LimaTextUtil.format1PlacePercentage((double)result.resultChance());
            slot.setOverlay((IDrawable)ScaledFontDrawable.withStyle(formattedChance, ChatFormatting.YELLOW, 0.5f), 1, 1).addRichTooltipCallback((view, lines) -> lines.add((FormattedText)LTXILangKeys.OUTPUT_CHANCE_TOOLTIP.translate().append(formattedChance).withStyle(ChatFormatting.YELLOW)));
        } else if (type == ItemResultType.VARIABLE_COUNT) {
            String formattedCount = result.minimumCount() + "-" + result.maximumCount();
            int countWidth = Minecraft.getInstance().font.width(formattedCount);
            float scale = countWidth > 15 ? 15.0f / (float)countWidth : 1.0f;
            ScaledFontDrawable count = ScaledFontDrawable.plainText(formattedCount, scale);
            slot.setOverlay((IDrawable)count, 16 - count.getWidth(), 17 - count.getHeight()).addRichTooltipCallback((view, lines) -> lines.add((FormattedText)LTXILangKeys.OUTPUT_VARIABLE_COUNT_TOOLTIP.translate().append(formattedCount)));
        }
    }

    protected void fluidResultSlot(IRecipeLayoutBuilder builder, R recipe, int resultIndex, int x, int y) {
        FluidStack result = recipe.getFluidResult(resultIndex);
        builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)FluidIngredientRenderer.INSTANCE).addFluidStack(result.getFluid(), (long)result.getAmount());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final void draw(RecipeHolder<R> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.fill(0, 0, this.width, this.height, -13750738);
        this.drawRecipe(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public final void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<R> recipe, IFocusGroup focuses) {
        this.setRecipe(builder, recipe, (LimaCustomRecipe)recipe.value(), focuses, this.localRegistryAccess());
    }

    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }
}

