/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.client.gui.LimaMenuScreen;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeType;
import liedge.limacore.util.LimaRecipesUtil;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.template.BaseRecipeMachineBlockEntity;
import liedge.ltxindustries.client.LTXIClientRecipes;
import liedge.ltxindustries.client.gui.screen.RecipeLayoutScreen;
import liedge.ltxindustries.integration.jei.FabricatingJeiCategory;
import liedge.ltxindustries.integration.jei.ModuleSubtypeInterpreter;
import liedge.ltxindustries.integration.jei.RecipeLayoutJeiCategory;
import liedge.ltxindustries.menu.RecipeLayoutMenu;
import liedge.ltxindustries.menu.layout.RecipeLayout;
import liedge.ltxindustries.menu.layout.RecipeLayouts;
import liedge.ltxindustries.recipe.AssemblingRecipe;
import liedge.ltxindustries.recipe.ChemicalReactingRecipe;
import liedge.ltxindustries.recipe.ElectroCentrifugingRecipe;
import liedge.ltxindustries.recipe.EnergizingRecipe;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.recipe.GardenSimulatingRecipe;
import liedge.ltxindustries.recipe.GrindingRecipe;
import liedge.ltxindustries.recipe.MaterialFusingRecipe;
import liedge.ltxindustries.recipe.MixingRecipe;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

@JeiPlugin
public class LTXIJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = LTXIndustries.RESOURCES.location("jei_plugin");
    private static final Map<ResourceLocation, RecipeType<?>> JEI_RECIPE_TYPES = new Object2ObjectOpenHashMap();
    static final RecipeType<RecipeHolder<SmeltingRecipe>> SMELTING_JEI = LTXIJeiPlugin.registerExisting(RecipeTypes.SMELTING);
    static final RecipeType<RecipeHolder<SmokingRecipe>> SMOKING_JEI = LTXIJeiPlugin.registerExisting(RecipeTypes.SMOKING);
    static final RecipeType<RecipeHolder<BlastingRecipe>> BLASTING_JEI = LTXIJeiPlugin.registerExisting(RecipeTypes.BLASTING);
    static final RecipeType<RecipeHolder<GrindingRecipe>> GRINDING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.GRINDING);
    static final RecipeType<RecipeHolder<MaterialFusingRecipe>> MATERIAL_FUSING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.MATERIAL_FUSING);
    static final RecipeType<RecipeHolder<ElectroCentrifugingRecipe>> ELECTRO_CENTRIFUGING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.ELECTRO_CENTRIFUGING);
    static final RecipeType<RecipeHolder<MixingRecipe>> MIXING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.MIXING);
    static final RecipeType<RecipeHolder<EnergizingRecipe>> ENERGIZING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.ENERGIZING);
    static final RecipeType<RecipeHolder<ChemicalReactingRecipe>> CHEMICAL_REACTING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.CHEMICAL_REACTING);
    static final RecipeType<RecipeHolder<AssemblingRecipe>> ASSEMBLING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.ASSEMBLING);
    static final RecipeType<RecipeHolder<GardenSimulatingRecipe>> GARDEN_SIMULATING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.GARDEN_SIMULATING);
    static final RecipeType<RecipeHolder<FabricatingRecipe>> FABRICATING_JEI = LTXIJeiPlugin.registerType(LTXIRecipeTypes.FABRICATING);

    private static <T> RecipeType<T> registerExisting(RecipeType<T> recipeType) {
        JEI_RECIPE_TYPES.put(recipeType.getUid(), recipeType);
        return recipeType;
    }

    private static <R extends LimaCustomRecipe<?>> RecipeType<RecipeHolder<R>> registerType(DeferredHolder<net.minecraft.world.item.crafting.RecipeType<?>, LimaRecipeType<R>> holder) {
        RecipeType type = RecipeType.createRecipeHolderType((ResourceLocation)holder.getId());
        JEI_RECIPE_TYPES.put(type.getUid(), type);
        return type;
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)LTXIItems.EQUIPMENT_UPGRADE_MODULE.get(), new ModuleSubtypeInterpreter(LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY));
        registration.registerSubtypeInterpreter((Item)LTXIItems.MACHINE_UPGRADE_MODULE.get(), new ModuleSubtypeInterpreter(LTXIDataComponents.MACHINE_UPGRADE_ENTRY));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.GRINDING, GRINDING_JEI, RecipeLayouts.GRINDING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.MATERIAL_FUSING, MATERIAL_FUSING_JEI, RecipeLayouts.FUSING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.ELECTRO_CENTRIFUGING, ELECTRO_CENTRIFUGING_JEI, RecipeLayouts.ELECTRO_CENTRIFUGING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.MIXING, MIXING_JEI, RecipeLayouts.MIXING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.ENERGIZING, ENERGIZING_JEI, RecipeLayouts.ENERGIZING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.CHEMICAL_REACTING, CHEMICAL_REACTING_JEI, RecipeLayouts.CHEMICAL_REACTING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.ASSEMBLING, ASSEMBLING_JEI, RecipeLayouts.ASSEMBLING)});
        registration.addRecipeCategories(new IRecipeCategory[]{RecipeLayoutJeiCategory.create(helper, LTXIRecipeTypes.GARDEN_SIMULATING, GARDEN_SIMULATING_JEI, RecipeLayouts.GARDEN_SIMULATING)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FabricatingJeiCategory(helper, (Supplier<LimaRecipeType<FabricatingRecipe>>)LTXIRecipeTypes.FABRICATING)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Level level = (Level)Objects.requireNonNull(Minecraft.getInstance().level);
        RecipeManager manager = level.getRecipeManager();
        registration.addRecipes(GRINDING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.GRINDING.get()));
        registration.addRecipes(MATERIAL_FUSING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.MATERIAL_FUSING.get()));
        registration.addRecipes(ELECTRO_CENTRIFUGING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.ELECTRO_CENTRIFUGING.get()));
        registration.addRecipes(MIXING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.MIXING.get()));
        registration.addRecipes(ENERGIZING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.ENERGIZING.get()));
        registration.addRecipes(CHEMICAL_REACTING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.CHEMICAL_REACTING.get()));
        registration.addRecipes(ASSEMBLING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.ASSEMBLING.get()));
        registration.addRecipes(GARDEN_SIMULATING_JEI, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)LTXIRecipeTypes.GARDEN_SIMULATING.get()));
        List fabricatingRecipes = LimaRecipesUtil.getSortedRecipesForType((Level)level, LTXIRecipeTypes.FABRICATING, LTXIClientRecipes.comparingFabricationRecipes());
        registration.addRecipes(FABRICATING_JEI, fabricatingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(LTXIBlocks.DIGITAL_FURNACE, new RecipeType[]{SMELTING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.DIGITAL_SMOKER, new RecipeType[]{SMOKING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.DIGITAL_BLAST_FURNACE, new RecipeType[]{BLASTING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.GRINDER, new RecipeType[]{GRINDING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.MATERIAL_FUSING_CHAMBER, new RecipeType[]{MATERIAL_FUSING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.ELECTROCENTRIFUGE, new RecipeType[]{ELECTRO_CENTRIFUGING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.MIXER, new RecipeType[]{MIXING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.VOLTAIC_INJECTOR, new RecipeType[]{ENERGIZING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.CHEM_LAB, new RecipeType[]{CHEMICAL_REACTING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.ASSEMBLER, new RecipeType[]{ASSEMBLING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.DIGITAL_GARDEN, new RecipeType[]{GARDEN_SIMULATING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.FABRICATOR, new RecipeType[]{FABRICATING_JEI});
        registration.addRecipeCatalyst(LTXIBlocks.AUTO_FABRICATOR, new RecipeType[]{FABRICATING_JEI});
    }

    public void registerGuiHandlers(final IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(LimaMenuScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<LimaMenuScreen>(this){

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(LimaMenuScreen containerScreen, double mouseX, double mouseY) {
                return Optional.ofNullable(containerScreen.getHoveredFluidSlot()).flatMap(slot -> registration.getJeiHelpers().getIngredientManager().createClickableIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)slot.getFluid(), new Rect2i(containerScreen.getGuiLeft() + slot.x(), containerScreen.getGuiTop() + slot.y(), 16, 16), false));
            }
        });
        registration.addGuiContainerHandler(RecipeLayoutScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<RecipeLayoutScreen>(this){

            public Collection<IGuiClickableArea> getGuiClickableAreas(RecipeLayoutScreen containerScreen, double guiMouseX, double guiMouseY) {
                ResourceLocation typeId;
                net.minecraft.world.item.crafting.RecipeType gameType = ((BaseRecipeMachineBlockEntity)((RecipeLayoutMenu)containerScreen.getMenu()).menuContext()).getRecipeCheck().getRecipeType();
                if (gameType instanceof LimaRecipeType) {
                    LimaRecipeType limaType = (LimaRecipeType)gameType;
                    typeId = limaType.id();
                } else {
                    typeId = LimaRegistryUtil.getNonNullRegistryId((Object)gameType, (Registry)BuiltInRegistries.RECIPE_TYPE);
                }
                RecipeLayout layout = ((RecipeLayoutMenu)containerScreen.getMenu()).getLayout();
                RecipeType<?> jeiType = JEI_RECIPE_TYPES.get(typeId);
                return jeiType != null ? List.of(IGuiClickableArea.createBasic((int)layout.progressBarX(), (int)layout.progressBarY(), (int)24, (int)6, (RecipeType[])new RecipeType[]{jeiType})) : List.of();
            }
        });
    }
}

