/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.recipe.LimaRecipeType;
import liedge.limacore.util.LimaTextUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.RecipeLayoutScreen;
import liedge.ltxindustries.integration.jei.LTXIJeiCategory;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import liedge.ltxindustries.menu.layout.RecipeLayout;
import liedge.ltxindustries.recipe.LTXIRecipe;
import liedge.ltxindustries.recipe.RecipeMode;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

final class RecipeLayoutJeiCategory<R extends LTXIRecipe>
extends LTXIJeiCategory<R> {
    private static final int PADDING = 3;
    private final RecipeType<RecipeHolder<R>> jeiRecipeType;
    private final RecipeLayout layout;
    private final int xOffset;
    private final int yOffset;
    private final IDrawableStatic modeBackground;
    private final IDrawableStatic modeOverlay;
    @Nullable
    private final ScreenPosition modePos;

    static <R extends LTXIRecipe> RecipeLayoutJeiCategory<R> create(IGuiHelper helper, Supplier<LimaRecipeType<R>> typeSupplier, RecipeType<RecipeHolder<R>> jeiRecipeType, RecipeLayout layout) {
        IntSummaryStatistics xss = layout.streamSlots().collect(Collectors.summarizingInt(LayoutSlot::x));
        IntSummaryStatistics yss = layout.streamSlots().collect(Collectors.summarizingInt(LayoutSlot::y));
        int width = xss.getMax() - xss.getMin() + 18 + 6;
        int height = yss.getMax() - yss.getMin() + 29 + 6;
        int xOffset = xss.getMin() - 3 - 1;
        int yOffset = yss.getMin() - 3 - 1;
        return new RecipeLayoutJeiCategory<R>(helper, typeSupplier.get(), jeiRecipeType, layout, width, height, xOffset, yOffset);
    }

    private RecipeLayoutJeiCategory(IGuiHelper helper, LimaRecipeType<R> recipeType, RecipeType<RecipeHolder<R>> jeiRecipeType, RecipeLayout layout, int width, int height, int xOffset, int yOffset) {
        super(helper, recipeType, width, height);
        this.jeiRecipeType = jeiRecipeType;
        this.layout = layout;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.modeBackground = this.guiSpriteDrawable(LayoutSlot.Type.RECIPE_MODE.getSprite(), 18, 18).build();
        this.modeOverlay = this.guiSpriteDrawable(RecipeLayoutScreen.MODE_OVERLAY_SPRITE, 16, 16).build();
        this.modePos = layout.streamSlots().filter(o -> o.type() == LayoutSlot.Type.RECIPE_MODE).findFirst().map(o -> new ScreenPosition(o.x() - xOffset, o.y() - yOffset)).orElse(null);
    }

    @Override
    protected void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<R> holder, R recipe, IFocusGroup focuses, RegistryAccess registries) {
        for (LayoutSlot.Type slotType : LayoutSlot.Type.values()) {
            List<LayoutSlot> layoutSlots = this.layout.getSlotsForType(slotType);
            int slotMax = switch (slotType) {
                default -> throw new MatchException(null, null);
                case LayoutSlot.Type.ITEM_INPUT -> recipe.getItemIngredients().size();
                case LayoutSlot.Type.FLUID_INPUT -> recipe.getFluidIngredients().size();
                case LayoutSlot.Type.ITEM_OUTPUT -> recipe.getItemResults().size();
                case LayoutSlot.Type.FLUID_OUTPUT -> recipe.getFluidResults().size();
                case LayoutSlot.Type.RECIPE_MODE -> 1;
            };
            slotMax = Math.min(layoutSlots.size(), slotMax);
            block14: for (int i = 0; i < slotMax; ++i) {
                LayoutSlot s = layoutSlots.get(i);
                int sx = s.x() - this.xOffset;
                int sy = s.y() - this.yOffset;
                switch (s.type()) {
                    case ITEM_INPUT: {
                        this.sizedIngredientsSlot(builder, recipe, i, sx, sy);
                        continue block14;
                    }
                    case ITEM_OUTPUT: {
                        this.itemResultSlot(builder, recipe, i, sx, sy);
                        continue block14;
                    }
                    case FLUID_INPUT: {
                        this.fluidIngredientSlot(builder, recipe, i, sx, sy);
                        continue block14;
                    }
                    case FLUID_OUTPUT: {
                        this.fluidResultSlot(builder, recipe, i, sx, sy);
                    }
                }
            }
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<R> recipeHolder, IFocusGroup focuses) {
        int timeInTicks = ((LTXIRecipe)recipeHolder.value()).getCraftTime();
        String timeInSeconds = LimaTextUtil.format2PlaceDecimal((double)((double)timeInTicks / 20.0));
        MutableComponent craftTimeComponent = LTXILangKeys.JEI_CRAFTING_TIME_TOOLTIP.translateArgs(new Object[]{timeInSeconds, timeInTicks});
        ((ITextWidget)builder.addText((FormattedText)craftTimeComponent, this.getWidth() - 6, 10).setPosition(3, this.getHeight() - 3 - 10)).setTextAlignment(HorizontalAlignment.LEFT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(LTXIConstants.LIME_GREEN.argb32());
        if (this.modePos != null) {
            builder.addWidget((IRecipeWidget)new RecipeModeWidget(this.modePos, (IDrawable)this.modeBackground, (IDrawable)this.modeOverlay, ((LTXIRecipe)recipeHolder.value()).getMode()));
        }
    }

    @Override
    protected void drawRecipe(RecipeHolder<R> recipeHolder, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        RecipeLayoutScreen.renderLayout(graphics, -this.xOffset, -this.yOffset, this.layout);
        int px = this.layout.progressBarX() - this.xOffset;
        int py = this.layout.progressBarY() - this.yOffset;
        this.machineProgressBackground.draw(graphics, px, py);
        this.machineProgress.draw(graphics, px + 1, py + 1);
    }

    public RecipeType<RecipeHolder<R>> getRecipeType() {
        return this.jeiRecipeType;
    }

    private record RecipeModeWidget(ScreenPosition position, IDrawable background, IDrawable overlay, @Nullable Holder<RecipeMode> mode) implements IRecipeWidget
    {
        public ScreenPosition getPosition() {
            return this.position;
        }

        public void drawWidget(GuiGraphics graphics, double mouseX, double mouseY) {
            this.background.draw(graphics, -1, -1);
            if (this.mode != null) {
                graphics.renderFakeItem(((RecipeMode)this.mode.value()).displayItem(), 0, 0);
            } else {
                this.overlay.draw(graphics, 0, 0);
            }
        }

        public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
            if (LimaGuiUtil.isMouseWithinArea((double)mouseX, (double)mouseY, (int)0, (int)0, (int)16, (int)16)) {
                if (this.mode != null) {
                    tooltip.add((FormattedText)LTXILangKeys.JEI_RECIPE_MODE_NEEDED.translateArgs(new Object[]{((RecipeMode)this.mode.value()).displayName()}));
                } else {
                    tooltip.add((FormattedText)LTXILangKeys.JEI_NO_RECIPE_MODE_NEEDED.translate().withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }
}

