/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import liedge.limacore.lib.LimaColor;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public final class ScaledFontDrawable
implements IDrawable {
    private final Font font;
    private final String text;
    private final int argb32;
    private final float scale;
    private final int width;
    private final int height;

    static ScaledFontDrawable plainText(String text, float scale) {
        return new ScaledFontDrawable(text, -1, scale);
    }

    static ScaledFontDrawable withColor(String text, LimaColor color, float scale) {
        return new ScaledFontDrawable(text, color.argb32(), scale);
    }

    static ScaledFontDrawable withStyle(String text, ChatFormatting formatting, float scale) {
        return new ScaledFontDrawable(text, Objects.requireNonNullElse(formatting.getColor(), -1), scale);
    }

    public ScaledFontDrawable(String text, int argb32, float scale) {
        this.font = Minecraft.getInstance().font;
        this.text = text;
        this.argb32 = argb32;
        this.scale = scale;
        this.width = Mth.ceil((float)((float)this.font.width(text) * scale));
        Objects.requireNonNull(this.font);
        this.height = Mth.ceil((float)(9.0f * scale));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)xOffset, (float)yOffset, 0.0f);
        poseStack.scale(this.scale, this.scale, 1.0f);
        guiGraphics.drawString(this.font, this.text, 0, 0, this.argb32, true);
        poseStack.popPose();
    }
}

