/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import java.util.UUID;
import java.util.function.Supplier;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ContentsTooltipBlockItem
extends BlockItem
implements TooltipShiftHintItem {
    private final boolean showEnergy;
    private final boolean showOwner;

    public static BlockItem energyTooltipItem(Block block, Item.Properties properties) {
        return new ContentsTooltipBlockItem(block, properties, true, false);
    }

    public static BlockItem energyOwnerTooltipItem(Block block, Item.Properties properties) {
        return new ContentsTooltipBlockItem(block, properties, true, true);
    }

    private ContentsTooltipBlockItem(Block block, Item.Properties properties, boolean showEnergy, boolean showOwner) {
        super(block, properties);
        this.showEnergy = showEnergy;
        this.showOwner = showOwner;
    }

    @Override
    public void appendTooltipHintComponents(@Nullable Level level, ItemStack stack, TooltipLineConsumer consumer) {
        if (this.showEnergy) {
            LTXITooltipUtil.appendEnergyOnlyTooltip(consumer, (Integer)stack.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY, (Object)0));
        }
        if (this.showOwner) {
            consumer.accept((FormattedText)LTXITooltipUtil.makeOwnerComponent((UUID)stack.get((Supplier)LimaCoreDataComponents.OWNER)).withStyle(ChatFormatting.GRAY));
        }
    }
}

