/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.item.EnergyHolderItem;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.util.config.LTXIMachinesConfig;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ECABlockItem
extends BlockItem
implements EnergyHolderItem,
TooltipShiftHintItem,
LimaCreativeTabFillerItem {
    public ECABlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public int getBaseEnergyCapacity(ItemStack stack) {
        return LTXIMachinesConfig.ECA_BASE_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyTransferRate(ItemStack stack) {
        return LTXIMachinesConfig.ECA_BASE_TRANSFER_RATE.getAsInt();
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return LTXIConstants.REM_BLUE.argb32();
    }

    public int getBarWidth(ItemStack stack) {
        float fill = Math.min(LimaCoreMath.divideFloat((float)this.getEnergyStored(stack), (float)this.getEnergyCapacity(stack)), 1.0f);
        return Math.round(13.0f * fill);
    }

    @Override
    public void appendTooltipHintComponents(@Nullable Level level, ItemStack stack, TooltipLineConsumer consumer) {
        this.appendStorageEnergyTooltip(consumer, stack);
    }
}

