/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import java.util.function.Supplier;
import liedge.limacore.capability.energy.LimaComponentEnergyStorage;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.util.LimaCoreUtil;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public interface EnergyHolderItem
extends ItemLike {
    @Nullable
    public static IEnergyStorage createEnergyAccess(ItemStack stack) {
        EnergyHolderItem item = (EnergyHolderItem)LimaCoreUtil.castOrThrow(EnergyHolderItem.class, (Object)stack.getItem(), (String)"Not an energy holder item.");
        return item.supportsEnergyStorage(stack) ? item.getOrCreateEnergyStorage(stack) : null;
    }

    public int getBaseEnergyCapacity(ItemStack var1);

    public int getBaseEnergyTransferRate(ItemStack var1);

    default public int getBaseEnergyUsage(ItemStack stack) {
        return 0;
    }

    default public int getEnergyStored(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY, (Object)0);
    }

    default public int getEnergyCapacity(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY_CAPACITY, (Object)this.getBaseEnergyCapacity(stack));
    }

    default public int getEnergyTransferRate(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY_TRANSFER_RATE, (Object)this.getBaseEnergyTransferRate(stack));
    }

    default public int getEnergyUsage(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)LimaCoreDataComponents.ENERGY_USAGE, (Object)this.getBaseEnergyUsage(stack));
    }

    default public boolean supportsEnergyStorage(ItemStack stack) {
        return true;
    }

    default public IEnergyStorage getOrCreateEnergyStorage(ItemStack stack) {
        return LimaComponentEnergyStorage.createFromItem((MutableDataComponentHolder)stack, (int)this.getBaseEnergyCapacity(stack), (int)this.getBaseEnergyTransferRate(stack));
    }

    default public void appendEquipmentEnergyTooltip(TooltipLineConsumer consumer, ItemStack stack) {
        LTXITooltipUtil.appendEnergyWithCapacityTooltip(consumer, this.getEnergyStored(stack), this.getEnergyCapacity(stack));
        LTXITooltipUtil.appendEnergyUsageTooltip(consumer, this.getEnergyUsage(stack));
    }

    default public void appendStorageEnergyTooltip(TooltipLineConsumer consumer, ItemStack stack) {
        LTXITooltipUtil.appendStorageEnergyTooltip(consumer, this.getEnergyStored(stack), this.getEnergyCapacity(stack), this.getEnergyTransferRate(stack));
    }
}

