/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import java.util.Optional;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.util.LimaRecipesUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FabricationBlueprintItem
extends Item
implements TooltipShiftHintItem,
LimaCreativeTabFillerItem {
    public FabricationBlueprintItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isCrouching()) {
            return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)LTXIItems.EMPTY_FABRICATION_BLUEPRINT.asItem()), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    @Override
    public void appendTooltipHintComponents(Level level, ItemStack stack, TooltipLineConsumer consumer) {
        Optional holder;
        ResourceLocation id = (ResourceLocation)stack.get(LTXIDataComponents.BLUEPRINT_RECIPE);
        if (id != null && (holder = LimaRecipesUtil.getRecipeById((Level)level, (ResourceLocation)id, LTXIRecipeTypes.FABRICATING)).isPresent()) {
            FabricatingRecipe recipe = (FabricatingRecipe)((RecipeHolder)holder.get()).value();
            ItemStack result = recipe.getFabricatingResultItem();
            MutableComponent resultName = result.getHoverName().copy().withStyle(result.getRarity().getStyleModifier());
            if (result.getCount() > 1) {
                resultName.append(" x" + result.getCount());
            }
            consumer.accept((FormattedText)resultName);
            consumer.accept((FormattedText)LTXILangKeys.INLINE_ENERGY_REQUIRED_TOOLTIP.translateArgs(new Object[]{LimaEnergyUtil.toEnergyString((int)recipe.getEnergyRequired())}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
            consumer.accept(recipe.createIngredientTooltip());
            return;
        }
        consumer.accept((FormattedText)LTXILangKeys.INVALID_BLUEPRINT_HINT.translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()));
    }

    public boolean addDefaultInstanceToCreativeTab(ResourceLocation tabId) {
        return false;
    }
}

