/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.client.LimaComponentUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class IOConfigCardItem
extends Item
implements TooltipShiftHintItem {
    private final BlockEntityInputType cardInputType;

    public IOConfigCardItem(Item.Properties properties, BlockEntityInputType cardInputType) {
        super(properties);
        this.cardInputType = cardInputType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack;
        if (player.isCrouching() && (stack = player.getItemInHand(usedHand)).get(LTXIDataComponents.BLOCK_IO_CONFIGURATION) != null) {
            if (level.isClientSide()) {
                player.displayClientMessage((Component)LTXILangKeys.IO_CARD_CLEARED.translate().withStyle(ChatFormatting.YELLOW), true);
            }
            stack.remove(LTXIDataComponents.BLOCK_IO_CONFIGURATION);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockIOConfiguration configuration = (BlockIOConfiguration)stack.get(LTXIDataComponents.BLOCK_IO_CONFIGURATION);
        ConfigurableIOBlockEntity blockEntity = (ConfigurableIOBlockEntity)LimaBlockUtil.getBlockEntity((BlockGetter)level, (BlockPos)context.getClickedPos(), ConfigurableIOBlockEntity.class);
        if (blockEntity != null && player != null) {
            if (!level.isClientSide()) {
                if (blockEntity.getConfigurableInputTypes().contains((Object)this.cardInputType)) {
                    BlockIOConfiguration currentConfig = blockEntity.getIOConfigurationOrThrow(this.cardInputType);
                    if (configuration == null) {
                        stack.set(LTXIDataComponents.BLOCK_IO_CONFIGURATION, (Object)currentConfig);
                        player.displayClientMessage((Component)LTXILangKeys.IO_CARD_COPIED.translate().withStyle(ChatFormatting.AQUA), true);
                    } else if (configuration.isValidForRules(blockEntity.getIOConfigRules(this.cardInputType))) {
                        if (!currentConfig.equals(configuration)) {
                            blockEntity.setIOConfiguration(this.cardInputType, configuration);
                            player.displayClientMessage((Component)LTXILangKeys.IO_CARD_PASTED.translate().withStyle(LTXIConstants.LIME_GREEN.chatStyle()), true);
                        } else {
                            player.displayClientMessage((Component)LTXILangKeys.IO_CARD_SAME_CONFIG.translate().withStyle(ChatFormatting.YELLOW), true);
                        }
                    } else {
                        player.displayClientMessage((Component)LTXILangKeys.IO_CARD_INVALID_SETUP.translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()), true);
                    }
                } else {
                    player.displayClientMessage((Component)LTXILangKeys.IO_CARD_INVALID_TYPE.translateArgs(new Object[]{this.cardInputType.translate()}).withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void appendTooltipHintComponents(Level level, ItemStack stack, TooltipLineConsumer consumer) {
        BlockIOConfiguration configuration = (BlockIOConfiguration)stack.get(LTXIDataComponents.BLOCK_IO_CONFIGURATION);
        if (configuration == null) {
            consumer.accept((FormattedText)LTXILangKeys.EMPTY_IO_CARD_HINT.translate().withStyle(ChatFormatting.GRAY));
        } else {
            consumer.accept((FormattedText)LTXILangKeys.ENCODED_IO_CARD_HINT.translate().withStyle(ChatFormatting.GRAY));
            configuration.forEach((side, access) -> consumer.accept((FormattedText)LimaComponentUtil.colonSpaced((MutableComponent)side.translate().withStyle(ChatFormatting.GRAY), (MutableComponent)access.translate().withStyle(this.ioStyle((IOAccess)access)))));
            if (configuration.autoInput()) {
                consumer.accept((FormattedText)LTXILangKeys.AUTO_INPUT_ON_TOOLTIP.translate().withStyle(LTXIConstants.INPUT_BLUE.chatStyle().withBold(Boolean.valueOf(true))));
            }
            if (configuration.autoOutput()) {
                consumer.accept((FormattedText)LTXILangKeys.AUTO_OUTPUT_ON_TOOLTIP.translate().withStyle(LTXIConstants.OUTPUT_ORANGE.chatStyle().withBold(Boolean.valueOf(true))));
            }
        }
    }

    private Style ioStyle(IOAccess access) {
        return switch (access) {
            default -> throw new MatchException(null, null);
            case IOAccess.DISABLED -> Style.EMPTY.withColor(ChatFormatting.GRAY);
            case IOAccess.INPUT_ONLY -> LTXIConstants.INPUT_BLUE.chatStyle();
            case IOAccess.OUTPUT_ONLY -> LTXIConstants.OUTPUT_ORANGE.chatStyle();
            case IOAccess.INPUT_AND_OUTPUT -> LTXIConstants.INPUT_OUTPUT_GREEN.chatStyle();
        };
    }
}

