/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import java.util.List;
import liedge.limacore.lib.Translatable;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.blockentity.MeshBlockEntity;
import liedge.ltxindustries.blockentity.base.UpgradesHolderBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.UpgradeModuleItem;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrade;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgradeEntry;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXICreativeTabs;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MachineUpgradeModuleItem
extends UpgradeModuleItem<MachineUpgrade, MachineUpgradeEntry> {
    private static final Style STYLE = Style.EMPTY.withColor(5032383);

    public static ItemStack createStack(Holder<MachineUpgrade> upgradeHolder, int upgradeRank) {
        ItemStack stack = new ItemStack((ItemLike)LTXIItems.MACHINE_UPGRADE_MODULE.get());
        stack.set(LTXIDataComponents.MACHINE_UPGRADE_ENTRY, (Object)new MachineUpgradeEntry(upgradeHolder, upgradeRank));
        return stack;
    }

    public MachineUpgradeModuleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        MeshBlockEntity meshBlockEntity;
        BlockPos primaryPos;
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockPos blockPos = context.getClickedPos();
        UpgradesHolderBlockEntity blockEntity = null;
        BlockEntity toCheck = level.getBlockEntity(blockPos);
        if (toCheck instanceof UpgradesHolderBlockEntity) {
            blockEntity = (UpgradesHolderBlockEntity)toCheck;
        } else if (toCheck instanceof MeshBlockEntity && (primaryPos = (meshBlockEntity = (MeshBlockEntity)toCheck).getPrimaryPos(blockPos, level.getBlockState(blockPos))) != null) {
            blockEntity = (UpgradesHolderBlockEntity)LimaBlockUtil.getSafeBlockEntity((LevelReader)level, (BlockPos)primaryPos, UpgradesHolderBlockEntity.class);
        }
        MachineUpgradeEntry entry = (MachineUpgradeEntry)stack.get(this.entryComponentType());
        if (entry != null && blockEntity != null && player != null) {
            if (!level.isClientSide()) {
                if (blockEntity.getUpgrades().canInstallUpgrade(blockEntity, entry)) {
                    int previousRank = blockEntity.getUpgrades().getUpgradeRank(entry.upgrade());
                    MachineUpgrades newUpgrades = blockEntity.getUpgrades().toMutableContainer().set(entry).toImmutable();
                    blockEntity.setUpgrades(newUpgrades);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                        if (previousRank > 0) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)MachineUpgradeModuleItem.createStack(entry.upgrade(), previousRank));
                        }
                    }
                    player.displayClientMessage((Component)LTXILangKeys.UPGRADE_INSTALL_SUCCESS.translate().withStyle(this.moduleTypeStyle()), true);
                    level.playSound(null, blockPos, (SoundEvent)LTXISounds.UPGRADE_INSTALL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.displayClientMessage((Component)LTXILangKeys.UPGRADE_INSTALL_FAIL.translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public DataComponentType<MachineUpgradeEntry> entryComponentType() {
        return (DataComponentType)LTXIDataComponents.MACHINE_UPGRADE_ENTRY.get();
    }

    @Override
    protected ResourceKey<Registry<MachineUpgrade>> upgradeRegistryKey() {
        return LTXIRegistries.Keys.MACHINE_UPGRADES;
    }

    @Override
    protected ResourceLocation creativeTabId() {
        return LTXICreativeTabs.MACHINE_MODULES_TAB.getId();
    }

    @Override
    protected MachineUpgradeEntry createUpgradeEntry(Holder<MachineUpgrade> upgradeHolder, int upgradeRank) {
        return new MachineUpgradeEntry(upgradeHolder, upgradeRank);
    }

    @Override
    protected Translatable moduleTypeTooltip() {
        return LTXILangKeys.MACHINE_UPGRADE_MODULE_TOOLTIP;
    }

    @Override
    protected Style moduleTypeStyle() {
        return STYLE;
    }

    @Override
    protected List<ItemStack> getAllCompatibleItems(MachineUpgrade upgrade) {
        return upgrade.supportedSet().stream().flatMap(type -> ((BlockEntityType)type.value()).getValidBlocks().stream()).map(block -> block.asItem().getDefaultInstance()).toList();
    }
}

