/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.ltxindustries.item.EnergyHolderItem;
import liedge.ltxindustries.lib.upgrades.effect.ItemAttributesUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public interface UpgradableEquipmentItem
extends ItemLike {
    public static EquipmentUpgrades getEquipmentUpgradesFromStack(ItemStack stack) {
        return (EquipmentUpgrades)stack.getOrDefault(LTXIDataComponents.EQUIPMENT_UPGRADES, (Object)EquipmentUpgrades.EMPTY);
    }

    @Nullable
    default public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return null;
    }

    default public ItemStack createStackWithDefaultUpgrades(HolderLookup.Provider registries) {
        ItemStack stack = new ItemStack((ItemLike)this);
        Optional.ofNullable(this.getDefaultUpgradeKey()).flatMap(arg_0 -> ((HolderLookup.Provider)registries).holder(arg_0)).ifPresent(holder -> this.setUpgrades(stack, EquipmentUpgrades.builder().set((Holder<EquipmentUpgrade>)holder).toImmutable()));
        return stack;
    }

    default public void onUpgradeRefresh(LootContext context, ItemStack stack, EquipmentUpgrades upgrades) {
        EnergyHolderItem holderItem;
        upgrades.applyEnchantments(stack);
        ObjectArrayList modifierEntries = new ObjectArrayList();
        modifierEntries.addAll(this.asItem().getDefaultAttributeModifiers(stack).modifiers());
        upgrades.forEachEffect(LTXIUpgradeEffectComponents.ITEM_ATTRIBUTE_MODIFIERS, (arg_0, arg_1) -> UpgradableEquipmentItem.lambda$onUpgradeRefresh$1((List)modifierEntries, arg_0, arg_1));
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers((List)modifierEntries, true));
        UpgradableEquipmentItem upgradableEquipmentItem = this;
        if (upgradableEquipmentItem instanceof EnergyHolderItem && (holderItem = (EnergyHolderItem)((Object)upgradableEquipmentItem)).supportsEnergyStorage(stack)) {
            int capacity = LimaCoreMath.round((double)upgrades.applyValue((Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.ENERGY_CAPACITY, context, (double)holderItem.getBaseEnergyCapacity(stack)));
            stack.set((Supplier)LimaCoreDataComponents.ENERGY_CAPACITY, (Object)capacity);
            int transferRate = LimaCoreMath.round((double)upgrades.applyValue((Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, context, (double)holderItem.getBaseEnergyTransferRate(stack)));
            int energyUsage = LimaCoreMath.round((double)upgrades.applyValue((Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.ENERGY_USAGE, context, (double)holderItem.getBaseEnergyUsage(stack)));
            stack.set((Supplier)LimaCoreDataComponents.ENERGY_TRANSFER_RATE, (Object)transferRate);
            stack.set((Supplier)LimaCoreDataComponents.ENERGY_USAGE, (Object)energyUsage);
        }
    }

    default public EquipmentUpgrades getUpgrades(ItemStack stack) {
        return UpgradableEquipmentItem.getEquipmentUpgradesFromStack(stack);
    }

    default public void setUpgrades(ItemStack stack, EquipmentUpgrades upgrades) {
        stack.set(LTXIDataComponents.EQUIPMENT_UPGRADES, (Object)upgrades);
    }

    default public float getUpgradedDamage(ServerLevel level, EquipmentUpgrades upgrades, Entity targetEntity, DamageSource source, double baseDamage) {
        return (float)upgrades.applyConditionalValue((DataComponentType<List<ConditionalEffect<ValueUpgradeEffect>>>)((DataComponentType)LTXIUpgradeEffectComponents.EQUIPMENT_DAMAGE.get()), rank -> Enchantment.damageContext((ServerLevel)level, (int)rank, (Entity)targetEntity, (DamageSource)source), baseDamage);
    }

    private static /* synthetic */ void lambda$onUpgradeRefresh$1(List modifierEntries, ItemAttributesUpgradeEffect effect, int rank) {
        modifierEntries.add(effect.createModifierEntry(rank));
    }
}

