/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.lib.Translatable;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.menu.tooltip.ItemGridTooltip;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public abstract class UpgradeModuleItem<U extends UpgradeBase<?, U>, UE extends UpgradeBaseEntry<U>>
extends Item
implements LimaCreativeTabFillerItem,
TooltipShiftHintItem {
    protected UpgradeModuleItem(Item.Properties properties) {
        super(properties);
    }

    public abstract DataComponentType<UE> entryComponentType();

    protected abstract ResourceKey<Registry<U>> upgradeRegistryKey();

    protected abstract ResourceLocation creativeTabId();

    protected abstract UE createUpgradeEntry(Holder<U> var1, int var2);

    protected abstract Translatable moduleTypeTooltip();

    protected abstract Style moduleTypeStyle();

    protected abstract List<ItemStack> getAllCompatibleItems(U var1);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isCrouching() && stack.get(this.entryComponentType()) == null) {
            return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)LTXIItems.EMPTY_UPGRADE_MODULE.get()), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public Component getName(ItemStack stack) {
        UpgradeBaseEntry entry = (UpgradeBaseEntry)stack.get(this.entryComponentType());
        if (entry != null) {
            return ((UpgradeBase)entry.upgrade().value()).display().title();
        }
        return this.moduleTypeTooltip().translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UpgradeBaseEntry entry = (UpgradeBaseEntry)stack.get(this.entryComponentType());
        if (entry != null) {
            tooltipComponents.add((Component)this.moduleTypeTooltip().translate().withStyle(this.moduleTypeStyle()));
            UpgradeBase upgrade = (UpgradeBase)entry.upgrade().value();
            if (upgrade.maxRank() > 1) {
                tooltipComponents.add((Component)LTXILangKeys.UPGRADE_RANK_TOOLTIP.translateArgs(new Object[]{entry.upgradeRank(), upgrade.maxRank()}).withStyle(LTXIConstants.UPGRADE_RANK_MAGENTA.chatStyle()));
            }
            tooltipComponents.add(upgrade.display().description());
        } else {
            tooltipComponents.add((Component)LTXILangKeys.INVALID_UPGRADE_HINT.translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()));
        }
    }

    @Override
    public void appendTooltipHintComponents(@Nullable Level level, ItemStack stack, TooltipLineConsumer consumer) {
        UpgradeBaseEntry entry = (UpgradeBaseEntry)stack.get(this.entryComponentType());
        if (entry != null) {
            HolderSet holderSet;
            UpgradeBase upgrade = (UpgradeBase)entry.upgrade().value();
            upgrade.applyEffectsTooltips(entry.upgradeRank(), arg_0 -> ((TooltipLineConsumer)consumer).accept(arg_0));
            consumer.accept((FormattedText)LTXILangKeys.UPGRADE_COMPATIBILITY_TOOLTIP.translate().withStyle(this.moduleTypeStyle()));
            List<ItemStack> compatibleItems = this.getAllCompatibleItems(upgrade);
            if (compatibleItems.size() > 12 && (holderSet = upgrade.supportedSet()) instanceof HolderSet.Named) {
                HolderSet.Named namedSet = (HolderSet.Named)holderSet;
                consumer.accept((FormattedText)Component.translatable((String)Tags.getTagTranslationKey((TagKey)namedSet.key())).withStyle(this.moduleTypeStyle()));
            } else {
                consumer.accept((TooltipComponent)new ItemGridTooltip(compatibleItems, 7, 2, false));
            }
        }
    }

    public boolean addDefaultInstanceToCreativeTab(ResourceLocation tabId) {
        return false;
    }

    public void addAdditionalToCreativeTab(ResourceLocation tabId, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, CreativeModeTab.TabVisibility tabVisibility) {
        if (tabId.equals((Object)this.creativeTabId())) {
            HolderLookup.RegistryLookup registry = parameters.holders().lookupOrThrow(this.upgradeRegistryKey());
            registry.listElements().sorted(UpgradeBase.comparingCategoryThenId()).flatMap(this::createPairsStream).forEach(pair -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                stack.set(this.entryComponentType(), (Object)((UpgradeBaseEntry)pair.getA()));
                output.accept(stack, (CreativeModeTab.TabVisibility)pair.getB());
            });
        }
    }

    private Stream<Pair<UE, CreativeModeTab.TabVisibility>> createPairsStream(Holder<U> holder) {
        int max = ((UpgradeBase)holder.value()).maxRank();
        return IntStream.rangeClosed(1, max).mapToObj(rank -> {
            CreativeModeTab.TabVisibility vis = rank == max ? CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS : CreativeModeTab.TabVisibility.PARENT_TAB_ONLY;
            return new Pair(this.createUpgradeEntry(holder, rank), (Object)vis);
        });
    }
}

