/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.item.tool.EnergyBreakerToolItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.util.config.LTXIServerConfig;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyAxeItem
extends EnergyBreakerToolItem {
    private static final int MAX_LOGS_TO_BREAK = 128;

    public EnergyAxeItem(Item.Properties properties, float attackDamage, float attackSpeed) {
        super(properties, attackDamage, attackSpeed, Tool.Rule.deniesDrops((TagKey)BlockTags.INCORRECT_FOR_DIAMOND_TOOL), speed -> List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_AXE, (float)speed.floatValue())));
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_AXE_ACTIONS;
    }

    @Override
    @Nullable
    public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return LTXIEquipmentUpgrades.LTX_MELEE_DEFAULT;
    }

    @Override
    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Player player;
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool == null || !this.hasEnergyForAction(stack)) {
            return false;
        }
        if (!level.isClientSide() && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && miningEntity instanceof Player && !this.chopTree(stack, (ServerLevel)level, state, pos, player = (Player)miningEntity)) {
            this.consumeActionEnergy(player, stack);
        }
        return true;
    }

    @Override
    public boolean canUseToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        if (!super.canUseToolOn(context, level, pos, state, player, stack)) {
            return false;
        }
        if (player == null) {
            return true;
        }
        boolean willUseShield = context.getHand().equals((Object)InteractionHand.MAIN_HAND) && player.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK) && !player.isSecondaryUseActive();
        return !willUseShield;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        BlockState state1 = this.transformBlock(context, level, pos, state, player);
        if (state1 == null) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
                this.consumeActionEnergy((Player)serverPlayer, stack);
            }
            level.setBlock(pos, state1, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state1));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private boolean chopTree(ItemStack stack, ServerLevel level, BlockState originState, BlockPos originPos, Player player) {
        if (!originState.is(BlockTags.LOGS)) {
            return false;
        }
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        ObjectOpenHashSet toBreak = new ObjectOpenHashSet();
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        toBreak.add(originPos);
        toCheck.add(originPos);
        checked.add(originPos);
        int maxLogs = Math.min(128, this.getEnergyStored(stack) / this.getEnergyUsage(stack));
        boolean foundLeaves = false;
        while (!toCheck.isEmpty() && toBreak.size() <= maxLogs) {
            BlockPos pos = (BlockPos)toCheck.poll();
            for (BlockPos visiting : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                if (visiting.equals((Object)pos) || checked.contains(visiting)) continue;
                BlockPos visitingImmutable = visiting.immutable();
                BlockState visitingState = level.getBlockState(visitingImmutable);
                checked.add(visitingImmutable);
                if (visitingState.is(BlockTags.LOGS)) {
                    toBreak.add(visitingImmutable);
                    toCheck.add(visitingImmutable);
                    continue;
                }
                if (foundLeaves || !visitingState.is(BlockTags.LEAVES)) continue;
                foundLeaves = visitingState.hasProperty((Property)BlockStateProperties.PERSISTENT) && (Boolean)visitingState.getValue((Property)BlockStateProperties.PERSISTENT) == false;
            }
        }
        if (!foundLeaves && !LTXIServerConfig.AXE_ALWAYS_CHOPS_LOGS.getAsBoolean()) {
            return false;
        }
        int totalEnergyUsage = this.getEnergyUsage(stack) * toBreak.size();
        if (this.getEnergyStored(stack) < totalEnergyUsage) {
            return false;
        }
        LimaEnergyUtil.extractWithoutLimit((IEnergyStorage)this.getOrCreateEnergyStorage(stack), (int)totalEnergyUsage, (boolean)false);
        ObjectArrayList drops = new ObjectArrayList();
        Vec3 dropsPos = Vec3.atCenterOf((Vec3i)originPos);
        for (BlockPos pos : toBreak) {
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) continue;
            BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
            FluidState fluidState = level.getFluidState(pos);
            Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack).forEach(arg_0 -> EnergyAxeItem.lambda$chopTree$1((List)drops, level, dropsPos, arg_0));
            level.setBlock(pos, fluidState.createLegacyBlock(), 3);
            Vec3 particlePos = Vec3.atCenterOf((Vec3i)pos);
            Vec3 particleDelta = dropsPos.subtract(particlePos).scale((double)0.1f);
            LimaNetworkUtil.sendParticle((Level)level, LTXIParticles.MINI_ELECTRIC_SPARK, (double)32.0, (Vec3)particlePos, (Vec3)particleDelta);
        }
        BlockEntity originBE = originState.hasBlockEntity() ? level.getBlockEntity(originPos) : null;
        CommonHooks.handleBlockDrops((ServerLevel)level, (BlockPos)originPos, (BlockState)originState, (BlockEntity)originBE, (List)drops, (Entity)player, (ItemStack)stack);
        return true;
    }

    @Nullable
    private BlockState transformBlock(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player) {
        BlockState state1 = state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false);
        if (state1 != null) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS);
            return state1;
        }
        state1 = state.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false);
        if (state1 != null) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
            level.levelEvent(player, 3005, pos, 0);
            return state1;
        }
        state1 = state.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false);
        if (state1 != null) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS);
            level.levelEvent(player, 3004, pos, 0);
            return state1;
        }
        return null;
    }

    private static /* synthetic */ void lambda$chopTree$1(List drops, ServerLevel level, Vec3 dropsPos, ItemStack o) {
        drops.add(new ItemEntity((Level)level, dropsPos.x, dropsPos.y, dropsPos.z, o));
    }
}

