/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.Set;
import java.util.function.Supplier;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.util.LimaLootUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.item.EnergyHolderItem;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.EquipmentDamageModifiers;
import liedge.ltxindustries.util.config.LTXIServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public abstract class EnergyBaseToolItem
extends Item
implements EnergyHolderItem,
UpgradableEquipmentItem,
TooltipShiftHintItem,
LimaCreativeTabFillerItem {
    private final float poweredAttackDamage;

    protected EnergyBaseToolItem(Item.Properties properties, float poweredAttackDamage) {
        super(properties);
        this.poweredAttackDamage = poweredAttackDamage;
    }

    protected abstract Set<ItemAbility> getAvailableAbilities();

    public void consumeActionEnergy(Player player, ItemStack stack) {
        if (!player.isCreative()) {
            LimaEnergyUtil.extractWithoutLimit((IEnergyStorage)this.getOrCreateEnergyStorage(stack), (int)this.getEnergyUsage(stack), (boolean)false);
        }
    }

    public boolean hasEnergyForAction(ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyUsage(stack);
    }

    @Override
    public int getBaseEnergyCapacity(ItemStack stack) {
        return LTXIServerConfig.TOOLS_ENERGY_CAPACITY.getAsInt();
    }

    @Override
    public int getBaseEnergyTransferRate(ItemStack stack) {
        return this.getBaseEnergyCapacity(stack) / 40;
    }

    @Override
    public int getBaseEnergyUsage(ItemStack stack) {
        return LTXIServerConfig.TOOLS_ENERGY_PER_ACTION.getAsInt();
    }

    public float getPoweredAttackDamage() {
        return this.poweredAttackDamage;
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        LivingEntity attacker;
        Entity entity;
        if (this.getPoweredAttackDamage() > 0.0f && (entity = damageSource.getDirectEntity()) instanceof LivingEntity && (entity = (attacker = (LivingEntity)entity).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity;
            ItemStack stack = attacker.getWeaponItem();
            if (stack.is((Item)this) && this.hasEnergyForAction(stack)) {
                double upgradedDamage = this.getUpgradedDamage(level, this.getUpgrades(stack), target, damageSource, this.getPoweredAttackDamage());
                LootContext context = LimaLootUtil.entityLootContext((ServerLevel)level, (Entity)target, (DamageSource)damageSource, (LivingEntity)attacker);
                return (float)EquipmentDamageModifiers.getInstance().apply(stack, context, this.getPoweredAttackDamage(), upgradedDamage);
            }
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.poweredAttackDamage > 0.0f && this.hasEnergyForAction(stack);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.poweredAttackDamage > 0.0f && !attacker.level().isClientSide() && attacker instanceof Player) {
            this.consumeActionEnergy((Player)attacker, stack);
        }
    }

    public boolean canUseToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        return this.hasEnergyForAction(stack);
    }

    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        return this.canUseToolOn(context, level, pos, state, player, stack) ? this.useToolOn(context, level, pos, state, player, stack) : InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility ability) {
        return this.hasEnergyForAction(stack) && this.getAvailableAbilities().contains(ability);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return LTXIConstants.REM_BLUE.argb32();
    }

    public int getBarWidth(ItemStack stack) {
        float fill = Math.min(LimaCoreMath.divideFloat((float)this.getEnergyStored(stack), (float)this.getEnergyCapacity(stack)), 1.0f);
        return Math.round(13.0f * fill);
    }

    @Override
    public void appendTooltipHintComponents(@Nullable Level level, ItemStack stack, TooltipLineConsumer consumer) {
        this.appendEquipmentEnergyTooltip(consumer, stack);
    }

    public boolean addDefaultInstanceToCreativeTab(ResourceLocation tabId) {
        return false;
    }

    public void addAdditionalToCreativeTab(ResourceLocation tabId, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, CreativeModeTab.TabVisibility tabVisibility) {
        ItemStack stack = this.createStackWithDefaultUpgrades(parameters.holders());
        stack.set((Supplier)LimaCoreDataComponents.ENERGY, (Object)this.getBaseEnergyCapacity(stack));
        output.accept(stack, tabVisibility);
    }
}

