/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import liedge.ltxindustries.item.tool.EnergyBaseToolItem;
import liedge.ltxindustries.lib.upgrades.effect.MiningRuleUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public abstract class EnergyBreakerToolItem
extends EnergyBaseToolItem {
    private static final float DEFAULT_MINING_SPEED = 9.0f;
    private final ItemAttributeModifiers defaultModifiers;
    @Nullable
    private final Tool.Rule defaultDenyRule;
    private final Function<Float, List<Tool.Rule>> allowRulesFunction;

    private static ItemAttributeModifiers createAttributes(float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    private static Tool createDefaultTool(@Nullable Tool.Rule denyRule, List<Tool.Rule> allowRules) {
        if (denyRule == null) {
            return new Tool(allowRules, 1.0f, 1);
        }
        ObjectArrayList rules = new ObjectArrayList(allowRules.size() + 1);
        rules.add(denyRule);
        rules.addAll(allowRules);
        return new Tool((List)rules, 1.0f, 1);
    }

    private EnergyBreakerToolItem(Item.Properties properties, float poweredAttackDamage, ItemAttributeModifiers defaultModifiers, @Nullable Tool.Rule defaultDenyRule, Function<Float, List<Tool.Rule>> allowRulesFunction) {
        super(properties.component(DataComponents.TOOL, (Object)EnergyBreakerToolItem.createDefaultTool(defaultDenyRule, allowRulesFunction.apply(Float.valueOf(9.0f)))), poweredAttackDamage);
        this.defaultModifiers = defaultModifiers;
        this.defaultDenyRule = defaultDenyRule;
        this.allowRulesFunction = allowRulesFunction;
    }

    protected EnergyBreakerToolItem(Item.Properties properties, Function<Float, List<Tool.Rule>> allowRulesFunction) {
        this(properties, 0.0f, ItemAttributeModifiers.EMPTY, null, allowRulesFunction);
    }

    protected EnergyBreakerToolItem(Item.Properties properties, float poweredAttackDamage, float attackSpeed, @Nullable Tool.Rule defaultDenyRule, Function<Float, List<Tool.Rule>> allowRulesFunction) {
        this(properties, poweredAttackDamage, EnergyBreakerToolItem.createAttributes(attackSpeed), defaultDenyRule, allowRulesFunction);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.defaultModifiers;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool == null || !this.hasEnergyForAction(stack)) {
            return false;
        }
        if (!level.isClientSide() && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && miningEntity instanceof Player) {
            this.consumeActionEnergy((Player)miningEntity, stack);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergyForAction(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.hasEnergyForAction(stack) ? super.getDestroySpeed(stack, state) : 0.0f;
    }

    private List<Tool.Rule> createRules(@Nullable HolderSet<Block> denySet, Collection<HolderSet<Block>> allowSets, float miningSpeed) {
        ObjectArrayList rules = new ObjectArrayList();
        if (denySet != null) {
            if (!denySet.equals((Object)HolderSet.empty())) {
                rules.add(new Tool.Rule(denySet, Optional.empty(), Optional.of(false)));
            }
        } else if (this.defaultDenyRule != null) {
            rules.add(this.defaultDenyRule);
        }
        for (HolderSet<Block> set : allowSets) {
            rules.add(new Tool.Rule(set, Optional.of(Float.valueOf(miningSpeed)), Optional.of(true)));
        }
        rules.addAll((Collection)this.allowRulesFunction.apply(Float.valueOf(miningSpeed)));
        return rules;
    }

    private Tool getDefaultTool() {
        Tool tool = (Tool)this.components().get(DataComponents.TOOL);
        return tool != null ? tool : EnergyBreakerToolItem.createDefaultTool(this.defaultDenyRule, this.allowRulesFunction.apply(Float.valueOf(9.0f)));
    }

    @Override
    public void onUpgradeRefresh(LootContext context, ItemStack stack, EquipmentUpgrades upgrades) {
        super.onUpgradeRefresh(context, stack, upgrades);
        List effects = upgrades.effectFlatStream(LTXIUpgradeEffectComponents.MINING_RULES).sorted().toList();
        if (effects.isEmpty()) {
            stack.set(DataComponents.TOOL, (Object)this.getDefaultTool());
            return;
        }
        HolderSet<Block> denySet = null;
        ObjectArrayList allowSets = new ObjectArrayList();
        float miningSpeed = 9.0f;
        for (MiningRuleUpgradeEffect effect : effects) {
            if (denySet == null && effect.deniedBlocks().isPresent()) {
                denySet = effect.deniedBlocks().get();
            }
            effect.effectiveBlocks().ifPresent(((List)allowSets)::add);
            float speed = effect.miningSpeed().orElse(Float.valueOf(9.0f)).floatValue();
            if (!(speed > miningSpeed)) continue;
            miningSpeed = speed;
        }
        Tool dynamicTool = new Tool(this.createRules(denySet, (Collection<HolderSet<Block>>)allowSets, miningSpeed), 1.0f, 1);
        stack.set(DataComponents.TOOL, (Object)dynamicTool);
    }
}

