/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.Set;
import liedge.ltxindustries.item.tool.EnergyBaseToolItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class EnergyBrushItem
extends EnergyBaseToolItem {
    public EnergyBrushItem(Item.Properties properties) {
        super(properties, 0.0f);
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_BRUSH_ACTIONS;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.hasEnergyForAction(context.getItemInHand()) && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 200;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        HitResult hitResult;
        if (remainingUseDuration >= 0 && livingEntity instanceof Player && (hitResult = this.calculateHitResult(player = (Player)livingEntity)) instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                boolean flag;
                boolean bl = flag = (remainingUseDuration + 1) % 10 == 5;
                if (flag) {
                    BrushableBlockEntity brushable;
                    SoundEvent soundEvent;
                    Block block;
                    HumanoidArm playerArm;
                    BlockPos pos = blockHitResult.getBlockPos();
                    BlockState state = level.getBlockState(pos);
                    HumanoidArm humanoidArm = playerArm = player.getUsedItemHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
                    if (state.shouldSpawnTerrainParticles() && state.getRenderShape() != RenderShape.INVISIBLE) {
                        this.spawnDustParticles(level, blockHitResult, state, player.getViewVector(0.0f), playerArm);
                    }
                    if ((block = state.getBlock()) instanceof BrushableBlock) {
                        BrushableBlock block2 = (BrushableBlock)block;
                        soundEvent = block2.getBrushSound();
                    } else {
                        soundEvent = SoundEvents.BRUSH_GENERIC;
                    }
                    SoundEvent sound = soundEvent;
                    level.playSound(player, pos, sound, SoundSource.BLOCKS);
                    if (!level.isClientSide() && (block = level.getBlockEntity(pos)) instanceof BrushableBlockEntity && (brushable = (BrushableBlockEntity)block).brush(level.getGameTime(), player, blockHitResult.getDirection())) {
                        this.consumeActionEnergy(player, stack);
                    }
                }
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> !e.isSpectator() && e.isPickable(), (double)player.blockInteractionRange());
    }

    private void spawnDustParticles(Level level, BlockHitResult hitResult, BlockState state, Vec3 pos, HumanoidArm arm) {
        BlockParticleOption option = new BlockParticleOption(ParticleTypes.BLOCK, state);
        Direction direction = hitResult.getDirection();
        RandomSource random = level.getRandom();
        Vec3 pPos = hitResult.getLocation();
        Vec3 pDelta = this.particleDelta(pos, direction);
        int armOffset = arm == HumanoidArm.RIGHT ? 1 : -1;
        int count = random.nextInt(7, 12);
        for (int i = 0; i < count; ++i) {
            double xo = direction == Direction.WEST ? (double)1.0E-6f : 0.0;
            double zo = direction == Direction.NORTH ? (double)1.0E-6f : 0.0;
            double dx = pDelta.x * (double)armOffset * 3.0 * random.nextDouble();
            double dz = pDelta.z * (double)armOffset * 3.0 * random.nextDouble();
            level.addParticle((ParticleOptions)option, pPos.x - xo, pPos.y, pPos.z - zo, dx, 0.0, dz);
        }
    }

    private Vec3 particleDelta(Vec3 pos, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> new Vec3(pos.z(), 0.0, -pos.x());
            case Direction.NORTH -> new Vec3(1.0, 0.0, -0.1);
            case Direction.SOUTH -> new Vec3(-1.0, 0.0, 0.1);
            case Direction.WEST -> new Vec3(-0.1, 0.0, -1.0);
            case Direction.EAST -> new Vec3(0.1, 0.0, 1.0);
        };
    }
}

