/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.Set;
import liedge.ltxindustries.item.tool.EnergyBaseToolItem;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class EnergyFishingRodItem
extends EnergyBaseToolItem {
    public EnergyFishingRodItem(Item.Properties properties) {
        super(properties, 0.0f);
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!this.hasEnergyForAction(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.fishing != null) {
            if (!level.isClientSide() && player.fishing.retrieve(stack) > 0) {
                this.consumeActionEnergy(player, stack);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int fishingLuck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player);
                int fishingLureSpeed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player) * 20.0f);
                level.addFreshEntity((Entity)new FishingHook(player, level, fishingLuck, fishingLureSpeed));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

