/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.List;
import java.util.Set;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.item.tool.EnergyBreakerToolItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class EnergyHoeItem
extends EnergyBreakerToolItem {
    public EnergyHoeItem(Item.Properties properties, float attackDamage, float attackSpeed) {
        super(properties, attackDamage, attackSpeed, Tool.Rule.deniesDrops((TagKey)BlockTags.INCORRECT_FOR_DIAMOND_TOOL), speed -> List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_HOE, (float)speed.floatValue())));
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_HOE_ACTIONS;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        if (state.is(LTXITags.Blocks.LTX_HOE_BOOSTABLE) && player != null) {
            player.startUsingItem(context.getHand());
            return InteractionResult.CONSUME;
        }
        BlockState state1 = state.getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        if (state1 == null) {
            return InteractionResult.PASS;
        }
        level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS);
        if (!level.isClientSide()) {
            level.setBlock(pos, state1, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state1));
            if (player != null) {
                this.consumeActionEnergy(player, stack);
            }
        }
        return InteractionResult.sidedSuccess((!level.isClientSide() ? 1 : 0) != 0);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        Level level2;
        if (livingEntity instanceof Player && (level2 = (player = (Player)livingEntity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (remainingUseDuration % 5 == 0) {
                if (this.hasEnergyForAction(stack)) {
                    BlockHitResult blockHitResult;
                    HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> !e.isSpectator() && e.isPickable(), (double)player.blockInteractionRange());
                    if (result instanceof BlockHitResult && (blockHitResult = (BlockHitResult)result).getType() == HitResult.Type.BLOCK) {
                        BlockPos origin = blockHitResult.getBlockPos();
                        boolean boostedBlock = false;
                        Iterable positions = BlockPos.betweenClosed((int)(origin.getX() - 1), (int)(origin.getY() - 1), (int)(origin.getZ() - 1), (int)(origin.getX() + 1), (int)(origin.getY() + 1), (int)(origin.getZ() + 1));
                        for (BlockPos pos : positions) {
                            BlockState state = level.getBlockState(pos);
                            if (!state.is(LTXITags.Blocks.LTX_HOE_BOOSTABLE)) continue;
                            for (int i = 0; i < 3; ++i) {
                                state.randomTick(serverLevel, pos, serverLevel.random);
                            }
                            boostedBlock = true;
                        }
                        if (boostedBlock) {
                            this.consumeActionEnergy(player, stack);
                            level.playSound(null, origin, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                } else {
                    player.stopUsingItem();
                }
            }
        }
    }
}

