/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.Set;
import liedge.ltxindustries.item.tool.EnergyBaseToolItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class EnergyLighterItem
extends EnergyBaseToolItem {
    public EnergyLighterItem(Item.Properties properties) {
        super(properties, 0.0f);
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_FLINT_ACTIONS;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        BlockState state1 = state.getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
        if (state1 == null) {
            BlockPos pos1 = pos.relative(context.getClickedFace());
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos1, (Direction)context.getHorizontalDirection())) {
                level.playSound(player, pos1, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState state2 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos1);
                level.setBlock(pos1, state2, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos1, stack);
                    this.consumeActionEnergy((Player)serverPlayer, stack);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return InteractionResult.FAIL;
        }
        level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        level.setBlock(pos, state1, 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        if (!level.isClientSide() && player != null) {
            this.consumeActionEnergy(player, stack);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

