/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.List;
import java.util.Set;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.item.tool.EnergyBreakerToolItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class EnergyShearsItem
extends EnergyBreakerToolItem {
    public EnergyShearsItem(Item.Properties properties) {
        super(properties, ignored -> List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.LEAVES, (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.WOOL, (float)5.0f), Tool.Rule.overrideSpeed(List.of(Blocks.VINE, Blocks.GLOW_LICHEN), (float)2.0f)));
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_SHEARS_ACTIONS;
    }

    @Override
    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return super.mineBlock(stack, level, state, pos, miningEntity) && state.is(LTXITags.Blocks.SHEARS_HARVESTABLE);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        BlockPos pos;
        Level level;
        IShearable shearable;
        if (!this.hasEnergyForAction(stack)) {
            return InteractionResult.PASS;
        }
        if (interactionTarget instanceof IShearable && (shearable = (IShearable)interactionTarget).isShearable(player, stack, level = interactionTarget.level(), pos = interactionTarget.blockPosition())) {
            List drops = shearable.onSheared(player, stack, level, pos);
            if (!level.isClientSide()) {
                for (ItemStack drop : drops) {
                    shearable.spawnShearedDrop(level, pos, drop);
                }
                this.consumeActionEnergy(player, stack);
            }
            interactionTarget.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        BlockState state1 = state.getToolModifiedState(context, ItemAbilities.SHEARS_TRIM, false);
        if (state1 != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                this.consumeActionEnergy((Player)serverPlayer, stack);
            }
            level.setBlockAndUpdate(pos, state1);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state1));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

