/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.List;
import java.util.Set;
import liedge.ltxindustries.item.tool.EnergyBreakerToolItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class EnergyShovelItem
extends EnergyBreakerToolItem {
    public EnergyShovelItem(Item.Properties properties, float attackDamage, float attackSpeed) {
        super(properties, attackDamage, attackSpeed, Tool.Rule.deniesDrops((TagKey)BlockTags.INCORRECT_FOR_DIAMOND_TOOL), speed -> List.of(Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_SHOVEL, (float)speed.floatValue())));
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return ItemAbilities.DEFAULT_SHOVEL_ACTIONS;
    }

    @Override
    @Nullable
    public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return LTXIEquipmentUpgrades.LTX_SHOVEL_DEFAULT;
    }

    @Override
    public boolean canUseToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        return super.canUseToolOn(context, level, pos, state, player, stack) && context.getClickedFace() != Direction.DOWN;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        BlockState state2;
        BlockState state1 = state.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        if (state1 != null && level.getBlockState(pos.above()).isAir()) {
            level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS);
            state2 = state1;
        } else {
            state2 = state.getToolModifiedState(context, ItemAbilities.SHOVEL_DOUSE, false);
            if (state2 != null && !level.isClientSide()) {
                level.levelEvent(null, 1009, pos, 0);
            }
        }
        if (state2 != null) {
            if (!level.isClientSide()) {
                level.setBlock(pos, state2, 11);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state2));
                if (player != null) {
                    this.consumeActionEnergy(player, stack);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

