/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.tool;

import java.util.List;
import java.util.Set;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.item.LTXIItemAbilities;
import liedge.ltxindustries.item.tool.EnergyBreakerToolItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class EnergyWrenchItem
extends EnergyBreakerToolItem {
    public EnergyWrenchItem(Item.Properties properties) {
        super(properties, speed -> List.of(Tool.Rule.minesAndDrops(LTXITags.Blocks.WRENCH_BREAKABLE, (float)speed.floatValue())));
    }

    @Override
    protected Set<ItemAbility> getAvailableAbilities() {
        return LTXIItemAbilities.WRENCH_ABILITIES;
    }

    @Override
    @Nullable
    public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return LTXIEquipmentUpgrades.LTX_WRENCH_DEFAULT;
    }

    @Override
    protected InteractionResult useToolOn(UseOnContext context, Level level, BlockPos pos, BlockState state, @Nullable Player player, ItemStack stack) {
        Holder.Reference gameEvent;
        boolean isSneaking = player != null && player.isShiftKeyDown();
        ItemAbility ability = isSneaking ? LTXIItemAbilities.WRENCH_DISMANTLE : LTXIItemAbilities.WRENCH_ROTATE;
        BlockState modified = state.getToolModifiedState(context, ability, false);
        if (modified == null) {
            return InteractionResult.PASS;
        }
        Holder.Reference reference = gameEvent = isSneaking ? GameEvent.BLOCK_DESTROY : GameEvent.BLOCK_CHANGE;
        if (!level.isClientSide()) {
            level.setBlock(pos, modified, 11);
            level.gameEvent((Holder)gameEvent, pos, GameEvent.Context.of((Entity)player, (BlockState)modified));
            if (isSneaking) {
                this.consumeActionEnergy(player, stack);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

